/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.probativevalue;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.exception.BackupServiceException;
import fr.gouv.vitam.functional.administration.core.backup.BackupService;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ProbativeReportEntry;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ProbativeReportV2;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class ProbativeCreateReport
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProbativeCreateReport.class);
    private static final String HANDLER_ID = "PROBATIVE_VALUE_CREATE_REPORT";
    private static final TypeReference<JsonLineModel> TYPE_REFERENCE = new TypeReference<JsonLineModel>(){};
    private static final ReportVersion2 REPORT_VERSION_2 = new ReportVersion2();
    private final BackupService backupService;

    @VisibleForTesting
    public ProbativeCreateReport(BackupService backupService) {
        this.backupService = backupService;
    }

    public ProbativeCreateReport() {
        this(new BackupService());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            if (!handler.isExistingFileInWorkspace("distributionFile.jsonl")) {
                return PluginHelper.buildItemStatus(HANDLER_ID, StatusCode.WARNING);
            }
            String reportFileName = param.getContainerName() + ".json";
            this.generateReportToWorkspace(param, handler, reportFileName);
            this.storeReportToOffers(handler, reportFileName);
            return PluginHelper.buildItemStatusWithMasterData(HANDLER_ID, StatusCode.OK, PluginHelper.EventDetails.of("Probative value report success."), JsonHandler.unprettyPrint((Object)REPORT_VERSION_2));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(HANDLER_ID, StatusCode.FATAL, PluginHelper.EventDetails.of("Probative value report error."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReportToWorkspace(WorkerParameters param, HandlerIO handler, String reportFileName) throws IOException, InvalidParseOperationException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException, ProcessingException {
        if (handler.isExistingFileInWorkspace(reportFileName)) {
            return;
        }
        File reportFile = handler.getNewLocalFile(reportFileName);
        try (InputStream inputStream = handler.getInputStreamFromWorkspace("distributionFile.jsonl");
             JsonLineGenericIterator lines = new JsonLineGenericIterator(inputStream, TYPE_REFERENCE);){
            JsonNode context = JsonHandler.getFromFile((File)handler.getFileFromWorkspace("request"));
            List<ProbativeReportEntry> probativeEntries = lines.stream().map(line -> this.getFromFile(handler, (JsonLineModel)line)).collect(Collectors.toList());
            ReportResults reportResults = new ReportResults(Integer.valueOf((int)probativeEntries.stream().filter(e -> e.getStatus().equals((Object)StatusCode.OK)).count()), Integer.valueOf((int)probativeEntries.stream().filter(e -> e.getStatus().equals((Object)StatusCode.KO)).count()), Integer.valueOf((int)probativeEntries.stream().filter(e -> e.getStatus().equals((Object)StatusCode.WARNING)).count()));
            String startDate = probativeEntries.stream().min(Comparator.comparing(ProbativeReportEntry::getEvStartDateTime)).map(ProbativeReportEntry::getEvStartDateTime).orElse("NO_START_DATE_FOUND");
            String endDate = probativeEntries.stream().max(Comparator.comparing(ProbativeReportEntry::getEvEndDateTime)).map(ProbativeReportEntry::getEvEndDateTime).orElse("NO_END_DATE_FOUND");
            ReportSummary reportSummary = new ReportSummary(startDate, endDate, ReportType.PROBATIVE_VALUE, reportResults, null);
            StatusCode outcome = this.getOutcome(reportResults);
            String evType = param.getWorkflowIdentifier();
            OperationSummary operationSummary = new OperationSummary(VitamThreadUtils.getVitamSession().getTenantId(), param.getContainerName(), evType, outcome.name(), this.getOutDetail(outcome, evType), this.getOutMsg(outcome, evType), this.getRightStatement(VitamThreadUtils.getVitamSession().getContractId()), null);
            ProbativeReportV2 probativeReportV2 = new ProbativeReportV2(operationSummary, reportSummary, context, probativeEntries);
            JsonHandler.writeAsFile((Object)probativeReportV2, (File)reportFile);
            handler.transferAtomicFileToWorkspace(reportFileName, reportFile);
        }
        finally {
            FileUtils.deleteQuietly((File)reportFile);
        }
    }

    private void storeReportToOffers(HandlerIO handler, String reportFileName) throws BackupServiceException {
        this.backupService.storeIntoOffers(handler.getContainerName(), reportFileName, DataCategory.REPORT, reportFileName, VitamConfiguration.getDefaultStrategy());
    }

    private String getOutMsg(StatusCode outcome, String probativeValue) {
        return VitamLogbookMessages.getFromFullCodeKey((String)VitamLogbookMessages.getCodeOp((String)probativeValue, (StatusCode)outcome));
    }

    private String getOutDetail(StatusCode outcome, String probativeValue) {
        return String.format("%s.%s", probativeValue, outcome.name());
    }

    private JsonNode getRightStatement(String rightStatementIdentifier) {
        return JsonHandler.createObjectNode().put("AccessContract", rightStatementIdentifier);
    }

    private StatusCode getOutcome(ReportResults reportResults) {
        if (reportResults.getNbOk().equals(reportResults.getTotal())) {
            return StatusCode.OK;
        }
        if (reportResults.getNbKo().equals(reportResults.getTotal())) {
            return StatusCode.KO;
        }
        return StatusCode.WARNING;
    }

    private ProbativeReportEntry getFromFile(HandlerIO handler, JsonLineModel line) {
        try {
            return (ProbativeReportEntry)JsonHandler.getFromFile((File)handler.getFileFromWorkspace(line.getId()), ProbativeReportEntry.class);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new VitamRuntimeException(e);
        }
    }

    protected static class ReportVersion2 {
        @JsonProperty(value="probativeReportVersion")
        private final int probativeReportVersion = 2;

        protected ReportVersion2() {
        }
    }
}

