/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.probativevalue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.ExistsQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.unit.SigningRoleType;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.SelectedUnit;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class ProbativeCreateDistributionFile
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProbativeCreateDistributionFile.class);
    private static final String HANDLER_ID = "PROBATIVE_VALUE_CREATE_DISTRIBUTION_FILE";
    private final MetaDataClientFactory metaDataClientFactory;

    @VisibleForTesting
    public ProbativeCreateDistributionFile(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ProbativeCreateDistributionFile() {
        this(MetaDataClientFactory.getInstance());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            ProbativeValueRequest probativeValueRequest = ProbativeCreateDistributionFile.loadRequest(handler);
            List<SelectedUnit> selectedUnitsWithInitialQuery = this.selectInitialQueryUnits(probativeValueRequest);
            Collection<SelectedUnit> extendedResultSet = this.extendResultSetWithDetachedSigningInformation(selectedUnitsWithInitialQuery, probativeValueRequest);
            String usageVersion = String.format("%s_%s", probativeValueRequest.getUsage(), probativeValueRequest.getVersion());
            File objectGroupsToCheck = this.generateDistributionFile(handler, extendedResultSet, usageVersion);
            handler.transferFileToWorkspace("distributionFile.jsonl", objectGroupsToCheck, false, false);
            return PluginHelper.buildItemStatus(HANDLER_ID, StatusCode.OK, PluginHelper.EventDetails.of("Creation of distribution file succeed."));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(HANDLER_ID, StatusCode.KO, PluginHelper.EventDetails.of("Creation of distribution file error."));
        }
    }

    private static ProbativeValueRequest loadRequest(HandlerIO handler) throws ProcessingStatusException {
        try {
            InputStream request = handler.getInputStreamFromWorkspace("request");
            return (ProbativeValueRequest)JsonHandler.getFromInputStream((InputStream)request, ProbativeValueRequest.class);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Cannot load request from workspace", e);
        }
    }

    private List<SelectedUnit> selectInitialQueryUnits(ProbativeValueRequest probativeValueRequest) throws ProcessingStatusException {
        SelectMultiQuery initialSelectQuery = this.buildInitialSelectQuery(probativeValueRequest);
        return this.executeQuery(initialSelectQuery);
    }

    private SelectMultiQuery buildInitialSelectQuery(ProbativeValueRequest probativeValueRequest) throws ProcessingStatusException {
        boolean signingInformationAuditMode = ProbativeCreateDistributionFile.includeDetachedSigningInformation(probativeValueRequest);
        try {
            JsonNode initialQuery = probativeValueRequest.getDslQuery();
            JsonNode restrictedQuery = ProbativeCreateDistributionFile.getRestrictedQueryWithAccessContract(initialQuery);
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(restrictedQuery);
            SelectMultiQuery select = parser.getRequest();
            ExistsQuery unitsHavingObjectGroupsQuery = QueryHelper.exists((String)VitamFieldsHelper.object());
            if (select.getQueries().isEmpty()) {
                select.getQueries().add(unitsHavingObjectGroupsQuery.setDepthLimit(0));
            } else {
                int lastQueryIndex = select.getQueries().size() - 1;
                Query lastQuery = (Query)select.getQueries().get(lastQueryIndex);
                int lastQueryDepth = lastQuery.getParserRelativeDepth();
                Query queryExistObject = QueryHelper.and().add(new Query[]{lastQuery, unitsHavingObjectGroupsQuery}).setDepthLimit(lastQueryDepth);
                select.getQueries().set(lastQueryIndex, queryExistObject);
            }
            select.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.object()});
            if (signingInformationAuditMode) {
                select.addUsedProjection(new String[]{"SigningInformation.DetachedSigningRole"});
            }
            return select;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not build select query", e);
        }
    }

    private List<SelectedUnit> executeQuery(SelectMultiQuery selectQuery) throws ProcessingStatusException {
        List<SelectedUnit> list;
        block8: {
            MetaDataClient metadataClient = this.metaDataClientFactory.getClient();
            try {
                ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(metadataClient, selectQuery);
                list = scrollRequest.toStream().filter(unit -> unit.hasNonNull(VitamFieldsHelper.object())).map(SelectedUnit::fromUnit).collect(Collectors.toList());
                if (metadataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metadataClient != null) {
                        try {
                            metadataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could not execute select query", e);
                }
            }
            metadataClient.close();
        }
        return list;
    }

    private Collection<SelectedUnit> extendResultSetWithDetachedSigningInformation(List<SelectedUnit> initialResultSet, ProbativeValueRequest probativeValueRequest) throws ProcessingStatusException {
        if (!ProbativeCreateDistributionFile.includeDetachedSigningInformation(probativeValueRequest)) {
            LOGGER.info("No need for Detached SigningInformation to be added to result set");
            return initialResultSet;
        }
        Map<String, SelectedUnit> totalSelectedUnitsByUnitId = initialResultSet.stream().collect(Collectors.toMap(SelectedUnit::getUnitId, selectedUnit -> selectedUnit));
        Iterator unitIdsWithDetachedSigningRoles = initialResultSet.stream().filter(SelectedUnit::isHaveDetachedSigningRoles).map(SelectedUnit::getUnitId).iterator();
        UnmodifiableIterator partitionedUnitIdsWithDetachedSigningRoles = Iterators.partition(unitIdsWithDetachedSigningRoles, (int)VitamConfiguration.getMaxElasticsearchBulk());
        while (partitionedUnitIdsWithDetachedSigningRoles.hasNext()) {
            List unitIds = (List)partitionedUnitIdsWithDetachedSigningRoles.next();
            SelectMultiQuery select = ProbativeCreateDistributionFile.buildSelectQueryForDetachedSigningInformationChildUnits(unitIds);
            List<SelectedUnit> detachedSigningInformationUnits = this.executeQuery(select);
            for (SelectedUnit unit : detachedSigningInformationUnits) {
                totalSelectedUnitsByUnitId.put(unit.getUnitId(), unit);
            }
        }
        return totalSelectedUnitsByUnitId.values();
    }

    private static SelectMultiQuery buildSelectQueryForDetachedSigningInformationChildUnits(Collection<String> unitIds) throws ProcessingStatusException {
        try {
            SelectMultiQuery select = new SelectMultiQuery();
            select.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.in((String)VitamFieldsHelper.unitups(), (String[])((String[])unitIds.toArray(String[]::new))), QueryHelper.exists((String)"SigningInformation.SigningRole"), QueryHelper.ne((String)"SigningInformation.SigningRole", (String)SigningRoleType.SIGNED_DOCUMENT.getValue())})});
            select.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.object()});
            select.addOrderByAscFilter(new String[]{VitamFieldsHelper.object()});
            return select;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not select detached SigningInformation entries", e);
        }
    }

    @Beta
    private static JsonNode getRestrictedQueryWithAccessContract(JsonNode query) {
        return query;
    }

    private static boolean includeDetachedSigningInformation(ProbativeValueRequest probativeValueRequest) {
        return Boolean.TRUE.equals(probativeValueRequest.getIncludeDetachedSigningInformation());
    }

    private File generateDistributionFile(HandlerIO handler, Collection<SelectedUnit> extendedResult, String usageVersion) throws IOException, InvalidParseOperationException {
        File objectGroupsToCheck = handler.getNewLocalFile("OBJECT_GROUP_TO_CHECK.jsonl");
        try (FileOutputStream fileOutputStream = new FileOutputStream(objectGroupsToCheck);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)fileOutputStream);){
            ArrayListValuedHashMap unitIdsByObjectGroupId = new ArrayListValuedHashMap();
            for (SelectedUnit selectedUnit : extendedResult) {
                unitIdsByObjectGroupId.put((Object)selectedUnit.getObjectGroupId(), (Object)selectedUnit.getUnitId());
            }
            for (String objectGroupId : unitIdsByObjectGroupId.keySet()) {
                Collection unitIds = unitIdsByObjectGroupId.get((Object)objectGroupId);
                writer.addEntry(this.toJsonLineDistribution(objectGroupId, usageVersion, unitIds));
            }
        }
        return objectGroupsToCheck;
    }

    private JsonLineModel toJsonLineDistribution(String objectId, String usageVersion, Collection<String> elementIds) throws InvalidParseOperationException {
        ObjectNode objectNode = JsonHandler.createObjectNode();
        objectNode.set("unitIds", JsonHandler.toJsonNode(elementIds));
        objectNode.put("usageVersion", usageVersion);
        JsonLineModel model = new JsonLineModel();
        model.setId(objectId);
        model.setParams((JsonNode)objectNode);
        model.setDistribGroup(null);
        return model;
    }
}

