/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation.model;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.PreservationStatus;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ActionTypePreservation;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ExtractedMetadata;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ExtractedMetadataForAu;
import fr.gouv.vitam.worker.core.plugin.preservation.model.OutputPreservation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class WorkflowBatchResult {
    private final String gotId;
    private final String unitId;
    private final String targetUse;
    private final String sourceUse;
    private final String sourceStrategy;
    private final String requestId;
    private final List<OutputExtra> outputExtras;
    private final List<String> unitsForExtractionAU;
    private final StatusCode globalStatus;

    private WorkflowBatchResult(String gotId, String unitId, String targetUse, String requestId, List<OutputExtra> outputExtras, StatusCode globalStatus, String sourceUse, String sourceStrategy, List<String> unitsForExtractionAU) {
        this.gotId = gotId;
        this.unitId = unitId;
        this.targetUse = targetUse;
        this.requestId = requestId;
        this.outputExtras = outputExtras;
        this.globalStatus = globalStatus;
        this.sourceUse = sourceUse;
        this.sourceStrategy = sourceStrategy;
        this.unitsForExtractionAU = unitsForExtractionAU;
    }

    public static WorkflowBatchResult of(String gotId, String unitId, String targetUse, String requestId, List<OutputExtra> outputExtras, String sourceUse, String sourceStrategy, List<String> unitsForExtractionAU) {
        return new WorkflowBatchResult(gotId, unitId, targetUse, requestId, Collections.unmodifiableList(outputExtras), WorkflowBatchResult.globalStatusFromOutputExtras(outputExtras), sourceUse, sourceStrategy, unitsForExtractionAU);
    }

    public static WorkflowBatchResult of(WorkflowBatchResult workflowBatchResult, List<OutputExtra> outputExtras) {
        return new WorkflowBatchResult(workflowBatchResult.getGotId(), workflowBatchResult.getUnitId(), workflowBatchResult.getTargetUse(), workflowBatchResult.getRequestId(), Collections.unmodifiableList(outputExtras), WorkflowBatchResult.globalStatusFromOutputExtras(outputExtras), workflowBatchResult.getSourceUse(), workflowBatchResult.getSourceStrategy(), workflowBatchResult.getUnitsForExtractionAU());
    }

    private static StatusCode globalStatusFromOutputExtras(List<OutputExtra> outputExtras) {
        List statuses = outputExtras.stream().map(o -> o.getOutput().getStatus()).map(s -> s.equals((Object)PreservationStatus.OK) ? PreservationStatus.OK : PreservationStatus.KO).distinct().collect(Collectors.toList());
        if (statuses.isEmpty()) {
            return StatusCode.KO;
        }
        if (statuses.size() > 1) {
            return StatusCode.WARNING;
        }
        return ((PreservationStatus)statuses.get(0)).equals((Object)PreservationStatus.OK) ? StatusCode.OK : StatusCode.KO;
    }

    public String getGotId() {
        return this.gotId;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTargetUse() {
        return this.targetUse;
    }

    public String getSourceUse() {
        return this.sourceUse;
    }

    public String getSourceStrategy() {
        return this.sourceStrategy;
    }

    public List<OutputExtra> getOutputExtras() {
        return this.outputExtras;
    }

    public StatusCode getGlobalStatus() {
        return this.globalStatus;
    }

    public List<String> getUnitsForExtractionAU() {
        return this.unitsForExtractionAU;
    }

    public static class OutputExtra {
        private final OutputPreservation output;
        private final String binaryGUID;
        private final Optional<Long> size;
        private final Optional<String> binaryHash;
        private final Optional<FormatIdentifierResponse> binaryFormat;
        private final Optional<StoredInfoResult> storedInfo;
        private final Optional<ExtractedMetadata> extractedMetadataGOT;
        private final Optional<ExtractedMetadataForAu> extractedMetadataAU;
        private final Optional<String> error;

        @VisibleForTesting
        public OutputExtra(OutputPreservation output, String binaryGUID, Optional<Long> size, Optional<String> binaryHash, Optional<FormatIdentifierResponse> binaryFormat, Optional<StoredInfoResult> storedInfo, Optional<ExtractedMetadata> extractedMetadataGOT, Optional<ExtractedMetadataForAu> extractedMetadataAU, Optional<String> error) {
            this.output = output;
            this.binaryGUID = binaryGUID;
            this.size = size;
            this.binaryHash = binaryHash;
            this.binaryFormat = binaryFormat;
            this.storedInfo = storedInfo;
            this.extractedMetadataGOT = extractedMetadataGOT;
            this.extractedMetadataAU = extractedMetadataAU;
            this.error = error;
        }

        public static OutputExtra of(OutputPreservation output) {
            return new OutputExtra(output, GUIDFactory.newGUID().getId(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public static OutputExtra withBinaryHashAndSize(OutputExtra outputExtra, String binaryHash, long size) {
            return new OutputExtra(outputExtra.getOutput(), outputExtra.getBinaryGUID(), Optional.of(size), Optional.of(binaryHash), outputExtra.getBinaryFormat(), outputExtra.getStoredInfo(), outputExtra.getExtractedMetadataGOT(), outputExtra.getExtractedMetadataAU(), outputExtra.getError());
        }

        public static OutputExtra withBinaryFormat(OutputExtra outputExtra, FormatIdentifierResponse binaryFormat) {
            return new OutputExtra(outputExtra.getOutput(), outputExtra.getBinaryGUID(), outputExtra.getSize(), outputExtra.getBinaryHash(), Optional.of(binaryFormat), outputExtra.getStoredInfo(), outputExtra.getExtractedMetadataGOT(), outputExtra.getExtractedMetadataAU(), outputExtra.getError());
        }

        public static OutputExtra withStoredInfo(OutputExtra outputExtra, StoredInfoResult storedInfo) {
            return new OutputExtra(outputExtra.getOutput(), outputExtra.getBinaryGUID(), outputExtra.getSize(), outputExtra.getBinaryHash(), outputExtra.getBinaryFormat(), Optional.of(storedInfo), outputExtra.getExtractedMetadataGOT(), outputExtra.getExtractedMetadataAU(), outputExtra.getError());
        }

        public static OutputExtra withExtractedMetadataForGot(OutputExtra outputExtra, ExtractedMetadata extractedMetadataGOT) {
            return new OutputExtra(outputExtra.getOutput(), outputExtra.getBinaryGUID(), outputExtra.getSize(), outputExtra.getBinaryHash(), outputExtra.getBinaryFormat(), outputExtra.getStoredInfo(), Optional.of(extractedMetadataGOT), outputExtra.getExtractedMetadataAU(), outputExtra.getError());
        }

        public static OutputExtra withExtractedMetadataForAu(OutputExtra outputExtra, ExtractedMetadataForAu extractedMetadataAU) {
            return new OutputExtra(outputExtra.getOutput(), outputExtra.getBinaryGUID(), outputExtra.getSize(), outputExtra.getBinaryHash(), outputExtra.getBinaryFormat(), outputExtra.getStoredInfo(), outputExtra.getExtractedMetadataGOT(), Optional.of(extractedMetadataAU), outputExtra.getError());
        }

        public static OutputExtra inError(String errorMessage) {
            return new OutputExtra(null, "ERROR", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(errorMessage));
        }

        public OutputPreservation getOutput() {
            return this.output;
        }

        public String getBinaryGUID() {
            return this.binaryGUID;
        }

        public Optional<Long> getSize() {
            return this.size;
        }

        public Optional<String> getBinaryHash() {
            return this.binaryHash;
        }

        public Optional<FormatIdentifierResponse> getBinaryFormat() {
            return this.binaryFormat;
        }

        public Optional<StoredInfoResult> getStoredInfo() {
            return this.storedInfo;
        }

        public Optional<String> getError() {
            return this.error;
        }

        public Optional<ExtractedMetadata> getExtractedMetadataGOT() {
            return this.extractedMetadataGOT;
        }

        public Optional<ExtractedMetadataForAu> getExtractedMetadataAU() {
            return this.extractedMetadataAU;
        }

        public boolean isOkAndGenerated() {
            return this.getOutput().getAction().equals((Object)ActionTypePreservation.GENERATE) && this.getOutput().getStatus().equals((Object)PreservationStatus.OK);
        }

        public boolean isInError() {
            return this.error.isPresent();
        }

        public boolean isOkAndIdentify() {
            return this.getOutput().getAction().equals((Object)ActionTypePreservation.IDENTIFY) && this.getOutput().getStatus().equals((Object)PreservationStatus.OK);
        }

        public boolean isOkAndExtractedGot() {
            return this.getOutput().getAction().equals((Object)ActionTypePreservation.EXTRACT) && this.getOutput().getStatus().equals((Object)PreservationStatus.OK);
        }

        public boolean isOkAndExtractedAu() {
            return this.getOutput().getAction().equals((Object)ActionTypePreservation.EXTRACT_AU) && this.getOutput().getStatus().equals((Object)PreservationStatus.OK);
        }
    }
}

