/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.json.Difference;
import fr.gouv.vitam.common.json.Differences;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ActionTypePreservation;
import fr.gouv.vitam.common.model.objectgroup.DbFileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.DbFormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.DbObjectGroupModel;
import fr.gouv.vitam.common.model.objectgroup.DbQualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.DbStorageModel;
import fr.gouv.vitam.common.model.objectgroup.DbVersionsModel;
import fr.gouv.vitam.common.model.preservation.OtherMetadata;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.preservation.PreservationGenerateBinaryHash;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ExtractedMetadata;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public class PreservationUpdateObjectGroupPlugin
extends ActionHandler {
    private static final String PLUGIN_NAME = "PRESERVATION_INDEXATION_METADATA";
    private static final String RAW_METADATA = "RawMetadata";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationUpdateObjectGroupPlugin.class);
    private final MetaDataClientFactory metaDataClientFactory;

    public PreservationUpdateObjectGroupPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    PreservationUpdateObjectGroupPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) {
        LOGGER.info("Starting {}", (Object)PLUGIN_NAME);
        WorkflowBatchResults results = (WorkflowBatchResults)handler.getInput(0);
        List<WorkflowBatchResult> workflowBatchResults = results.getWorkflowBatchResults();
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            List<ItemStatus> list = workflowBatchResults.stream().map(w -> this.updateObjectGroupModel((WorkflowBatchResult)w, metaDataClient)).collect(Collectors.toList());
            return list;
        }
    }

    private ItemStatus updateObjectGroupModel(WorkflowBatchResult batchResult, MetaDataClient metaDataClient) {
        List outputExtras = batchResult.getOutputExtras().stream().filter(outputExtra -> !outputExtra.isInError()).collect(Collectors.toList());
        List<WorkflowBatchResult.OutputExtra> generateOkActions = outputExtras.stream().filter(WorkflowBatchResult.OutputExtra::isOkAndGenerated).collect(Collectors.toList());
        List identifyOkActions = outputExtras.stream().filter(WorkflowBatchResult.OutputExtra::isOkAndIdentify).collect(Collectors.toList());
        List extractedOkActions = outputExtras.stream().filter(WorkflowBatchResult.OutputExtra::isOkAndExtractedGot).collect(Collectors.toList());
        if (generateOkActions.isEmpty() && identifyOkActions.isEmpty() && extractedOkActions.isEmpty()) {
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of("No changes")).disableLfc();
        }
        Stream<String> subItemIds = Stream.of(identifyOkActions.stream().map(WorkflowBatchResult.OutputExtra::getBinaryGUID), generateOkActions.stream().map(WorkflowBatchResult.OutputExtra::getBinaryGUID), extractedOkActions.stream().map(WorkflowBatchResult.OutputExtra::getBinaryGUID)).flatMap(Function.identity()).distinct();
        try {
            RequestResponse requestResponse = metaDataClient.getObjectGroupByIdRaw(batchResult.getGotId());
            if (!requestResponse.isOk()) {
                return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("ObjectGroup not found %s", batchResult.getGotId())));
            }
            JsonNode firstResult = (JsonNode)((RequestResponseOK)requestResponse).getFirstResult();
            DbObjectGroupModel dbObjectGroupModel = (DbObjectGroupModel)JsonHandler.getFromJsonNode((JsonNode)firstResult, DbObjectGroupModel.class);
            ArrayList differences = new ArrayList();
            List<DbQualifiersModel> qualifiersWithIdentification = dbObjectGroupModel.getQualifiers().stream().map(qualifier -> this.mapQualifierBinary(batchResult, (DbQualifiersModel)qualifier, identifyOkActions, differences)).map(qualifier -> this.mapQualifierBinary(batchResult, (DbQualifiersModel)qualifier, extractedOkActions, differences)).collect(Collectors.toList());
            List<DbQualifiersModel> finalQualifiersToUpdate = this.addGeneratedQualifiersIfUpdate(batchResult, generateOkActions, qualifiersWithIdentification);
            List differencesFiltered = differences.stream().filter(Difference::hasDifference).collect(Collectors.toList());
            if (differencesFiltered.isEmpty() && generateOkActions.isEmpty()) {
                ItemStatus itemStatus = new ItemStatus(PLUGIN_NAME);
                return itemStatus.disableLfc();
            }
            Optional<Integer> totalBinarySize = finalQualifiersToUpdate.stream().map(DbQualifiersModel::getNbc).reduce(Integer::sum);
            if (totalBinarySize.isEmpty()) {
                throw new IllegalStateException("total binaries for objectGroup nbc is absent");
            }
            HashMap<String, JsonNode> action = new HashMap<String, JsonNode>();
            action.put(BuilderToken.PROJECTIONARGS.QUALIFIERS.exactToken(), JsonHandler.toJsonNode(finalQualifiersToUpdate));
            SetAction setQualifier = new SetAction(action);
            UpdateMultiQuery query = new UpdateMultiQuery();
            query.addHintFilter(new String[]{BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken()});
            query.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{batchResult.getRequestId()}), UpdateActionHelper.set((String)VitamFieldsHelper.nbobjects(), (long)totalBinarySize.get().intValue()), setQualifier});
            metaDataClient.updateObjectGroupById((JsonNode)query.getFinalUpdate(), batchResult.getGotId());
            return PluginHelper.buildItemStatusSubItems(PLUGIN_NAME, subItemIds, StatusCode.OK, new Differences(differencesFiltered));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatusSubItems(PLUGIN_NAME, subItemIds, StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("FATAL ERROR IN %s ACTION.", PLUGIN_NAME))).disableLfc();
        }
    }

    private List<DbQualifiersModel> addGeneratedQualifiersIfUpdate(WorkflowBatchResult batchResult, List<WorkflowBatchResult.OutputExtra> generateOkActions, List<DbQualifiersModel> qualifiers) {
        if (generateOkActions.isEmpty()) {
            return qualifiers;
        }
        DbQualifiersModel qualifierModelToUpdate = this.findQualifier(batchResult, qualifiers);
        int lastVersion = this.getLastVersion(qualifierModelToUpdate);
        List versionsModelToInsert = IntStream.range(0, generateOkActions.size()).mapToObj(i -> this.createVersion((WorkflowBatchResult.OutputExtra)generateOkActions.get(i), batchResult, lastVersion + i + 1)).collect(Collectors.toList());
        List versions = qualifierModelToUpdate.getVersions();
        versions.addAll(versionsModelToInsert);
        qualifierModelToUpdate.setNbc(versions.size());
        List<DbQualifiersModel> updatedQualifiers = qualifiers.stream().filter(qualifier -> !qualifier.getQualifier().equals(qualifierModelToUpdate.getQualifier())).collect(Collectors.toList());
        updatedQualifiers.add(qualifierModelToUpdate);
        return updatedQualifiers;
    }

    private int getLastVersion(DbQualifiersModel qualifierModelToUpdate) {
        return qualifierModelToUpdate.getVersions().stream().map(DbVersionsModel::getDataObjectVersion).map(dataObjectVersion -> dataObjectVersion.split("_")[1]).map(Integer::parseInt).max(Comparator.naturalOrder()).orElse(0);
    }

    private DbQualifiersModel findQualifier(WorkflowBatchResult batchResult, List<DbQualifiersModel> qualifiers) {
        if (batchResult.getSourceUse().equals(batchResult.getTargetUse())) {
            return qualifiers.stream().filter(qualifier -> qualifier.getQualifier().equals(batchResult.getSourceUse())).map(q -> new DbQualifiersModel(q.getQualifier(), q.getNbc(), new ArrayList(q.getVersions()))).findFirst().orElseThrow(() -> new VitamRuntimeException(String.format("No 'Qualifier' %s for 'ObjectGroup' %s.", batchResult.getSourceUse(), batchResult.getGotId())));
        }
        return qualifiers.stream().filter(qualifier -> qualifier.getQualifier().equals(batchResult.getTargetUse())).findFirst().orElse(new DbQualifiersModel(batchResult.getTargetUse(), 0, new ArrayList()));
    }

    private DbQualifiersModel mapQualifierBinary(WorkflowBatchResult batchResult, DbQualifiersModel qualifier, List<WorkflowBatchResult.OutputExtra> actions, List<Difference> differences) {
        if (actions.isEmpty() || !qualifier.getQualifier().equals(batchResult.getSourceUse())) {
            return qualifier;
        }
        List versions = qualifier.getVersions().stream().map(v -> this.mapVersionModel(actions, (DbVersionsModel)v, differences)).collect(Collectors.toList());
        return new DbQualifiersModel(qualifier.getQualifier(), qualifier.getNbc(), versions);
    }

    private DbVersionsModel mapVersionModel(List<WorkflowBatchResult.OutputExtra> actions, DbVersionsModel version, List<Difference> differences) {
        return actions.stream().filter(o -> o.getOutput().getInputPreservation().getName().equals(version.getId())).findFirst().map(outputExtra -> ActionTypePreservation.IDENTIFY.equals((Object)outputExtra.getOutput().getAction()) ? this.createNewVersionIdentified((WorkflowBatchResult.OutputExtra)outputExtra, version, differences) : this.createNewVersionExtracted((WorkflowBatchResult.OutputExtra)outputExtra, version, differences)).orElse(version);
    }

    private DbVersionsModel createNewVersionIdentified(WorkflowBatchResult.OutputExtra outputExtra, DbVersionsModel version, List<Difference> differences) {
        DbFormatIdentificationModel format = outputExtra.getOutput().getFormatIdentification();
        if (format == null) {
            throw new VitamRuntimeException("FormatIdentification cannot be null.");
        }
        Difference difference = format.difference((Object)version.getFormatIdentificationModel());
        if (difference.hasDifference()) {
            differences.add(difference);
            return DbVersionsModel.newVersionsFrom((DbVersionsModel)version, (DbFormatIdentificationModel)format);
        }
        return version;
    }

    private DbVersionsModel createNewVersionExtracted(WorkflowBatchResult.OutputExtra outputExtra, DbVersionsModel version, List<Difference> differences) {
        Optional<ExtractedMetadata> extractedMetadata = outputExtra.getExtractedMetadataGOT();
        if (extractedMetadata.isEmpty()) {
            throw new VitamRuntimeException("ExtractedMetadata cannot be null.");
        }
        Difference diffOtherMetadataToAdd = new Difference(OtherMetadata.class.getSimpleName());
        OtherMetadata oldMetadata = version.getOtherMetadata();
        OtherMetadata newOtherMetadata = new OtherMetadata((Map)oldMetadata);
        OtherMetadata extractedOtherMetadata = extractedMetadata.get().getOtherMetadata();
        String extractedRawMetadata = extractedMetadata.get().getRawMetadata();
        if (extractedRawMetadata != null) {
            if (extractedRawMetadata.length() > VitamConfiguration.getTextMaxLength()) {
                newOtherMetadata.put((Object)RAW_METADATA, new ArrayList(Splitter.fixedLength((int)VitamConfiguration.getTextMaxLength()).splitToList((CharSequence)extractedRawMetadata)));
            } else {
                newOtherMetadata.put((Object)RAW_METADATA, Collections.singletonList(extractedRawMetadata));
            }
        }
        if (extractedOtherMetadata == null || extractedOtherMetadata.isEmpty()) {
            diffOtherMetadataToAdd.add(RAW_METADATA, Collections.emptyList(), Collections.singletonList(extractedRawMetadata));
        } else {
            extractedOtherMetadata.forEach((key, value) -> {
                List oldValue = (List)oldMetadata.get(key);
                if (oldValue != null) {
                    ArrayList union = new ArrayList(CollectionUtils.union((Iterable)oldValue, (Iterable)value));
                    diffOtherMetadataToAdd.add(key, (Object)oldValue, union);
                    newOtherMetadata.put(key, union);
                } else {
                    diffOtherMetadataToAdd.add(key, Collections.emptyList(), value);
                    newOtherMetadata.put(key, value);
                }
            });
        }
        if (diffOtherMetadataToAdd.hasDifference()) {
            differences.add(diffOtherMetadataToAdd);
            return DbVersionsModel.newVersionsFrom((DbVersionsModel)version, (OtherMetadata)newOtherMetadata);
        }
        return version;
    }

    private DbVersionsModel createVersion(WorkflowBatchResult.OutputExtra outputExtra, WorkflowBatchResult workflowBatchResult, Integer newDataObjectVersion) {
        boolean allInformationNeeded;
        Optional<FormatIdentifierResponse> formatIdentifierResponse = outputExtra.getBinaryFormat();
        boolean bl = allInformationNeeded = formatIdentifierResponse.isPresent() && outputExtra.getBinaryHash().isPresent() && outputExtra.getSize().isPresent() && outputExtra.getStoredInfo().isPresent();
        if (!allInformationNeeded) {
            throw new VitamRuntimeException("Cannot update this version model, mission information.");
        }
        DbVersionsModel versionModel = new DbVersionsModel();
        versionModel.setId(outputExtra.getBinaryGUID());
        versionModel.setDataObjectGroupId(workflowBatchResult.getGotId());
        versionModel.setDataObjectVersion(workflowBatchResult.getTargetUse() + "_" + newDataObjectVersion);
        versionModel.setOpi(workflowBatchResult.getRequestId());
        versionModel.setAlgorithm(PreservationGenerateBinaryHash.digestPreservationGeneration.getName());
        versionModel.setUri("Content" + File.separator + outputExtra.getOutput().getOutputName());
        DbFileInfoModel fileInfoModel = new DbFileInfoModel();
        fileInfoModel.setFilename(outputExtra.getOutput().getOutputName());
        fileInfoModel.setLastModified(LocalDateUtil.nowFormatted());
        versionModel.setFileInfoModel(fileInfoModel);
        StoredInfoResult storedInfoResult = outputExtra.getStoredInfo().get();
        DbStorageModel dbStorageModel = new DbStorageModel();
        dbStorageModel.setStrategyId(storedInfoResult.getStrategy());
        DbFormatIdentificationModel formatIdentificationModel = new DbFormatIdentificationModel();
        formatIdentificationModel.setFormatId(formatIdentifierResponse.get().getPuid());
        formatIdentificationModel.setFormatLitteral(formatIdentifierResponse.get().getFormatLiteral());
        formatIdentificationModel.setMimeType(formatIdentifierResponse.get().getMimetype());
        versionModel.setStorage(dbStorageModel);
        versionModel.setFormatIdentificationModel(formatIdentificationModel);
        versionModel.setMessageDigest(outputExtra.getBinaryHash().get());
        versionModel.setSize(outputExtra.getSize().get().longValue());
        return versionModel;
    }
}

