/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.core.validation.OntologyValidator;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ExtractedMetadataForAu;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;

public class PreservationTesseractPlugin
extends ActionHandler {
    public static final String TEXT_CONTENT = "TextContent";
    private static final int WORKFLOWBATCHRESULTS_IN_MEMORY = 0;
    private static final String ITEM_ID = "TESSERACT_SPLIT_TEXT_CONTENT";

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        WorkflowBatchResults results = (WorkflowBatchResults)handler.getInput(0);
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        ArrayList<WorkflowBatchResult> workflowBatchResults = new ArrayList<WorkflowBatchResult>();
        for (WorkflowBatchResult workflowBatchResult : results.getWorkflowBatchResults()) {
            List<WorkflowBatchResult.OutputExtra> outputExtras = workflowBatchResult.getOutputExtras().stream().filter(WorkflowBatchResult.OutputExtra::isOkAndExtractedAu).collect(Collectors.toList());
            if (outputExtras.isEmpty()) {
                workflowBatchResults.add(workflowBatchResult);
                ItemStatus itemStatus = new ItemStatus(ITEM_ID);
                itemStatuses.add(itemStatus);
                continue;
            }
            outputExtras.forEach(o -> o.getExtractedMetadataAU().ifPresent(metadata -> this.computeTextContent((ExtractedMetadataForAu)metadata, itemStatuses, o.getBinaryGUID())));
            workflowBatchResults.add(WorkflowBatchResult.of(workflowBatchResult, outputExtras));
        }
        handler.addOutputResult(0, (Object)new WorkflowBatchResults(results.getBatchDirectory(), workflowBatchResults));
        return itemStatuses;
    }

    private void computeTextContent(ExtractedMetadataForAu extractedMetadataForAu, List<ItemStatus> itemStatuses, String subBinaryItemIds) {
        extractedMetadataForAu.computeIfPresent(TEXT_CONTENT, (key, value) -> {
            String textValue = String.valueOf(value);
            int maxUtf8TextContentLength = VitamConfiguration.getTextContentMaxLength();
            int maxUtf8Length = VitamConfiguration.getTextMaxLength();
            String encodedString = StringEscapeUtils.escapeJava((String)textValue);
            if (OntologyValidator.stringExceedsMaxLuceneUtf8StorageSize((String)textValue, (int)maxUtf8TextContentLength)) {
                encodedString = encodedString.substring(0, maxUtf8TextContentLength);
                itemStatuses.add(PluginHelper.buildItemStatusSubItems(ITEM_ID, Stream.of(subBinaryItemIds), StatusCode.WARNING, PluginHelper.EventDetails.of("TextContent metadata exceeds the limit")));
            } else {
                itemStatuses.add(PluginHelper.buildItemStatusSubItems(ITEM_ID, Stream.of(subBinaryItemIds), StatusCode.OK, PluginHelper.EventDetails.of("All metadata are OK.")));
            }
            return this.splitText(encodedString, maxUtf8Length - 1);
        });
    }

    private List<String> splitText(String text, int textLength) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\b.{1," + (textLength - 1) + "}\\b\\W?");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            result.add(StringEscapeUtils.unescapeJava((String)matcher.group()));
        }
        return result;
    }
}

