/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.StoreMetaDataObjectGroupActionPlugin;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PreservationStorageMetadataAndLfc
extends StoreMetaDataObjectGroupActionPlugin {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationStorageMetadataAndLfc.class);
    private static final String PRESERVATION_STORAGE_METADATA_LFC = "PRESERVATION_STORAGE_METADATA_LFC";
    private static final int WORKFLOWBATCHRESULTS_IN_MEMORY = 0;

    public PreservationStorageMetadataAndLfc() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    PreservationStorageMetadataAndLfc(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, StorageClientFactory storageClientFactory) {
        super(metaDataClientFactory, logbookLifeCyclesClientFactory, storageClientFactory);
    }

    @Override
    public List<ItemStatus> executeList(WorkerParameters params, HandlerIO handlerIO) {
        WorkflowBatchResults results = (WorkflowBatchResults)handlerIO.getInput(0);
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        List<WorkflowBatchResult> workflowBatchResults = results.getWorkflowBatchResults();
        for (WorkflowBatchResult result : workflowBatchResults) {
            List<String> objectGroupIdList = Collections.singletonList(result.getGotId());
            try {
                List outputExtras = result.getOutputExtras().stream().filter(o -> o.isOkAndGenerated() || o.isOkAndExtractedGot() || o.isOkAndIdentify() || o.isOkAndExtractedAu()).collect(Collectors.toList());
                if (outputExtras.isEmpty()) {
                    itemStatuses.add(new ItemStatus(PRESERVATION_STORAGE_METADATA_LFC));
                    continue;
                }
                this.storeDocumentsWithLfc(params, handlerIO, objectGroupIdList);
                itemStatuses.addAll(this.getItemStatuses(objectGroupIdList, StatusCode.OK));
            }
            catch (VitamException e) {
                LOGGER.error("An error occurred during object group storage", (Throwable)e);
                itemStatuses.addAll(this.getItemStatuses(objectGroupIdList, StatusCode.FATAL));
            }
        }
        return itemStatuses;
    }

    private List<ItemStatus> getItemStatuses(List<String> objectGroupIds, StatusCode statusCode) {
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        for (int i = 0; i < objectGroupIds.size(); ++i) {
            itemStatuses.add(PluginHelper.buildItemStatus(PRESERVATION_STORAGE_METADATA_LFC, statusCode, null));
        }
        return itemStatuses;
    }
}

