/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.functional.administration.core.backup.BackupService;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.BinaryEventData;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PreservationStorageBinaryPlugin
extends ActionHandler {
    private final VitamLogger logger = VitamLoggerFactory.getInstance(PreservationStorageBinaryPlugin.class);
    public static final String ITEM_ID = "OBJECT_STORAGE_TASK";
    private final BackupService backupService;

    public PreservationStorageBinaryPlugin() {
        this(new BackupService());
    }

    @VisibleForTesting
    private PreservationStorageBinaryPlugin(BackupService backupService) {
        this.backupService = backupService;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        this.logger.info("Starting PRESERVATION_STORAGE_BINARY.");
        handler.setCurrentObjectId("workflowBatchResults");
        WorkflowBatchResults results = (WorkflowBatchResults)handler.getInput(0);
        Path outputFiles = results.getBatchDirectory().resolve("output-files");
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        ArrayList<WorkflowBatchResult> workflowBatchResults = new ArrayList<WorkflowBatchResult>();
        for (WorkflowBatchResult workflowBatchResult : results.getWorkflowBatchResults()) {
            List<WorkflowBatchResult.OutputExtra> outputExtras = workflowBatchResult.getOutputExtras().stream().filter(WorkflowBatchResult.OutputExtra::isOkAndGenerated).map(a -> this.getOutputExtra(outputFiles, (WorkflowBatchResult.OutputExtra)a, workflowBatchResult.getSourceStrategy())).collect(Collectors.toList());
            if (outputExtras.isEmpty()) {
                workflowBatchResults.add(workflowBatchResult);
                ItemStatus itemStatus = new ItemStatus(ITEM_ID);
                itemStatus.disableLfc();
                itemStatuses.add(itemStatus);
                continue;
            }
            itemStatuses.add(this.getItemStatus(outputExtras));
            Stream<WorkflowBatchResult.OutputExtra> otherActions = workflowBatchResult.getOutputExtras().stream().filter(o -> !o.isOkAndGenerated());
            List<WorkflowBatchResult.OutputExtra> previousAndNewExtras = Stream.concat(otherActions, outputExtras.stream().filter(outputExtra -> !outputExtra.isInError())).collect(Collectors.toList());
            workflowBatchResults.add(WorkflowBatchResult.of(workflowBatchResult, previousAndNewExtras));
        }
        handler.addOutputResult(0, (Object)new WorkflowBatchResults(results.getBatchDirectory(), workflowBatchResults));
        return itemStatuses;
    }

    private ItemStatus getItemStatus(List<WorkflowBatchResult.OutputExtra> outputExtras) {
        Stream<String> subItemIds = outputExtras.stream().map(WorkflowBatchResult.OutputExtra::getBinaryGUID);
        String error = outputExtras.stream().filter(o -> o.getError().isPresent()).map(o -> o.getError().get()).collect(Collectors.joining(","));
        if (outputExtras.stream().allMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return PluginHelper.buildItemStatusSubItems(ITEM_ID, subItemIds, StatusCode.KO, PluginHelper.EventDetails.of(error)).disableLfc().setGlobalOutcomeDetailSubcode("SUBSTATUS_UNKNOWN");
        }
        Map<String, BinaryEventData> digests = outputExtras.stream().filter(o -> o.getStoredInfo().isPresent()).collect(Collectors.toMap(WorkflowBatchResult.OutputExtra::getBinaryGUID, o -> BinaryEventData.from(o.getStoredInfo().get())));
        if (outputExtras.stream().noneMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return PluginHelper.buildItemStatusSubItems(ITEM_ID, subItemIds, StatusCode.OK, digests);
        }
        return PluginHelper.buildItemStatusSubItems(ITEM_ID, subItemIds, StatusCode.WARNING, PluginHelper.EventDetails.of(error, String.join((CharSequence)", ", digests.keySet())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WorkflowBatchResult.OutputExtra getOutputExtra(Path outputFiles, WorkflowBatchResult.OutputExtra extra, String strategyId) {
        Path outputPath = outputFiles.resolve(extra.getOutput().getOutputName());
        try (InputStream stream = Files.newInputStream(outputPath, new OpenOption[0]);){
            StoredInfoResult storedInfo = this.backupService.backup(stream, DataCategory.OBJECT, extra.getBinaryGUID(), strategyId);
            if (!extra.getBinaryHash().isPresent() || !storedInfo.getDigest().equalsIgnoreCase(extra.getBinaryHash().get())) {
                this.logger.error("Error with stored digest {} and computed binary digest {}", (Object)storedInfo.getDigest(), extra.getBinaryHash());
                WorkflowBatchResult.OutputExtra outputExtra2 = WorkflowBatchResult.OutputExtra.inError(String.format("Error with stored digest %s and computed binary digest %s", storedInfo.getDigest(), extra.getBinaryHash()));
                return outputExtra2;
            }
            WorkflowBatchResult.OutputExtra outputExtra = WorkflowBatchResult.OutputExtra.withStoredInfo(extra, storedInfo);
            return outputExtra;
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return WorkflowBatchResult.OutputExtra.inError(e.getMessage());
        }
    }
}

