/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.format.identification.FormatIdentifier;
import fr.gouv.vitam.common.format.identification.FormatIdentifierFactory;
import fr.gouv.vitam.common.format.identification.exception.FileFormatNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierBadRequestException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierTechnicalException;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.PluginHelper;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PreservationSiegfriedPlugin
extends ActionHandler {
    private static final String SUBSTATUS_UNKNOWN = "SUBSTATUS_UNKNOWN";
    private static final String KO_FILE_FORMAT_NOT_FOUND = "KO - FILE_FORMAT_NOT_FOUND ";
    private final VitamLogger logger = VitamLoggerFactory.getInstance(PreservationSiegfriedPlugin.class);
    static final String ITEM_ID = "FILE_FORMAT";
    private final FormatIdentifierFactory siegfriedFactory;
    private static final int WORKFLOWBATCHRESULTS_IN_MEMORY = 0;

    public PreservationSiegfriedPlugin() {
        this(FormatIdentifierFactory.getInstance());
    }

    @VisibleForTesting
    private PreservationSiegfriedPlugin(FormatIdentifierFactory siegfriedFactory) {
        this.siegfriedFactory = siegfriedFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        FormatIdentifier siegfried = this.getFormatIdentifier();
        this.logger.info("Starting PRESERVATION_SIEGFRIED_IDENTIFICATION.");
        handler.setCurrentObjectId("workflowBatchResults");
        WorkflowBatchResults results = (WorkflowBatchResults)handler.getInput(0);
        Path outputFiles = results.getBatchDirectory().resolve("output-files");
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        ArrayList<WorkflowBatchResult> workflowBatchResults = new ArrayList<WorkflowBatchResult>();
        for (WorkflowBatchResult workflowBatchResult : results.getWorkflowBatchResults()) {
            List<WorkflowBatchResult.OutputExtra> outputExtras = workflowBatchResult.getOutputExtras().stream().filter(WorkflowBatchResult.OutputExtra::isOkAndGenerated).map(a -> this.getOutputExtra(outputFiles, (WorkflowBatchResult.OutputExtra)a, results.getBatchDirectory(), siegfried)).collect(Collectors.toList());
            if (outputExtras.isEmpty()) {
                workflowBatchResults.add(workflowBatchResult);
                ItemStatus itemStatus = new ItemStatus(ITEM_ID);
                itemStatus.disableLfc();
                itemStatuses.add(itemStatus);
                continue;
            }
            itemStatuses.add(this.getItemStatus(outputExtras));
            Stream<WorkflowBatchResult.OutputExtra> otherActions = workflowBatchResult.getOutputExtras().stream().filter(o -> !o.isOkAndGenerated());
            List<WorkflowBatchResult.OutputExtra> previousAndNewExtras = Stream.concat(otherActions, outputExtras.stream().filter(outputExtra -> !outputExtra.isInError())).collect(Collectors.toList());
            workflowBatchResults.add(WorkflowBatchResult.of(workflowBatchResult, previousAndNewExtras));
        }
        handler.addOutputResult(0, (Object)new WorkflowBatchResults(results.getBatchDirectory(), workflowBatchResults));
        return itemStatuses;
    }

    private FormatIdentifier getFormatIdentifier() throws ProcessingException {
        FormatIdentifier siegfried;
        try {
            siegfried = this.siegfriedFactory.getFormatIdentifierFor("siegfried-local");
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
        return siegfried;
    }

    private ItemStatus getItemStatus(List<WorkflowBatchResult.OutputExtra> outputExtras) {
        Stream<String> subItemIds = outputExtras.stream().map(WorkflowBatchResult.OutputExtra::getBinaryGUID);
        String error = outputExtras.stream().filter(o -> o.getError().isPresent()).map(o -> o.getError().get()).collect(Collectors.joining(","));
        if (outputExtras.stream().allMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return fr.gouv.vitam.worker.core.utils.PluginHelper.buildItemStatusSubItems(ITEM_ID, subItemIds, StatusCode.KO, PluginHelper.EventDetails.of(error)).disableLfc().setGlobalOutcomeDetailSubcode(SUBSTATUS_UNKNOWN);
        }
        String binaryFormats = outputExtras.stream().filter(o -> o.getBinaryFormat().isPresent()).map(WorkflowBatchResult.OutputExtra::getBinaryFormat).map(Optional::get).map(JsonHandler::unprettyPrint).collect(Collectors.joining(", "));
        if (outputExtras.stream().noneMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return fr.gouv.vitam.worker.core.utils.PluginHelper.buildItemStatusSubItems(ITEM_ID, subItemIds, StatusCode.OK, PluginHelper.EventDetails.of(binaryFormats));
        }
        return fr.gouv.vitam.worker.core.utils.PluginHelper.buildItemStatusSubItems(ITEM_ID, subItemIds, StatusCode.WARNING, PluginHelper.EventDetails.of(error, binaryFormats));
    }

    private WorkflowBatchResult.OutputExtra getOutputExtra(Path inputFiles, WorkflowBatchResult.OutputExtra a, Path batchDirectory, FormatIdentifier siegfried) {
        try {
            Optional<FormatIdentifierResponse> format = siegfried.analysePath(inputFiles.resolve(a.getOutput().getOutputName())).stream().filter(f -> "pronom".equals(f.getMatchedNamespace())).findFirst();
            if (format.isPresent()) {
                return WorkflowBatchResult.OutputExtra.withBinaryFormat(a, format.get());
            }
            this.logger.warn("KO - FILE_FORMAT_NOT_FOUND SUBSTATUS_UNKNOWN");
            return WorkflowBatchResult.OutputExtra.inError("KO - FILE_FORMAT_NOT_FOUND SUBSTATUS_UNKNOWN");
        }
        catch (FileFormatNotFoundException e) {
            this.logger.warn("KO - FILE_FORMAT_NOT_FOUND SUBSTATUS_UNKNOWN, {}", (Throwable)e);
            return WorkflowBatchResult.OutputExtra.inError(e.getMessage());
        }
        catch (FormatIdentifierNotFoundException e) {
            PluginHelper.tryDeleteLocalPreservationFiles(batchDirectory);
            throw new VitamRuntimeException("FATAL - FILE_FORMAT_TOOL_DOES_NOT_ANSWER", (Throwable)e);
        }
        catch (FormatIdentifierBadRequestException | FormatIdentifierTechnicalException e) {
            PluginHelper.tryDeleteLocalPreservationFiles(batchDirectory);
            throw new VitamRuntimeException("FATAL - FILE_FORMAT_REFERENTIAL_TECHNICAL_ERROR", e);
        }
        catch (Exception e) {
            PluginHelper.tryDeleteLocalPreservationFiles(batchDirectory);
            throw new VitamRuntimeException((Throwable)e);
        }
    }
}

