/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.PreservationVersion;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.preservation.GriffinByFormat;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.model.objectgroup.FormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.preservation.model.PreservationDistributionLine;
import fr.gouv.vitam.worker.core.utils.GroupByObjectIterator;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PreservationPreparationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationPreparationPlugin.class);
    private static final String PRESERVATION_PREPARATION = "PRESERVATION_PREPARATION";
    private static final TypeReference<JsonLineModel> JSON_LINE_MODEL_TYPE_REFERENCE = new TypeReference<JsonLineModel>(){};
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;

    public PreservationPreparationPlugin() {
        this(AdminManagementClientFactory.getInstance(), MetaDataClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM));
    }

    @VisibleForTesting
    PreservationPreparationPlugin(AdminManagementClientFactory adminManagementClientFactory, MetaDataClientFactory metaDataClientFactory, WorkspaceClientFactory workspaceClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        ItemStatus itemStatus;
        block8: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                PreservationRequest preservationRequest = this.loadPreservationRequest(handler);
                this.computePreparation(handler, metaDataClient, preservationRequest, param.getRequestId());
                itemStatus = PluginHelper.buildItemStatus(PRESERVATION_PREPARATION, StatusCode.OK, JsonHandler.createObjectNode().put("query", preservationRequest.getDslQuery().toString()));
                if (metaDataClient == null) break block8;
            }
            catch (Throwable preservationRequest) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable) {
                            preservationRequest.addSuppressed(throwable);
                        }
                    }
                    throw preservationRequest;
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Preservation action failed with status [%s]", StatusCode.KO), (Throwable)e);
                    ObjectNode error = JsonHandler.createObjectNode().put("error", e.getMessage());
                    return PluginHelper.buildItemStatus(PRESERVATION_PREPARATION, StatusCode.KO, error);
                }
            }
            metaDataClient.close();
        }
        return itemStatus;
    }

    private Iterator<Pair<String, String>> getGotIdUnitIdIterator(Iterator<JsonNode> iterator) {
        return IteratorUtils.transformedIterator(iterator, item -> new ImmutablePair((Object)item.get(ParserTokens.PROJECTIONARGS.OBJECT.exactToken()).asText(), (Object)item.get(ParserTokens.PROJECTIONARGS.ID.exactToken()).asText()));
    }

    private void computePreparation(HandlerIO handler, MetaDataClient metaDataClient, PreservationRequest preservationRequest, String requestId) throws VitamException {
        Map<String, GriffinModel> griffinModelListForScenario;
        PreservationScenarioModel scenarioModel;
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();
             WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            scenarioModel = this.getScenarioModel(adminManagementClient, preservationRequest.getScenarioIdentifier());
            griffinModelListForScenario = this.getListOfGriffinGivenScenario(adminManagementClient, scenarioModel);
            HashSet<GriffinModel> griffins = new HashSet<GriffinModel>(griffinModelListForScenario.values());
            workspaceClient.putObject(requestId, "preservationScenarioModel", JsonHandler.writeToInpustream((Object)scenarioModel));
            workspaceClient.putObject(requestId, "griffinModel", JsonHandler.writeToInpustream(griffins));
        }
        catch (Exception e) {
            throw new ProcessingException(String.format("Preconditions Failed :  %s", e.getMessage()), (Throwable)e);
        }
        SelectMultiQuery selectMultiQuery = this.prepareUnitsWithObjectGroupsQuery(preservationRequest.getDslQuery());
        ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(metaDataClient, selectMultiQuery);
        SpliteratorIterator iterator = new SpliteratorIterator(scrollRequest);
        Iterator<Pair<String, String>> gotIdUnitIdIterator = this.getGotIdUnitIdIterator((Iterator<JsonNode>)iterator);
        UnmodifiableIterator bulksUnitsByObjectGroup = Iterators.partition((Iterator)new GroupByObjectIterator(gotIdUnitIdIterator), (int)VitamConfiguration.getBatchSize());
        HashMap<String, File> distributionFileByFormat = new HashMap<String, File>();
        while (bulksUnitsByObjectGroup.hasNext()) {
            List bulkUnitsByObjectGroup = (List)bulksUnitsByObjectGroup.next();
            this.processBulk(bulkUnitsByObjectGroup, preservationRequest, handler, distributionFileByFormat, scenarioModel, griffinModelListForScenario);
        }
        this.mergeDistributionFiles(handler, distributionFileByFormat);
    }

    private PreservationRequest loadPreservationRequest(HandlerIO handler) throws ProcessingException, InvalidParseOperationException {
        JsonNode inputRequest = handler.getJsonFromWorkspace("preservationRequest");
        return (PreservationRequest)JsonHandler.getFromJsonNode((JsonNode)inputRequest, PreservationRequest.class);
    }

    private void processBulk(List<Pair<String, List<String>>> bulkUnitsByObjectGroup, PreservationRequest preservationRequest, HandlerIO handler, HashMap<String, File> distributionFileByFormat, PreservationScenarioModel scenarioModel, Map<String, GriffinModel> griffinModelListForScenario) {
        HashMap unitsByObjectGroup = new HashMap();
        for (Pair<String, List<String>> item : bulkUnitsByObjectGroup) {
            unitsByObjectGroup.put((String)item.getKey(), new HashSet((Collection)item.getValue()));
        }
        List<ObjectGroupResponse> objectModelsForUnitResults = this.getObjectModelsForUnitResults(unitsByObjectGroup.keySet());
        ArrayListValuedHashMap preservationDistributionsByFormatId = new ArrayListValuedHashMap();
        for (ObjectGroupResponse objectGroup : objectModelsForUnitResults) {
            Set unitIds = (Set)unitsByObjectGroup.get(objectGroup.getId());
            String unitId = (String)unitIds.iterator().next();
            PreservationDistributionLine preservationDistributionLine = this.createPreservationDistributionLine(preservationRequest, unitId, objectGroup, scenarioModel, griffinModelListForScenario, unitIds);
            if (preservationDistributionLine == null) continue;
            preservationDistributionsByFormatId.put((Object)preservationDistributionLine.getFormatId(), (Object)preservationDistributionLine);
        }
        this.writeDistributionFilesByFormatId(handler, distributionFileByFormat, (MultiValuedMap<String, PreservationDistributionLine>)preservationDistributionsByFormatId);
    }

    private void writeDistributionFilesByFormatId(HandlerIO handler, HashMap<String, File> distributionFileByFormat, MultiValuedMap<String, PreservationDistributionLine> preservationDistributionsByFormatId) {
        for (String formatId : preservationDistributionsByFormatId.keySet()) {
            boolean isEmpty = !distributionFileByFormat.containsKey(formatId);
            File distributionFile = distributionFileByFormat.computeIfAbsent(formatId, unused -> handler.getNewLocalFile(GUIDFactory.newGUID().toString()));
            try (FileOutputStream outputStream = new FileOutputStream(distributionFile, true);
                 JsonLineWriter writer = new JsonLineWriter((OutputStream)outputStream, isEmpty);){
                for (PreservationDistributionLine preservationDistributionLine : preservationDistributionsByFormatId.get((Object)formatId)) {
                    writer.addEntry(new JsonLineModel(preservationDistributionLine.getId(), null, JsonHandler.toJsonNode((Object)preservationDistributionLine)));
                }
            }
            catch (InvalidParseOperationException | IOException e) {
                throw new VitamRuntimeException("Could not persist distribution file", e);
            }
        }
    }

    private void mergeDistributionFiles(HandlerIO handler, HashMap<String, File> distributionFileByFormat) throws VitamException {
        File objectGroupsBigFileToPreserve = handler.getNewLocalFile("object_groups_to_preserve.jsonl");
        try (FileOutputStream outputStream = new FileOutputStream(objectGroupsBigFileToPreserve);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)outputStream);){
            int cpt = 0;
            for (File distributionFileForFormatId : distributionFileByFormat.values()) {
                ++cpt;
                try (FileInputStream inputStream = new FileInputStream(distributionFileForFormatId);
                     JsonLineGenericIterator jsonLineIterator = new JsonLineGenericIterator((InputStream)inputStream, JSON_LINE_MODEL_TYPE_REFERENCE);){
                    while (jsonLineIterator.hasNext()) {
                        JsonLineModel model = (JsonLineModel)jsonLineIterator.next();
                        model.setDistribGroup(Integer.valueOf(cpt));
                        writer.addEntry(model);
                    }
                }
                FileUtils.deleteQuietly((File)distributionFileForFormatId);
            }
        }
        catch (IOException e) {
            throw new VitamException("Could not save distribution file", (Throwable)e);
        }
        handler.transferFileToWorkspace("distributionFileOG.jsonl", objectGroupsBigFileToPreserve, false, false);
    }

    private PreservationDistributionLine createPreservationDistributionLine(PreservationRequest preservationRequest, String unitId, ObjectGroupResponse objectGroup, PreservationScenarioModel scenarioModel, Map<String, GriffinModel> griffinModelListForScenario, Set<String> unitsForThisOG) {
        Optional versionsModelOptional;
        String targetQualifier = preservationRequest.getTargetUsage();
        String sourceQualifier = preservationRequest.getSourceUsage();
        PreservationVersion version = preservationRequest.getVersion();
        Optional optional = versionsModelOptional = version == PreservationVersion.FIRST ? objectGroup.getFirstVersionsModel(sourceQualifier) : objectGroup.getLastVersionsModel(sourceQualifier);
        if (versionsModelOptional.isEmpty()) {
            return null;
        }
        VersionsModel versionsModel = (VersionsModel)versionsModelOptional.get();
        FormatIdentificationModel formatIdentificationModel = versionsModel.getFormatIdentification();
        String formatId = formatIdentificationModel.getFormatId();
        Optional griffinByFormat = scenarioModel.getGriffinByFormat(formatId);
        if (griffinByFormat.isEmpty()) {
            return null;
        }
        GriffinByFormat griffinByFormatModel = (GriffinByFormat)griffinByFormat.get();
        String griffinId = griffinByFormatModel.getGriffinIdentifier();
        GriffinModel griffinModel = griffinModelListForScenario.get(griffinId);
        return this.createLine(objectGroup.getId(), unitId, versionsModel, formatIdentificationModel.getFormatId(), griffinByFormatModel, griffinModel, targetQualifier, sourceQualifier, versionsModel.getStorage().getStrategyId(), scenarioModel.getIdentifier(), unitsForThisOG);
    }

    private PreservationDistributionLine createLine(String objectGroupId, String unitId, VersionsModel version, String format, GriffinByFormat griffinByFormatModel, GriffinModel griffinModel, String targetQualifier, String sourceQualifier, String sourceStrategy, String scenarioId, Set<String> unitsForThisOG) {
        PreservationDistributionLine line = new PreservationDistributionLine();
        line.setId(objectGroupId);
        line.setFormatId(format);
        line.setFilename(version.getFileInfoModel().getFilename());
        line.setActionPreservationList(griffinByFormatModel.getActionDetail());
        line.setUnitId(unitId);
        line.setGriffinId(griffinModel.getExecutableName());
        line.setObjectId(version.getId());
        line.setDebug(griffinByFormatModel.isDebug());
        line.setTimeout(griffinByFormatModel.getTimeOut());
        line.setTargetUse(targetQualifier);
        line.setSourceUse(sourceQualifier);
        line.setSourceStrategy(sourceStrategy);
        line.setScenarioId(scenarioId);
        line.setGriffinIdentifier(griffinModel.getIdentifier());
        line.setUnitsForExtractionAU(unitsForThisOG);
        return line;
    }

    private List<ObjectGroupResponse> getObjectModelsForUnitResults(Collection<String> objectGroupIds) {
        try {
            Select select = new Select();
            String[] ids = objectGroupIds.toArray(new String[0]);
            select.setQuery((Query)QueryHelper.in((String)"#id", (String[])ids));
            ObjectNode finalSelect = select.getFinalSelect();
            JsonNode response = this.metaDataClientFactory.getClient().selectObjectGroups((JsonNode)finalSelect);
            JsonNode results = response.get("$results");
            return (List)JsonHandler.getFromStringAsTypeReference((String)results.toString(), (TypeReference)new TypeReference<List<ObjectGroupResponse>>(){});
        }
        catch (InvalidFormatException | InvalidCreateOperationException | VitamException e) {
            throw new IllegalStateException(e);
        }
    }

    private SelectMultiQuery prepareUnitsWithObjectGroupsQuery(JsonNode initialQuery) {
        try {
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(initialQuery);
            SelectMultiQuery selectMultiQuery = parser.getRequest();
            ObjectNode projectionNode = this.getQueryProjectionToApply();
            selectMultiQuery.setProjection((JsonNode)projectionNode);
            selectMultiQuery.addOrderByAscFilter(new String[]{ParserTokens.PROJECTIONARGS.OBJECT.exactToken()});
            ArrayList queryList = new ArrayList(parser.getRequest().getQueries());
            if (queryList.isEmpty()) {
                selectMultiQuery.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ParserTokens.PROJECTIONARGS.OBJECT.exactToken())}).setDepthLimit(0)});
                return selectMultiQuery;
            }
            for (int i = 0; i < queryList.size(); ++i) {
                Query query = (Query)queryList.get(i);
                BooleanQuery restrictedQuery = QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ParserTokens.PROJECTIONARGS.OBJECT.exactToken()), query});
                parser.getRequest().getQueries().set(i, restrictedQuery);
            }
            return selectMultiQuery;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private ObjectNode getQueryProjectionToApply() {
        ObjectNode projectionNode = JsonHandler.createObjectNode();
        ObjectNode fields = JsonHandler.createObjectNode();
        fields.put(ParserTokens.PROJECTIONARGS.ID.exactToken(), 1);
        fields.put(ParserTokens.PROJECTIONARGS.OBJECT.exactToken(), 1);
        projectionNode.set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)fields);
        return projectionNode;
    }

    private Map<String, GriffinModel> getListOfGriffinGivenScenario(AdminManagementClient adminManagementClient, PreservationScenarioModel scenarioModel) throws InvalidCreateOperationException, AdminManagementClientServerException, InvalidParseOperationException, ReferentialNotFoundException, ProcessingException {
        Set allGriffinIdentifiers = scenarioModel.getAllGriffinIdentifiers();
        Select select = new Select();
        select.setQuery((Query)QueryHelper.in((String)"Identifier", (String[])allGriffinIdentifiers.toArray(new String[0])));
        ObjectNode finalSelect = select.getFinalSelect();
        RequestResponse griffinResponse = adminManagementClient.findGriffin((JsonNode)finalSelect);
        List griffinModels = ((RequestResponseOK)griffinResponse).getResults();
        if (griffinModels == null || griffinModels.isEmpty()) {
            throw new ProcessingException("Griffin not found");
        }
        return griffinModels.stream().collect(Collectors.toMap(GriffinModel::getIdentifier, gr -> gr));
    }

    private PreservationScenarioModel getScenarioModel(AdminManagementClient adminManagementClient, String identifier) throws ProcessingException, AdminManagementClientServerException, ReferentialNotFoundException, InvalidParseOperationException {
        RequestResponse response = adminManagementClient.findPreservationByID(identifier);
        PreservationScenarioModel model = (PreservationScenarioModel)((RequestResponseOK)response).getFirstResult();
        if (model == null) {
            throw new ProcessingException("Griffin " + identifier + " not found");
        }
        return model;
    }
}

