/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;

public class PreservationPreparationInsertionAuMetadata
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationPreparationInsertionAuMetadata.class);
    private static final String ITEM_ID = "PREPARATION_PRESERVATION_INSERTION_AU_METADATA";
    private final BatchReportClientFactory batchReportClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;

    public PreservationPreparationInsertionAuMetadata() {
        this(BatchReportClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM));
    }

    @VisibleForTesting
    public PreservationPreparationInsertionAuMetadata(BatchReportClientFactory batchReportClientFactory, WorkspaceClientFactory workspaceClientFactory) {
        this.batchReportClientFactory = batchReportClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        LOGGER.info("starting {}", (Object)ITEM_ID);
        try (BatchReportClient client = this.batchReportClientFactory.getClient();){
            ItemStatus itemStatus;
            block15: {
                WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
                try {
                    boolean distributionFileAlreadyCreated = workspaceClient.isExistingObject(workerParameters.getContainerName(), "distributionFileAU.jsonl");
                    if (!distributionFileAlreadyCreated) {
                        client.createExtractedMetadataDistributionFileForAu(workerParameters.getContainerName());
                    }
                    itemStatus = PluginHelper.buildItemStatus(ITEM_ID, StatusCode.OK, PluginHelper.EventDetails.of("Preparation insertion AU OK."));
                    if (workspaceClient == null) break block15;
                }
                catch (Throwable throwable) {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workspaceClient.close();
            }
            return itemStatus;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }
}

