/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.InternalActionKeysRetriever;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ExtractedMetadata;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PreservationObjectGroupMetadataSecurityChecks
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationObjectGroupMetadataSecurityChecks.class);
    private static final String ITEM_ID = "PRESERVATION_OBJECTGROUP_METADATA_SECURITY_CHECKS";
    private final InternalActionKeysRetriever internalActionKeysRetriever;

    public PreservationObjectGroupMetadataSecurityChecks() {
        this(new InternalActionKeysRetriever());
    }

    @VisibleForTesting
    public PreservationObjectGroupMetadataSecurityChecks(InternalActionKeysRetriever internalActionKeysRetriever) {
        this.internalActionKeysRetriever = internalActionKeysRetriever;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        LOGGER.debug("Starting {}.", (Object)ITEM_ID);
        handler.setCurrentObjectId("workflowBatchResults");
        WorkflowBatchResults results = (WorkflowBatchResults)handler.getInput(0);
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        ArrayList<WorkflowBatchResult> workflowBatchResults = new ArrayList<WorkflowBatchResult>();
        for (WorkflowBatchResult workflowBatchResult : results.getWorkflowBatchResults()) {
            List<WorkflowBatchResult.OutputExtra> outputExtras = workflowBatchResult.getOutputExtras().stream().filter(WorkflowBatchResult.OutputExtra::isOkAndExtractedGot).map(this::checkMetadataAndAddExtractedMetadata).collect(Collectors.toList());
            if (outputExtras.isEmpty()) {
                workflowBatchResults.add(workflowBatchResult);
                ItemStatus itemStatus = new ItemStatus(ITEM_ID);
                itemStatuses.add(itemStatus);
                continue;
            }
            itemStatuses.add(this.getItemStatus(outputExtras));
            workflowBatchResults.add(WorkflowBatchResult.of(workflowBatchResult, this.getOutputExtrasWithoutErrors(workflowBatchResult, outputExtras)));
        }
        handler.addOutputResult(0, (Object)new WorkflowBatchResults(results.getBatchDirectory(), workflowBatchResults));
        return itemStatuses;
    }

    private List<WorkflowBatchResult.OutputExtra> getOutputExtrasWithoutErrors(WorkflowBatchResult workflowBatchResult, List<WorkflowBatchResult.OutputExtra> outputExtras) {
        Stream<WorkflowBatchResult.OutputExtra> nonExtractedOrOkOutputExtra = workflowBatchResult.getOutputExtras().stream().filter(Predicate.not(WorkflowBatchResult.OutputExtra::isOkAndExtractedGot));
        Stream<WorkflowBatchResult.OutputExtra> extractedOutputExtraSanitize = outputExtras.stream().filter(Predicate.not(WorkflowBatchResult.OutputExtra::isInError));
        return Stream.concat(nonExtractedOrOkOutputExtra, extractedOutputExtraSanitize).collect(Collectors.toList());
    }

    private ItemStatus getItemStatus(List<WorkflowBatchResult.OutputExtra> outputExtras) {
        Stream<String> subBinaryItemIds = outputExtras.stream().map(WorkflowBatchResult.OutputExtra::getBinaryGUID);
        String error = outputExtras.stream().filter(o -> o.getError().isPresent()).map(o -> o.getError().get()).collect(Collectors.joining(","));
        if (outputExtras.stream().allMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return PluginHelper.buildItemStatusSubItems(ITEM_ID, subBinaryItemIds, StatusCode.KO, PluginHelper.EventDetails.of(error));
        }
        if (outputExtras.stream().noneMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return PluginHelper.buildItemStatusSubItems(ITEM_ID, subBinaryItemIds, StatusCode.OK, PluginHelper.EventDetails.of("All metadata are OK."));
        }
        return PluginHelper.buildItemStatusSubItems(ITEM_ID, subBinaryItemIds, StatusCode.WARNING, PluginHelper.EventDetails.of(error));
    }

    private WorkflowBatchResult.OutputExtra checkMetadataAndAddExtractedMetadata(WorkflowBatchResult.OutputExtra output) {
        try {
            ExtractedMetadata extractedMetadata = output.getOutput().getExtractedMetadata();
            SanityChecker.checkJsonAll((String)JsonHandler.unprettyPrint((Object)extractedMetadata));
            List internalKeyFields = this.internalActionKeysRetriever.getInternalKeyFields(JsonHandler.toJsonNode((Object)extractedMetadata));
            if (!internalKeyFields.isEmpty()) {
                String message = String.format("Extracted metadata contains these forbidden internal keys: '%s'.", internalKeyFields);
                LOGGER.warn(message);
                return WorkflowBatchResult.OutputExtra.inError(message);
            }
            return WorkflowBatchResult.OutputExtra.withExtractedMetadataForGot(output, output.getOutput().getExtractedMetadata());
        }
        catch (InvalidParseOperationException e) {
            LOGGER.warn((Throwable)e);
            return WorkflowBatchResult.OutputExtra.inError(e.getMessage());
        }
    }
}

