/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.api.model.UpdateUnitKey;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.List;

public class PreservationInsertionAuMetadata
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationInsertionAuMetadata.class);
    private static final String ITEM_ID = "PRESERVATION_INSERTION_AU_METADATA";
    private static final TypeReference<RequestResponseOK<JsonNode>> REQUEST_RESPONSE_TYPE_REFERENCE = new TypeReference<RequestResponseOK<JsonNode>>(){};
    private final MetaDataClientFactory metaDataClientFactory;

    public PreservationInsertionAuMetadata() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    public PreservationInsertionAuMetadata(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        LOGGER.debug("Starting {}.'", (Object)ITEM_ID);
        List units = workerParameters.getObjectNameList();
        List extractedMetadatasToUpdate = workerParameters.getObjectMetadataList();
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        try {
            ArrayList<ItemStatus> arrayList;
            block14: {
                MetaDataClient mdClient = this.metaDataClientFactory.getClient();
                try {
                    for (int i = 0; i < units.size(); ++i) {
                        UpdateMultiQuery update = new UpdateMultiQuery();
                        update.addActions(new Action[]{UpdateActionHelper.set((ObjectNode)((ObjectNode)extractedMetadatasToUpdate.get(i))), UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{workerParameters.getRequestId()})});
                        String unitId = (String)units.get(i);
                        RequestResponseOK requestResponse = (RequestResponseOK)JsonHandler.getFromJsonNode((JsonNode)mdClient.updateUnitById((JsonNode)update.getFinalUpdate(), unitId), REQUEST_RESPONSE_TYPE_REFERENCE);
                        JsonNode unitAsNode = (JsonNode)requestResponse.getFirstResult();
                        UpdateUnitKey key = UpdateUnitKey.valueOf((String)unitAsNode.get("#key").asText());
                        StatusCode status = StatusCode.valueOf((String)unitAsNode.get("#status").asText());
                        String message = unitAsNode.get("#message").asText();
                        String diff = unitAsNode.get("#diff").asText();
                        if (!(StatusCode.KO.equals((Object)status) || StatusCode.FATAL.equals((Object)status) || StatusCode.OK.equals((Object)status))) {
                            throw new VitamRuntimeException(String.format("Status must be of type KO, FATAL or OK here '%s'.", status));
                        }
                        if (StatusCode.KO.equals((Object)status) || StatusCode.FATAL.equals((Object)status)) {
                            itemStatuses.add(PluginHelper.buildItemStatusWithMessage(ITEM_ID, status, String.format("Failed to add extracted metadata for unit: '%s', in database with message '%s' and key '%s'.", unitId, message, key)));
                            continue;
                        }
                        itemStatuses.add(PluginHelper.buildItemStatusWithMessage(ITEM_ID, StatusCode.OK, diff));
                    }
                    arrayList = itemStatuses;
                    if (mdClient == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (mdClient != null) {
                            try {
                                mdClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataException e) {
                        throw new ProcessingException(e);
                    }
                }
                mdClient.close();
            }
            return arrayList;
        }
        finally {
            LOGGER.debug("Ending {}.'", (Object)ITEM_ID);
        }
    }
}

