/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.BinaryEventData;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PreservationGenerateBinaryHash
extends ActionHandler {
    private final VitamLogger logger = VitamLoggerFactory.getInstance(PreservationGenerateBinaryHash.class);
    public static final DigestType digestPreservationGeneration = DigestType.SHA512;
    public static final String ITEM_ID = "PRESERVATION_BINARY_HASH";

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        this.logger.debug("Starting {}.", (Object)ITEM_ID);
        handler.setCurrentObjectId("workflowBatchResults");
        WorkflowBatchResults results = (WorkflowBatchResults)handler.getInput(0);
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        ArrayList<WorkflowBatchResult> workflowBatchResults = new ArrayList<WorkflowBatchResult>();
        for (WorkflowBatchResult workflowBatchResult : results.getWorkflowBatchResults()) {
            List<WorkflowBatchResult.OutputExtra> outputExtras = workflowBatchResult.getOutputExtras().stream().filter(WorkflowBatchResult.OutputExtra::isOkAndGenerated).map(a -> this.getOutputExtra(results, (WorkflowBatchResult.OutputExtra)a)).collect(Collectors.toList());
            if (outputExtras.isEmpty()) {
                workflowBatchResults.add(workflowBatchResult);
                ItemStatus itemStatus = new ItemStatus(ITEM_ID);
                itemStatus.disableLfc();
                itemStatuses.add(itemStatus);
                continue;
            }
            itemStatuses.add(this.getItemStatus(outputExtras));
            Stream<WorkflowBatchResult.OutputExtra> otherActions = workflowBatchResult.getOutputExtras().stream().filter(o -> !o.isOkAndGenerated());
            List<WorkflowBatchResult.OutputExtra> previousAndNewExtras = Stream.concat(otherActions, outputExtras.stream().filter(outputExtra -> !outputExtra.isInError())).collect(Collectors.toList());
            workflowBatchResults.add(WorkflowBatchResult.of(workflowBatchResult, previousAndNewExtras));
        }
        handler.addOutputResult(0, (Object)new WorkflowBatchResults(results.getBatchDirectory(), workflowBatchResults));
        return itemStatuses;
    }

    private ItemStatus getItemStatus(List<WorkflowBatchResult.OutputExtra> outputExtras) {
        Stream<String> subBinaryItemIds = outputExtras.stream().map(WorkflowBatchResult.OutputExtra::getBinaryGUID);
        String error = outputExtras.stream().filter(o -> o.getError().isPresent()).map(o -> o.getError().get()).collect(Collectors.joining(","));
        if (outputExtras.stream().allMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return PluginHelper.buildItemStatusSubItems(ITEM_ID, subBinaryItemIds, StatusCode.KO, PluginHelper.EventDetails.of(error)).disableLfc();
        }
        Map<String, BinaryEventData> digests = outputExtras.stream().filter(o -> o.getBinaryHash().isPresent()).collect(Collectors.toMap(WorkflowBatchResult.OutputExtra::getBinaryGUID, o -> BinaryEventData.from(o.getBinaryHash().get())));
        if (outputExtras.stream().noneMatch(WorkflowBatchResult.OutputExtra::isInError)) {
            return PluginHelper.buildItemStatusSubItems(ITEM_ID, subBinaryItemIds, StatusCode.OK, digests);
        }
        return PluginHelper.buildItemStatusSubItems(ITEM_ID, subBinaryItemIds, StatusCode.WARNING, PluginHelper.EventDetails.of(error, String.join((CharSequence)", ", digests.keySet())));
    }

    private WorkflowBatchResult.OutputExtra getOutputExtra(WorkflowBatchResults results, WorkflowBatchResult.OutputExtra extra) {
        Digest digest = new Digest(digestPreservationGeneration);
        try {
            Path outputPath = results.getBatchDirectory().resolve("output-files").resolve(extra.getOutput().getOutputName());
            InputStream binaryFile = Files.newInputStream(outputPath, new OpenOption[0]);
            digest.update(binaryFile);
            String binaryHash = digest.digestHex();
            return WorkflowBatchResult.OutputExtra.withBinaryHashAndSize(extra, binaryHash, Files.size(outputPath));
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            return WorkflowBatchResult.OutputExtra.inError(e.getMessage());
        }
    }
}

