/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ContextPreservationReport;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ReportOutput;
import fr.gouv.vitam.worker.core.plugin.preservation.model.StatusOutcome;
import fr.gouv.vitam.worker.core.plugin.preservation.service.PreservationReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

public class PreservationFinalizationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationFinalizationPlugin.class);
    private static final String PLUGIN_NAME = "PRESERVATION_FINALIZATION";
    protected static final String PRESERVATION = "PRESERVATION";
    private static final String PRESERVATION_OK = "PRESERVATION.OK";
    private final PreservationReportService preservationReportService;
    private final LogbookOperationsClient logbookOperationsClient;

    public PreservationFinalizationPlugin() {
        this(new PreservationReportService(), LogbookOperationsClientFactory.getInstance().getClient());
    }

    @VisibleForTesting
    PreservationFinalizationPlugin(PreservationReportService preservationReportService, LogbookOperationsClient logbookOperationsClient) {
        this.preservationReportService = preservationReportService;
        this.logbookOperationsClient = logbookOperationsClient;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.storeReportToWorkspace(param, handler);
            this.storeReportToOffers(param.getContainerName());
            this.cleanupReport(param.getRequestId());
        }
        catch (Exception e) {
            LOGGER.error("Error on finalization", (Throwable)e);
            ObjectNode eventDetails = JsonHandler.createObjectNode();
            eventDetails.put("error", e.getMessage());
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, eventDetails);
        }
        return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of("Finalization ok."));
    }

    private void storeReportToWorkspace(WorkerParameters param, HandlerIO handler) throws IOException, InvalidParseOperationException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException, LogbookClientException, ProcessingStatusException {
        if (this.preservationReportService.isReportWrittenInWorkspace(param.getContainerName())) {
            return;
        }
        Integer tenant = VitamThreadUtils.getVitamSession().getTenantId();
        String evId = param.getRequestId();
        try (InputStream inputRequest = handler.getInputStreamFromWorkspace("preservationRequest");
             InputStream scenarioModelInputStream = handler.getInputStreamFromWorkspace("preservationScenarioModel");){
            PreservationRequest preservationRequest = (PreservationRequest)JsonHandler.getFromInputStream((InputStream)inputRequest, PreservationRequest.class);
            File griffinModelFile = handler.getFileFromWorkspace("griffinModel");
            List griffinModel = (List)JsonHandler.getFromFileAsTypeReference((File)griffinModelFile, (TypeReference)new TypeReference<List<GriffinModel>>(){});
            PreservationScenarioModel scenarioModel = (PreservationScenarioModel)JsonHandler.getFromInputStream((InputStream)scenarioModelInputStream, PreservationScenarioModel.class);
            JsonNode result = this.logbookOperationsClient.selectOperationById(param.getContainerName());
            RequestResponseOK logbookOperationVersionModelResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)result);
            LogbookOperation logbookOperationVersionModel = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)logbookOperationVersionModelResponseOK.getFirstResult()), LogbookOperation.class);
            List events = logbookOperationVersionModel.getEvents();
            List<StatusOutcome> statusOutcomes = events.stream().map(e -> this.createLogbookReport(e.getOutcome(), e.getOutDetail(), e.getOutMessg(), e.getEvDetData())).collect(Collectors.toList());
            ReportOutput reportOutput = this.createLogbookReport(statusOutcomes);
            JsonNode rSI = JsonHandler.toJsonNode((Object)logbookOperationVersionModel.getRightsStatementIdentifier());
            JsonNode evDetData = null;
            if (reportOutput.getEvDetData() != null) {
                evDetData = JsonHandler.toJsonNode((Object)reportOutput.getEvDetData());
            }
            OperationSummary operationSummary = new OperationSummary(tenant, evId, reportOutput.getEvType(), reportOutput.getOutcome(), reportOutput.getOutDetail(), reportOutput.getOutMsg(), rSI, evDetData);
            String startDate = logbookOperationVersionModel.getEvDateTime();
            String endDate = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.now());
            ReportType reportType = ReportType.PRESERVATION;
            ReportResults vitamResults = new ReportResults();
            ObjectNode extendedInfo = JsonHandler.createObjectNode();
            ReportSummary reportSummary = new ReportSummary(startDate, endDate, reportType, vitamResults, (JsonNode)extendedInfo);
            ContextPreservationReport contextPreservationReport = new ContextPreservationReport(preservationRequest.getDslQuery(), scenarioModel, griffinModel);
            JsonNode context = JsonHandler.toJsonNode((Object)contextPreservationReport);
            Report reportInfo = new Report(operationSummary, reportSummary, context);
            this.preservationReportService.storeReportToWorkspace(reportInfo);
        }
    }

    private void storeReportToOffers(String processId) throws ProcessingStatusException {
        this.preservationReportService.storeReportToOffers(processId);
    }

    private void cleanupReport(String processId) throws ProcessingStatusException {
        this.preservationReportService.cleanupReport(processId);
    }

    private ReportOutput createLogbookReport(List<StatusOutcome> statusOutcomes) {
        List statusOutcomeNotOk = statusOutcomes.stream().filter(s -> !StatusCode.OK.equals((Object)s.getStatusCode())).collect(Collectors.toList());
        if (statusOutcomeNotOk.isEmpty()) {
            return this.createReportOutput(new StatusOutcome(StatusCode.OK, PRESERVATION_OK, VitamLogbookMessages.getCodeOp((String)PRESERVATION, (StatusCode)StatusCode.OK), null), StatusCode.OK);
        }
        List statusKo = statusOutcomeNotOk.stream().filter(statusOutcome -> StatusCode.KO.equals((Object)statusOutcome.getStatusCode())).collect(Collectors.toList());
        if (statusOutcomeNotOk.size() == statusOutcomes.size() && statusKo.size() == statusOutcomeNotOk.size()) {
            return statusOutcomeNotOk.stream().map(statusOutcome -> this.createReportOutput((StatusOutcome)statusOutcome, StatusCode.KO)).reduce(this::reportCombine).orElseGet(() -> new ReportOutput("", "", "", "", ""));
        }
        return statusOutcomeNotOk.stream().map(statusOutcome -> this.createReportOutput((StatusOutcome)statusOutcome, StatusCode.WARNING)).reduce(this::reportCombine).orElseGet(() -> new ReportOutput("", "", "", "", ""));
    }

    ReportOutput reportCombine(ReportOutput reportOutput1, ReportOutput reportOutput2) {
        return new ReportOutput(PRESERVATION, reportOutput1.getOutcome(), String.join((CharSequence)", ", reportOutput1.getOutDetail(), reportOutput2.getOutDetail()), String.join((CharSequence)", ", reportOutput1.getOutMsg(), reportOutput2.getOutMsg()), String.join((CharSequence)", ", reportOutput1.getEvDetData(), reportOutput2.getEvDetData()));
    }

    private ReportOutput createReportOutput(StatusOutcome statusOutcome, StatusCode statusCode) {
        return new ReportOutput(PRESERVATION, statusCode.name(), statusOutcome.getOutDetail(), statusOutcome.getOutMessg(), statusOutcome.getEvDetData());
    }

    private StatusOutcome createLogbookReport(String outcome, String outDetail, String outMessg, String evDetData) {
        return new StatusOutcome(StatusCode.valueOf((String)outcome), outDetail, outMessg, evDetData);
    }
}

