/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ExtractedMetadata;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PreservationExtractionAUPlugin
extends ActionHandler {
    public static final String ITEM_ID = "PRESERVATION_EXTRACTION_AU";
    private final VitamLogger logger = VitamLoggerFactory.getInstance(PreservationExtractionAUPlugin.class);
    private final BatchReportClientFactory batchReportClientFactory;

    public PreservationExtractionAUPlugin() {
        this(BatchReportClientFactory.getInstance());
    }

    @VisibleForTesting
    public PreservationExtractionAUPlugin(BatchReportClientFactory batchReportClientFactory) {
        this.batchReportClientFactory = batchReportClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            ArrayList<ItemStatus> arrayList;
            block14: {
                BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();
                try {
                    this.logger.debug("Starting {}.", (Object)ITEM_ID);
                    handler.setCurrentObjectId("workflowBatchResults");
                    WorkflowBatchResults results = (WorkflowBatchResults)handler.getInput(0);
                    ArrayList<ExtractedMetadata> extractedMetadataList = new ArrayList<ExtractedMetadata>();
                    ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
                    for (WorkflowBatchResult workflowBatchResult : results.getWorkflowBatchResults()) {
                        List<WorkflowBatchResult.OutputExtra> outputExtras = workflowBatchResult.getOutputExtras().stream().filter(o -> !o.isInError() && o.isOkAndExtractedAu()).collect(Collectors.toList());
                        if (outputExtras.isEmpty()) {
                            ItemStatus itemStatus = new ItemStatus(ITEM_ID);
                            itemStatus.disableLfc();
                            itemStatuses.add(itemStatus);
                            continue;
                        }
                        ExtractedMetadata extractedMetadata = this.mergeExtractedMetadata(workflowBatchResult.getGotId(), handler.getContainerName(), outputExtras, workflowBatchResult.getUnitsForExtractionAU());
                        extractedMetadataList.add(extractedMetadata);
                        itemStatuses.add(PluginHelper.buildItemStatusWithMessage(ITEM_ID, StatusCode.OK, "Insert in batch Report OK."));
                    }
                    if (!extractedMetadataList.isEmpty()) {
                        batchReportClient.storeExtractedMetadataForAu(extractedMetadataList);
                    }
                    handler.addOutputResult(0, (Object)results);
                    arrayList = itemStatuses;
                    if (batchReportClient == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (batchReportClient != null) {
                            try {
                                batchReportClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (VitamClientInternalException e) {
                        throw new ProcessingException((Throwable)e);
                    }
                }
                batchReportClient.close();
            }
            return arrayList;
        }
        finally {
            this.logger.debug("End of {}.", (Object)ITEM_ID);
        }
    }

    private ExtractedMetadata mergeExtractedMetadata(String ogId, String processId, List<WorkflowBatchResult.OutputExtra> outputExtras, List<String> unitsForExtractedAU) {
        Map<String, Object> extractedMetadata = outputExtras.stream().flatMap(output -> output.getOutput().getExtractedMetadataAU().entrySet().stream()).filter(e -> Objects.nonNull(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
        return new ExtractedMetadata(ogId, processId, VitamThreadUtils.getVitamSession().getTenantId().intValue(), unitsForExtractedAU, extractedMetadata);
    }
}

