/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.ProcessingRetryAsyncException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.common.CheckResourceAvailability;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PreservationCheckResourceAvailability
extends CheckResourceAvailability {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationCheckResourceAvailability.class);
    private static final String PLUGIN_NAME = "PRESERVATION_CHECK_RESOURCE_AVAILABILITY";

    public PreservationCheckResourceAvailability() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public PreservationCheckResourceAvailability(StorageClientFactory storage) {
        super(storage);
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            HashMap<AccessRequestContext, List<String>> entries = new HashMap<AccessRequestContext, List<String>>();
            IntStream.range(0, workerParameters.getObjectNameList().size()).mapToObj(index -> this.mapToParamsResourceDistributionLine(workerParameters, index)).collect(Collectors.toList()).forEach(pair -> entries.computeIfAbsent((AccessRequestContext)pair.getLeft(), x -> new ArrayList()).add((String)pair.getRight()));
            this.checkResourcesAvailability(entries, DataCategory.OBJECT);
            return IntStream.range(0, workerParameters.getObjectNameList().size()).mapToObj(index -> PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of(String.format("%s executed", PLUGIN_NAME)))).collect(Collectors.toList());
        }
        catch (ProcessingRetryAsyncException prae) {
            LOGGER.info("Some resources where not available");
            throw prae;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private Pair<AccessRequestContext, String> mapToParamsResourceDistributionLine(WorkerParameters workerParameters, int index) {
        String strategyId = ((JsonNode)workerParameters.getObjectMetadataList().get(index)).get("sourceStrategy").asText();
        String objectId = ((JsonNode)workerParameters.getObjectMetadataList().get(index)).get("objectId").asText();
        return new ImmutablePair((Object)new AccessRequestContext(strategyId, null), (Object)objectId);
    }
}

