/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.preservation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.PreservationReportEntry;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.administration.preservation.ActionPreservation;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.PluginHelper;
import fr.gouv.vitam.worker.core.plugin.preservation.model.InputPreservation;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ParametersPreservation;
import fr.gouv.vitam.worker.core.plugin.preservation.model.PreservationDistributionLine;
import fr.gouv.vitam.worker.core.plugin.preservation.model.ResultPreservation;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResult;
import fr.gouv.vitam.worker.core.plugin.preservation.model.WorkflowBatchResults;
import fr.gouv.vitam.worker.core.plugin.preservation.service.PreservationReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.io.IOUtils;

public class PreservationActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PreservationActionPlugin.class);
    private static final String INPUT_FILES = "input-files";
    static final String OUTPUT_FILES = "output-files";
    private static final String PLUGIN_NAME = "PRESERVATION_ACTION";
    private static final String PARAMETERS_JSON = "parameters.json";
    private static final String RESULT_JSON = "result.json";
    private static final String EXECUTABLE_FILE_NAME = "griffin";
    private final String griffinInputFolder;
    private final String execFolder;
    private final StorageClientFactory storageClientFactory;
    private final PreservationReportService reportService;

    public PreservationActionPlugin() {
        this(StorageClientFactory.getInstance(), new PreservationReportService(), VitamConfiguration.getVitamGriffinInputFilesFolder(), VitamConfiguration.getVitamGriffinExecFolder());
    }

    @VisibleForTesting
    PreservationActionPlugin(StorageClientFactory storage, PreservationReportService report, String inputFolder, String execFolder) {
        this.storageClientFactory = storage;
        this.reportService = report;
        this.griffinInputFolder = inputFolder;
        this.execFolder = execFolder;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        List<PreservationDistributionLine> entries = IntStream.range(0, workerParameters.getObjectNameList().size()).mapToObj(index -> this.mapToParamsPreservationDistributionFile(workerParameters, index)).collect(Collectors.toList());
        String griffinId = ((PreservationDistributionLine)entries.get(0)).getGriffinId();
        String batchId = GUIDFactory.newGUID().getId();
        try {
            Path batchDirectory = this.createBatchDirectory(griffinId, batchId);
            this.copyInputFiles(batchDirectory, entries);
            String requestId = workerParameters.getRequestId();
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            this.createParametersBatchFile(entries, batchDirectory, requestId, batchId);
            int timeout = entries.get(0).getTimeout();
            ResultPreservation result = this.launchGriffin(griffinId, batchDirectory, timeout);
            List<WorkflowBatchResult> workflowResults = this.generateWorkflowBatchResults(result, entries);
            handler.setCurrentObjectId("workflowBatchResults");
            handler.addOutputResult(0, (Object)new WorkflowBatchResults(batchDirectory, workflowResults));
            this.createReport(workflowResults, entries, tenantId, requestId);
            return workflowResults.stream().map(w -> fr.gouv.vitam.worker.core.utils.PluginHelper.buildItemStatus(PLUGIN_NAME, w.getGlobalStatus(), PluginHelper.EventDetails.of(String.format("%s executed", PLUGIN_NAME)))).collect(Collectors.toList());
        }
        catch (Exception e) {
            PluginHelper.tryDeleteLocalPreservationFiles(Paths.get(this.griffinInputFolder, griffinId, batchId));
            throw new ProcessingException((Throwable)e);
        }
    }

    private PreservationDistributionLine mapToParamsPreservationDistributionFile(WorkerParameters workerParameters, int index) {
        try {
            return (PreservationDistributionLine)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)workerParameters.getObjectMetadataList().get(index)), PreservationDistributionLine.class);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private Path createBatchDirectory(String griffinId, String batchId) throws IOException {
        Path griffinDirectory = Paths.get(this.griffinInputFolder, griffinId);
        if (!griffinDirectory.toFile().exists()) {
            Files.createDirectory(griffinDirectory, new FileAttribute[0]);
        }
        return Files.createDirectory(griffinDirectory.resolve(batchId), new FileAttribute[0]);
    }

    private void copyInputFiles(Path batchDirectory, List<PreservationDistributionLine> entries) throws IOException, StorageNotFoundException, StorageServerClientException, StorageUnavailableDataFromAsyncOfferClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            Path inputFilesDirectory = Files.createDirectory(batchDirectory.resolve(INPUT_FILES), new FileAttribute[0]);
            for (PreservationDistributionLine entryParams : entries) {
                this.copyBinaryFile(entryParams, storageClient, inputFilesDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBinaryFile(PreservationDistributionLine entryParams, StorageClient storageClient, Path inputFilesDirectory) throws IOException, StorageNotFoundException, StorageServerClientException, StorageUnavailableDataFromAsyncOfferClientException {
        Response fileResponse = null;
        InputStream src = null;
        try {
            fileResponse = storageClient.getContainerAsync(entryParams.getSourceStrategy(), entryParams.getObjectId(), DataCategory.OBJECT, AccessLogUtils.getNoLogAccessLog());
            src = (InputStream)fileResponse.readEntity(InputStream.class);
            Path target = inputFilesDirectory.resolve(entryParams.getObjectId());
            Files.copy(src, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            StreamUtils.closeSilently(src);
            StreamUtils.consumeAnyEntityAndClose(fileResponse);
            throw throwable;
        }
        StreamUtils.closeSilently((InputStream)src);
        StreamUtils.consumeAnyEntityAndClose((Response)fileResponse);
    }

    private void createParametersBatchFile(List<PreservationDistributionLine> lines, Path batchDirectory, String requestId, String batchId) throws VitamException {
        List<InputPreservation> inputsPreservation = lines.stream().map(this::mapToInput).collect(Collectors.toList());
        List<ActionPreservation> preservationActions = lines.get(0).getActionPreservationList();
        boolean debug = lines.get(0).isDebug();
        ParametersPreservation parametersPreservation = new ParametersPreservation(requestId, batchId, inputsPreservation, preservationActions, debug);
        Path parametersPath = batchDirectory.resolve(PARAMETERS_JSON);
        JsonHandler.writeAsFile((Object)parametersPreservation, (File)parametersPath.toFile());
    }

    private InputPreservation mapToInput(PreservationDistributionLine entryParams) {
        return new InputPreservation(entryParams.getObjectId(), entryParams.getFormatId());
    }

    private ResultPreservation launchGriffin(String griffinId, Path batchDirectory, int timeout) throws IOException, InterruptedException, InvalidParseOperationException {
        Path griffinExecutable = Paths.get(this.execFolder, griffinId, EXECUTABLE_FILE_NAME);
        List<String> command = Arrays.asList(griffinExecutable.toString(), batchDirectory.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process griffin = processBuilder.start();
        if (!griffin.waitFor(timeout, TimeUnit.SECONDS)) {
            LOGGER.error("Griffin {} was not completed before timeout", (Object)griffinId);
            griffin.destroyForcibly();
        }
        if (griffin.exitValue() > 0) {
            LOGGER.error("Griffin {} exited with value {}, stdErr: {}, stdOut: {}.", new Object[]{griffinId, griffin.exitValue(), IOUtils.toString((InputStream)griffin.getErrorStream(), (Charset)Charset.defaultCharset()), IOUtils.toString((InputStream)griffin.getInputStream(), (Charset)Charset.defaultCharset())});
        }
        return (ResultPreservation)JsonHandler.getFromFile((File)batchDirectory.resolve(RESULT_JSON).toFile(), ResultPreservation.class);
    }

    private List<WorkflowBatchResult> generateWorkflowBatchResults(ResultPreservation result, List<PreservationDistributionLine> entries) {
        return entries.stream().map(e -> this.mapToWorkflowBatchResult((PreservationDistributionLine)e, result)).collect(Collectors.toList());
    }

    private WorkflowBatchResult mapToWorkflowBatchResult(PreservationDistributionLine e, ResultPreservation result) {
        List<WorkflowBatchResult.OutputExtra> outputExtras = result.getOutputs().get(e.getObjectId()).stream().map(WorkflowBatchResult.OutputExtra::of).collect(Collectors.toList());
        return WorkflowBatchResult.of(e.getId(), e.getUnitId(), e.getTargetUse(), result.getRequestId(), outputExtras, e.getSourceUse(), e.getSourceStrategy(), new ArrayList<String>(e.getUnitsForExtractionAU()));
    }

    private void createReport(List<WorkflowBatchResult> workflowResults, List<PreservationDistributionLine> entries, Integer tenantId, String requestId) throws ProcessingStatusException {
        List<PreservationReportEntry> reportModels = this.toReportModel(workflowResults, entries, tenantId, LocalDateUtil.now(), requestId);
        this.reportService.appendEntries(requestId, reportModels);
    }

    private List<PreservationReportEntry> toReportModel(List<WorkflowBatchResult> workflowResults, List<PreservationDistributionLine> entries, Integer tenantId, LocalDateTime now, String requestId) {
        return workflowResults.stream().flatMap(w -> w.getOutputExtras().stream().map(output -> this.getPreservationReportModel(requestId, tenantId, now, (WorkflowBatchResult.OutputExtra)output, entries))).collect(Collectors.toList());
    }

    private PreservationReportEntry getPreservationReportModel(String requestId, int tenant, LocalDateTime now, WorkflowBatchResult.OutputExtra value, List<PreservationDistributionLine> entries) {
        PreservationDistributionLine model = (PreservationDistributionLine)IterableUtils.find(entries, j -> j.getObjectId().equals(value.getOutput().getInputPreservation().getName()));
        return new PreservationReportEntry(GUIDFactory.newGUID().toString(), requestId, tenant, LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)now), value.getOutput().getStatus(), model.getUnitId(), model.getId(), value.getOutput().getAction(), value.getOutput().getAnalyseResult(), value.getOutput().getInputPreservation().getName(), value.getBinaryGUID(), "Outcome - TO BE DEFINED", model.getGriffinIdentifier(), model.getScenarioId());
    }
}

