/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.MetadataStorageHelper;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookLifecycle;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.StoreMetadataObjectActionHandler;
import fr.gouv.vitam.worker.core.plugin.migration.MigrationUnitPrepare;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.WorkspaceClientServerException;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;

public class MigrationUnits
extends StoreMetadataObjectActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MigrationUnitPrepare.class);
    private static final String UNIT_UPDATE_MIGRATION = "UPDATE_MIGRATION_UNITS";
    private static final String MIGRATION_UNITS = "MIGRATION_UNITS";
    public static final String LFC_UPDATE_MIGRATION_UNITS = "LFC.UPDATE_MIGRATION_UNITS";
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final StorageClientFactory storageClientFactory;

    @VisibleForTesting
    public MigrationUnits(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, StorageClientFactory storageClientFactory) {
        super(storageClientFactory);
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public MigrationUnits() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new IllegalStateException("UnsupportedOperation");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
             LogbookLifeCyclesClient logbookLifeCyclesClientFactoryClient = this.logbookLifeCyclesClientFactory.getClient();
             StorageClient storageClient = this.storageClientFactory.getClient();){
            UpdateMultiQuery multiQuery = new UpdateMultiQuery();
            multiQuery.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{VitamThreadUtils.getVitamSession().getRequestId()})});
            multiQuery.resetQueries();
            List units = workerParameters.getObjectNameList();
            multiQuery.resetRoots().addRoots(units.toArray(new String[0]));
            RequestResponse requestResponse = metaDataClient.updateUnitBulk((JsonNode)multiQuery.getFinalUpdate());
            if (requestResponse == null) throw new ProcessingException("Error when trying to update units.");
            if (!requestResponse.isOk()) throw new ProcessingException("Error when trying to update units.");
            List<ItemStatus> list = ((RequestResponseOK)requestResponse).getResults().stream().map(result -> this.postMigation(workerParameters, handler, metaDataClient, logbookLifeCyclesClientFactoryClient, storageClient, (JsonNode)result)).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private ItemStatus postMigation(WorkerParameters workerParameters, HandlerIO handler, MetaDataClient metaDataClient, LogbookLifeCyclesClient logbookLifeCyclesClientFactoryClient, StorageClient storageClient, JsonNode unitNode) {
        String unitId = unitNode.get("#id").asText();
        String diff = unitNode.get("#diff").asText();
        try {
            this.writeLfcToMongo(logbookLifeCyclesClientFactoryClient, workerParameters, unitId, diff);
        }
        catch (InvalidGuidOperationException | InvalidParseOperationException | LogbookClientNotFoundException | LogbookClientServerException e) {
            LOGGER.error(e);
            return PluginHelper.buildItemStatus(MIGRATION_UNITS, StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("Error '%s' while updating UNIT LFC.", e.getMessage())));
        }
        catch (LogbookClientBadRequestException e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(MIGRATION_UNITS, StatusCode.KO, PluginHelper.EventDetails.of(String.format("Error '%s' while updating UNIT LFC.", e.getMessage())));
        }
        try {
            this.storeUnitAndLfcToOffer(metaDataClient, logbookLifeCyclesClientFactoryClient, storageClient, handler, workerParameters, unitId, unitId + ".json");
        }
        catch (VitamException e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(MIGRATION_UNITS, StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("Error while storing UNIT with LFC '%s'.", e.getMessage())));
        }
        return PluginHelper.buildItemStatus(MIGRATION_UNITS, StatusCode.OK, PluginHelper.EventDetails.of("Update OK"));
    }

    private boolean lfcAlreadyWrittenInMongo(LogbookLifeCyclesClient lfcClient, String unitId, String currentOperationId) throws VitamException {
        JsonNode lfc = lfcClient.getRawUnitLifeCycleById(unitId);
        LogbookLifecycle unitLFC = (LogbookLifecycle)JsonHandler.getFromJsonNode((JsonNode)lfc, LogbookLifecycle.class);
        return unitLFC.getEvents().stream().anyMatch(e -> e.getEvIdProc().equals(currentOperationId));
    }

    private void writeLfcToMongo(LogbookLifeCyclesClient lfcClient, WorkerParameters param, String unitId, String diff) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException, InvalidParseOperationException, InvalidGuidOperationException {
        LogbookLifeCycleUnitParameters logbookLfcParam = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()), (String)VitamLogbookMessages.getEventTypeLfc((String)UNIT_UPDATE_MIGRATION), (GUID)GUIDReader.getGUID((String)param.getContainerName()), (LogbookTypeProcess)param.getLogbookTypeProcess(), (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)UNIT_UPDATE_MIGRATION, (StatusCode)StatusCode.OK), (String)VitamLogbookMessages.getCodeLfc((String)UNIT_UPDATE_MIGRATION, (StatusCode)StatusCode.OK), (GUID)GUIDReader.getGUID((String)unitId));
        logbookLfcParam.putParameterValue(LogbookParameterName.eventDetailData, this.getEvDetDataForDiff(diff));
        lfcClient.update((LogbookLifeCycleParameters)logbookLfcParam, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
    }

    private String getEvDetDataForDiff(String diff) throws InvalidParseOperationException {
        if (diff == null) {
            return "";
        }
        ObjectNode diffObject = JsonHandler.createObjectNode();
        diffObject.put("diff", diff);
        diffObject.put("version", VitamConfiguration.getDiffVersion());
        return JsonHandler.writeAsString((Object)diffObject);
    }

    private void storeUnitAndLfcToOffer(MetaDataClient mdClient, LogbookLifeCyclesClient lfcClient, StorageClient storageClient, HandlerIO handler, WorkerParameters params, String guid, String fileName) throws VitamException {
        JsonNode unit = this.selectMetadataDocumentRawById(guid, DataCategory.UNIT, mdClient);
        String strategyId = MetadataDocumentHelper.getStrategyIdFromRawUnitOrGot((JsonNode)unit);
        MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)unit);
        JsonNode lfc = this.getRawLogbookLifeCycleById(guid, DataCategory.UNIT, lfcClient);
        JsonNode docWithLfc = MetadataStorageHelper.getUnitWithLFC((JsonNode)unit, (JsonNode)lfc);
        try {
            InputStream is = CanonicalJsonFormatter.serialize((JsonNode)docWithLfc);
            handler.transferInputStreamToWorkspace("Units/" + fileName, is, null, false);
        }
        catch (ProcessingException e) {
            LOGGER.error(params.getObjectName(), (Throwable)e);
            throw new WorkspaceClientServerException((Throwable)e);
        }
        String uri = "Units" + File.separator + fileName;
        ObjectDescription description = new ObjectDescription(DataCategory.UNIT, params.getContainerName(), fileName, uri);
        storageClient.storeFileFromWorkspace(strategyId, description.getType(), description.getObjectName(), description);
    }
}

