/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.migration.MigrationHelper;

public class MigrationUnitPrepare
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MigrationUnitPrepare.class);
    private static final String MIGRATION_UNITS_LIST = "MIGRATION_UNITS_LIST";
    static final String MIGRATION_UNITS_LIST_IDS = "migrationUnitsListIds";
    private final MetaDataClientFactory metaDataClientFactory;
    private final int bachSize;
    private static final String REPORTS = "reports";

    @VisibleForTesting
    public MigrationUnitPrepare(MetaDataClientFactory metaDataClientFactory, int bachSize) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.bachSize = bachSize;
    }

    public MigrationUnitPrepare() {
        this(MetaDataClientFactory.getInstance(), 10000);
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(MIGRATION_UNITS_LIST);
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            SelectMultiQuery selectMultiQuery = MigrationHelper.getSelectMultiQuery();
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(client, selectMultiQuery, this.bachSize);
            MigrationHelper.exportToReportAndDistributionFile(scrollRequest, handler, "Units.jsonl", "reports/migrationUnitsListIds.json");
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | ProcessingException e) {
            LOGGER.error(e);
            return itemStatus.increment(StatusCode.FATAL);
        }
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(MIGRATION_UNITS_LIST).setItemsStatus(MIGRATION_UNITS_LIST, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

