/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.migration;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.StreamSupport;

class MigrationHelper {
    private static final String FIELDS_KEY = "$fields";
    private static final String ID = "#id";
    private static final String EVENTS_FIELD_NAME = "events";

    MigrationHelper() {
    }

    static SelectMultiQuery getSelectMultiQuery() throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
        selectMultiQuery.setQuery((Query)QueryHelper.exists((String)ID));
        ObjectNode objectNode = JsonHandler.createObjectNode();
        objectNode.put(VitamFieldsHelper.id(), 1);
        JsonNode projection = JsonHandler.createObjectNode().set(FIELDS_KEY, (JsonNode)objectNode);
        selectMultiQuery.setProjection(projection);
        return selectMultiQuery;
    }

    static void exportToReportAndDistributionFile(ScrollSpliterator<JsonNode> scrollRequest, HandlerIO handler, String jsonLineFileName, String reportFilename) throws ProcessingException {
        File report = handler.getNewLocalFile("report.json");
        File distributionFile = handler.getNewLocalFile(jsonLineFileName);
        try (FileOutputStream distributionOutputStream = new FileOutputStream(distributionFile);
             JsonLineWriter distributionFileWriter = new JsonLineWriter((OutputStream)distributionOutputStream);
             FileOutputStream reportOutputStream = new FileOutputStream(report);
             JsonGenerator jsonGenerator = JsonHandler.createJsonGenerator((OutputStream)reportOutputStream);){
            jsonGenerator.writeStartArray();
            StreamSupport.stream(scrollRequest, false).forEach(item -> {
                String id = item.get(ID).asText();
                try {
                    distributionFileWriter.addEntry(new JsonLineModel(id));
                    jsonGenerator.writeString(id);
                }
                catch (IOException e) {
                    throw new VitamRuntimeException((Throwable)e);
                }
            });
            jsonGenerator.writeEndArray();
        }
        catch (IOException e) {
            throw new ProcessingException("Could not save linked files", (Throwable)e);
        }
        handler.transferFileToWorkspace(jsonLineFileName, distributionFile, true, false);
        handler.transferFileToWorkspace(reportFilename, report, true, false);
    }

    static boolean checkMigrationEvents(JsonNode lfc, String eventType) {
        JsonNode lastEvent = null;
        if (lfc != null && lfc.get(EVENTS_FIELD_NAME) != null) {
            lastEvent = lfc.get(EVENTS_FIELD_NAME).get(lfc.get(EVENTS_FIELD_NAME).size() - 1);
        }
        return lastEvent != null && !lastEvent.get("evType").asText().equals(eventType);
    }
}

