/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.functional.administration.common.exception.BackupServiceException;
import fr.gouv.vitam.functional.administration.core.backup.BackupService;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.HandlerUtils;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.io.InputStream;

public class MigrationFinalize
extends ActionHandler {
    private static final String MIGRATION_FINALIZE = "MIGRATION_FINALIZE";
    private final BackupService backupService;
    private static final String REPORTS = "reports";

    @VisibleForTesting
    private MigrationFinalize(BackupService backupService) {
        this.backupService = backupService;
    }

    public MigrationFinalize() {
        this(new BackupService());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(MIGRATION_FINALIZE);
        String reportFileName = handlerIO.getContainerName() + ".json";
        this.saveReportToWorkspace(handlerIO, reportFileName);
        this.storeInOffers(reportFileName);
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(MIGRATION_FINALIZE).setItemsStatus(MIGRATION_FINALIZE, itemStatus);
    }

    private void saveReportToWorkspace(HandlerIO handlerIO, String reportFileName) throws ProcessingException {
        if (handlerIO.isExistingFileInWorkspace(reportFileName)) {
            return;
        }
        try {
            ObjectNode reportJson = JsonHandler.createObjectNode();
            if (handlerIO.isExistingFileInWorkspace("reports/migrationUnitsListIds.json")) {
                reportJson.set("units", JsonHandler.getFromInputStream((InputStream)handlerIO.getInputStreamFromWorkspace("reports/migrationUnitsListIds.json")));
            } else {
                reportJson.set("units", (JsonNode)JsonHandler.createArrayNode());
            }
            HandlerUtils.save(handlerIO, (Object)reportJson, reportFileName);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingException(e);
        }
    }

    private void storeInOffers(String reportFileName) throws ProcessingException {
        try {
            this.backupService.backupFromWorkspace(reportFileName, DataCategory.REPORT, reportFileName);
        }
        catch (BackupServiceException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

