/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.massprocessing.management;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.ReportBody;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.batch.report.model.entry.UpdateUnitMetadataReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DurationData;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.MetadataStorageHelper;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import fr.gouv.vitam.common.model.massupdate.RuleAction;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryAction;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.StoreMetadataObjectActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.WorkspaceClientServerException;
import java.io.File;
import java.io.InputStream;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MassUpdateUnitsRulesProcess
extends StoreMetadataObjectActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);
    private static final String MASS_UPDATE_UNITS_RULES = "MASS_UPDATE_UNITS_RULES";
    private static final String UNIT_METADATA_UPDATE = "UNIT_METADATA_UPDATE";
    private static final String JSON = ".json";
    private static final String ID = "#id";
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory lfcClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final BatchReportClientFactory batchReportClientFactory;

    public MassUpdateUnitsRulesProcess() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance(), AdminManagementClientFactory.getInstance(), BatchReportClientFactory.getInstance());
    }

    @VisibleForTesting
    public MassUpdateUnitsRulesProcess(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory lfcClientFactory, StorageClientFactory storageClientFactory, AdminManagementClientFactory adminManagementClientFactory, BatchReportClientFactory batchReportClientFactory) {
        super(storageClientFactory);
        this.metaDataClientFactory = metaDataClientFactory;
        this.lfcClientFactory = lfcClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.batchReportClientFactory = batchReportClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new IllegalStateException("UnsupportedOperation");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try (MetaDataClient mdClient = this.metaDataClientFactory.getClient();
             LogbookLifeCyclesClient lfcClient = this.lfcClientFactory.getClient();
             StorageClient storageClient = this.storageClientFactory.getClient();
             BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            RuleActions ruleActions = (RuleActions)JsonHandler.getFromJsonNode((JsonNode)handler.getJsonFromWorkspace("actions.json"), RuleActions.class);
            List units = workerParameters.getObjectNameList();
            Map<String, DurationData> bindRulesToDuration = this.checkAndComputeRuleDurationData(ruleActions);
            RequestResponse requestResponse = mdClient.updateUnitsRulesBulk(units, ruleActions, bindRulesToDuration);
            ArrayList entries = new ArrayList();
            if (requestResponse == null) throw new ProcessingException("Error when trying to update units.");
            if (!requestResponse.isOk()) throw new ProcessingException("Error when trying to update units.");
            List<ItemStatus> itemStatuses = ((RequestResponseOK)requestResponse).getResults().stream().map(result -> this.postUpdate(workerParameters, handler, mdClient, lfcClient, storageClient, entries, (JsonNode)result)).collect(Collectors.toList());
            ReportBody reportBody = new ReportBody();
            reportBody.setProcessId(workerParameters.getProcessId());
            reportBody.setReportType(ReportType.UPDATE_UNIT);
            reportBody.setEntries(entries);
            if (!entries.isEmpty()) {
                batchReportClient.appendReportEntries(reportBody);
            }
            List<ItemStatus> list = itemStatuses;
            return list;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private ItemStatus postUpdate(WorkerParameters workerParameters, HandlerIO handler, MetaDataClient mdClient, LogbookLifeCyclesClient lfcClient, StorageClient storageClient, List<UpdateUnitMetadataReportEntry> entries, JsonNode result) {
        String unitId = result.get(ID).asText();
        String key = result.get("#key").asText();
        String statusAsString = result.get("#status").asText();
        StatusCode status = StatusCode.valueOf((String)statusAsString);
        String message = result.get("#message").asText();
        String diff = result.get("#diff").asText();
        if (!("null".equals(diff) && StringUtils.isBlank((CharSequence)diff) || !status.equals((Object)StatusCode.OK) && !status.equals((Object)StatusCode.WARNING))) {
            try {
                this.writeLfcForUpdateUnit(lfcClient, workerParameters, unitId, diff);
            }
            catch (InvalidGuidOperationException | InvalidParseOperationException | LogbookClientNotFoundException | LogbookClientServerException e) {
                return PluginHelper.buildItemStatus(MASS_UPDATE_UNITS_RULES, StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("Error '%s' while updating UNIT LFC.", e.getMessage())));
            }
            catch (LogbookClientBadRequestException e) {
                return PluginHelper.buildItemStatus(MASS_UPDATE_UNITS_RULES, StatusCode.KO, PluginHelper.EventDetails.of(String.format("Error '%s' while updating UNIT LFC.", e.getMessage())));
            }
            try {
                this.saveUnitWithLfc(mdClient, lfcClient, storageClient, handler, workerParameters, unitId, unitId + JSON);
            }
            catch (VitamException e) {
                try {
                    lfcClient.rollBackUnitsByOperation(workerParameters.getContainerName());
                }
                catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e1) {
                    LOGGER.error(String.format("Error while storing UNIT with LFC %s.", new Object[]{e}));
                    return PluginHelper.buildItemStatus(MASS_UPDATE_UNITS_RULES, StatusCode.FATAL, PluginHelper.EventDetails.of(String.format("Error while storing UNIT with LFC %s.", new Object[]{e})));
                }
            }
        }
        if (!StatusCode.OK.equals((Object)status)) {
            VitamSession vitamSession = VitamThreadUtils.getVitamSession();
            UpdateUnitMetadataReportEntry entry = new UpdateUnitMetadataReportEntry(vitamSession.getTenantId(), workerParameters.getContainerName(), unitId, key, status, String.format("%s.%s", MASS_UPDATE_UNITS_RULES, status), message);
            entries.add(entry);
            return PluginHelper.buildItemStatus(MASS_UPDATE_UNITS_RULES, StatusCode.KO, PluginHelper.EventDetails.of(message));
        }
        return PluginHelper.buildItemStatus(MASS_UPDATE_UNITS_RULES, StatusCode.OK, PluginHelper.EventDetails.of("Mass unit rule update OK"));
    }

    private Map<String, DurationData> checkAndComputeRuleDurationData(RuleActions ruleActions) throws IllegalStateException {
        List ruleUpdates;
        HashMap<String, DurationData> bindRulesToDuration = new HashMap<String, DurationData>();
        List ruleAddition = ruleActions.getAdd();
        if (ruleAddition != null) {
            ruleAddition.stream().flatMap(x -> x.entrySet().stream()).forEach(x -> this.computeRuleDurationData((String)x.getKey(), (RuleCategoryAction)x.getValue(), bindRulesToDuration, false));
        }
        if ((ruleUpdates = ruleActions.getUpdate()) != null) {
            ruleUpdates.stream().flatMap(x -> x.entrySet().stream()).forEach(x -> this.computeRuleDurationData((String)x.getKey(), (RuleCategoryAction)x.getValue(), bindRulesToDuration, true));
        }
        return bindRulesToDuration;
    }

    private void computeRuleDurationData(String ruleType, RuleCategoryAction category, Map<String, DurationData> bindRuleDuration, Boolean isUpdate) {
        for (RuleAction rule : category.getRules()) {
            JsonNode ruleResponseInReferential;
            String ruleId = rule.getRule();
            if (!(ruleId != null || isUpdate.booleanValue() && rule.getOldRule() != null)) {
                throw new IllegalStateException("Cannot add a new rule withour RuleId");
            }
            if (ruleId == null) {
                ruleId = rule.getOldRule();
            }
            try {
                ruleResponseInReferential = this.adminManagementClientFactory.getClient().getRuleByID(ruleId);
            }
            catch (InvalidParseOperationException | AdminManagementClientServerException | FileRulesException e) {
                throw new IllegalStateException("Can't get the Rule " + rule.getRule() + " in Rules Referential");
            }
            JsonNode ruleInReferential = ruleResponseInReferential.get("$results").get(0);
            if (ruleType.equals("HoldRule") && !ruleInReferential.hasNonNull("RuleDuration")) {
                bindRuleDuration.put(ruleId, new DurationData(null, null));
                continue;
            }
            String duration = ruleInReferential.get("RuleDuration").asText();
            String measurement = ruleInReferential.get("RuleMeasurement").asText();
            RuleMeasurementEnum ruleMeasurement = RuleMeasurementEnum.getEnumFromType((String)measurement);
            if (bindRuleDuration.get(ruleId) != null || "unlimited".equalsIgnoreCase(duration)) continue;
            bindRuleDuration.put(ruleId, new DurationData(Integer.valueOf(Integer.parseInt(duration)), (ChronoUnit)ruleMeasurement.getTemporalUnit()));
        }
    }

    private void writeLfcForUpdateUnit(LogbookLifeCyclesClient lfcClient, WorkerParameters param, String unitId, String diff) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException, InvalidParseOperationException, InvalidGuidOperationException {
        LogbookLifeCycleUnitParameters logbookLfcParam = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()), (String)VitamLogbookMessages.getEventTypeLfc((String)UNIT_METADATA_UPDATE), (GUID)GUIDReader.getGUID((String)param.getContainerName()), (LogbookTypeProcess)param.getLogbookTypeProcess(), (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)UNIT_METADATA_UPDATE, (StatusCode)StatusCode.OK), (String)VitamLogbookMessages.getCodeLfc((String)UNIT_METADATA_UPDATE, (StatusCode)StatusCode.OK), (GUID)GUIDReader.getGUID((String)unitId));
        logbookLfcParam.putParameterValue(LogbookParameterName.eventDetailData, this.getEvDetDataForDiff(diff));
        lfcClient.update((LogbookLifeCycleParameters)logbookLfcParam, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
    }

    private String getEvDetDataForDiff(String diff) throws InvalidParseOperationException {
        if (diff == null) {
            return "";
        }
        ObjectNode diffObject = JsonHandler.createObjectNode();
        diffObject.put("diff", diff);
        diffObject.put("version", VitamConfiguration.getDiffVersion());
        return JsonHandler.writeAsString((Object)diffObject);
    }

    protected void saveUnitWithLfc(MetaDataClient mdClient, LogbookLifeCyclesClient lfcClient, StorageClient storageClient, HandlerIO handler, WorkerParameters params, String guid, String fileName) throws VitamException {
        JsonNode unit = this.selectMetadataDocumentRawById(guid, DataCategory.UNIT, mdClient);
        String strategyId = MetadataDocumentHelper.getStrategyIdFromRawUnitOrGot((JsonNode)unit);
        MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)unit);
        JsonNode lfc = this.getRawLogbookLifeCycleById(guid, DataCategory.UNIT, lfcClient);
        JsonNode docWithLfc = MetadataStorageHelper.getUnitWithLFC((JsonNode)unit, (JsonNode)lfc);
        try {
            InputStream is = CanonicalJsonFormatter.serialize((JsonNode)docWithLfc);
            handler.transferInputStreamToWorkspace("Units/" + fileName, is, null, false);
        }
        catch (ProcessingException e) {
            LOGGER.error(params.getObjectName(), (Throwable)e);
            throw new WorkspaceClientServerException((Throwable)e);
        }
        ObjectDescription description = new ObjectDescription(DataCategory.UNIT, params.getContainerName(), fileName, "Units" + File.separator + fileName);
        storageClient.storeFileFromWorkspace(strategyId, description.getType(), description.getObjectName(), description);
    }
}

