/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.massprocessing.management;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.massupdate.ManagementMetadataAction;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryAction;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryActionDeletion;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.massprocessing.MassUpdateErrorInfo;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;

public class MassUpdateRulesCheck
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);
    private static final String PLUGIN_NAME = "MASS_UPDATE_RULES_CHECK";
    private final AlertService alertService;
    private final List<String> classificationLevels;

    public MassUpdateRulesCheck() {
        this((AlertService)new AlertServiceImpl(), VitamConfiguration.getClassificationLevel().getAllowList());
    }

    @VisibleForTesting
    public MassUpdateRulesCheck(AlertService alertService, List<String> classificationLevels) {
        this.alertService = alertService;
        this.classificationLevels = classificationLevels;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        try {
            RuleActions ruleActions = (RuleActions)JsonHandler.getFromJsonNode((JsonNode)handler.getJsonFromWorkspace("actions.json"), RuleActions.class);
            if (ruleActions.isRuleActionsEmpty()) {
                MassUpdateErrorInfo errorInfo = new MassUpdateErrorInfo("RULE_ACTION_EMPTY", "Rule actions used to update units is empty.");
                return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.KO, errorInfo);
            }
            List<String> duplicateKeys = this.getDuplicateKeys(ruleActions);
            if (!duplicateKeys.isEmpty()) {
                String message = String.format("Invalid rule actions query: duplicate rules '%s'.", String.join((CharSequence)", ", duplicateKeys));
                return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, message);
            }
            boolean deleteOrAddSameAUP = this.isTryingToAddAndDeleteAUP(ruleActions.getAddOrUpdateMetadata(), ruleActions.getDeleteMetadata());
            if (deleteOrAddSameAUP) {
                String message = String.format("Invalid AUP query: duplicate in add or delete '%s'.", ruleActions.getAddOrUpdateMetadata().getArchiveUnitProfile());
                return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, message);
            }
            List unknownAddClassificationLevels = ruleActions.getAdd().stream().filter(rule -> Objects.nonNull(rule.get("ClassificationRule"))).map(rule -> ((RuleCategoryAction)rule.get("ClassificationRule")).getClassificationLevel()).filter(Objects::nonNull).filter(classificationLevel -> !this.classificationLevels.contains(classificationLevel)).collect(Collectors.toList());
            if (!unknownAddClassificationLevels.isEmpty()) {
                String message = String.format("Unknown classification level '%s' in added rule action.", String.join((CharSequence)", ", unknownAddClassificationLevels));
                this.alertService.createAlert(message);
                return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, message);
            }
            List unknownUpdateClassificationLevels = ruleActions.getUpdate().stream().filter(rule -> Objects.nonNull(rule.get("ClassificationRule"))).map(rule -> ((RuleCategoryAction)rule.get("ClassificationRule")).getClassificationLevel()).filter(Objects::nonNull).filter(classificationLevel -> !this.classificationLevels.contains(classificationLevel)).collect(Collectors.toList());
            if (!unknownUpdateClassificationLevels.isEmpty()) {
                String message = String.format("Unknown classification level '%s' in updated rule action.", String.join((CharSequence)", ", unknownUpdateClassificationLevels));
                this.alertService.createAlert(message);
                return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, message);
            }
            if (this.numberOfInCorrectDeleteRule(ruleActions) > 0) {
                String message = "You can not add preventRulesId and preventRulesIdToRemove at the same time";
                this.alertService.createAlert("You can not add preventRulesId and preventRulesIdToRemove at the same time");
                return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, "You can not add preventRulesId and preventRulesIdToRemove at the same time");
            }
            if (this.numberOfInCorrectAddRule(ruleActions) > 0) {
                String message = "You can not add preventRulesId and preventRulesIdToAdd at the same time";
                this.alertService.createAlert("You can not add preventRulesId and preventRulesIdToAdd at the same time");
                return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, "You can not add preventRulesId and preventRulesIdToAdd at the same time");
            }
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of("Step OK."));
        }
        catch (VitamException e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.KO, PluginHelper.EventDetails.of("Unexpected error."));
        }
    }

    private boolean isTryingToAddAndDeleteAUP(ManagementMetadataAction addOrUpdateMetadata, ManagementMetadataAction deleteMetadata) {
        if (addOrUpdateMetadata == null || addOrUpdateMetadata.getArchiveUnitProfile() == null || deleteMetadata == null || deleteMetadata.getArchiveUnitProfile() == null) {
            return false;
        }
        return addOrUpdateMetadata.getArchiveUnitProfile().equalsIgnoreCase(deleteMetadata.getArchiveUnitProfile());
    }

    private List<String> getDuplicateKeys(RuleActions rules) {
        HashSet foundKeys = new HashSet();
        return Stream.concat(Stream.concat(rules.getAdd().stream(), rules.getUpdate().stream()), rules.getDelete().stream()).flatMap(map -> map.keySet().stream()).filter(key -> this.includeFoundedKey(foundKeys, (String)key)).collect(Collectors.toList());
    }

    private boolean includeFoundedKey(Set<String> foundKeys, String key) {
        if (foundKeys.contains(key)) {
            return true;
        }
        foundKeys.add(key);
        return false;
    }

    private int numberOfInCorrectDeleteRule(RuleActions ruleActions) {
        AtomicInteger numberOfInCorrectDeleteRule = new AtomicInteger();
        ruleActions.getDelete().forEach(ruleCategoryActionMap -> ruleCategoryActionMap.keySet().forEach(ruleCategoryName -> {
            if (ruleCategoryActionMap.get(ruleCategoryName) != null && !CollectionUtils.isEmpty((Collection)((RuleCategoryActionDeletion)ruleCategoryActionMap.get(ruleCategoryName)).getPreventRulesIdToRemove()) && !CollectionUtils.isEmpty((Collection)((RuleCategoryActionDeletion)ruleCategoryActionMap.get(ruleCategoryName)).getPreventRulesId())) {
                numberOfInCorrectDeleteRule.getAndIncrement();
            }
        }));
        return numberOfInCorrectDeleteRule.get();
    }

    private int numberOfInCorrectAddRule(RuleActions ruleActions) {
        AtomicInteger numberOfInCorrectAddRule = new AtomicInteger();
        ruleActions.getAdd().forEach(ruleCategoryActionMap -> ruleCategoryActionMap.keySet().forEach(ruleCategoryName -> {
            if (ruleCategoryActionMap.get(ruleCategoryName) != null && !CollectionUtils.isEmpty((Collection)((RuleCategoryAction)ruleCategoryActionMap.get(ruleCategoryName)).getPreventRulesIdToAdd()) && !CollectionUtils.isEmpty((Collection)((RuleCategoryAction)ruleCategoryActionMap.get(ruleCategoryName)).getPreventRulesId())) {
                numberOfInCorrectAddRule.getAndIncrement();
            }
        }));
        return numberOfInCorrectAddRule.get();
    }
}

