/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.massprocessing.description;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.InternalActionKeysRetriever;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.List;

public class MassUpdateCheck
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MassUpdateCheck.class);
    private static final String PLUGIN_NAME = "MASS_UPDATE_CHECK";
    private final InternalActionKeysRetriever internalActionKeysRetriever;

    public MassUpdateCheck() {
        this(new InternalActionKeysRetriever());
    }

    @VisibleForTesting
    public MassUpdateCheck(InternalActionKeysRetriever internalActionKeysRetriever) {
        this.internalActionKeysRetriever = internalActionKeysRetriever;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            List internalKeyFields = this.internalActionKeysRetriever.getInternalActionKeyFields(handler.getJsonFromWorkspace("query.json"));
            if (!internalKeyFields.isEmpty()) {
                String message = String.format("Invalid DSL query: cannot contains '%s' internal field(s).", String.join((CharSequence)", ", internalKeyFields));
                return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, message);
            }
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of("Check OK."));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.KO, PluginHelper.EventDetails.of("Check KO unexpected error."));
        }
    }
}

