/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.massprocessing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileStatus;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.model.massupdate.RuleAction;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryAction;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryActionDeletion;
import fr.gouv.vitam.common.utils.ClassificationLevelUtil;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class UnitMetadataRulesUpdateCheckConsistency
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UnitMetadataRulesUpdateCheckConsistency.class);
    private static final String UNIT_METADATA_CHECK_CONSISTENCY = "UNIT_METADATA_CHECK_CONSISTENCY";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String MESSAGE = "Message";
    private static final String ERROR = "Error";
    private static final String INFO = "Info ";
    private static final String ARCHIVE_UNIT_PROFILE = "ArchiveUnitProfile ";
    private static final String HOLD_REASON = "HoldReason";
    private static final String HOLD_OWNER = "HoldOwner";
    private static final String HOLD_END_DATE = "HoldEndDate";
    private static final String HOLD_REASSESSING_DATE = "HoldReassessingDate";
    private static final String ARCHIVE_UNIT_PROFILE_NOT_FOUND = "Error while get the ArchiveUnitProfile in Referential";
    private final AdminManagementClientFactory adminManagementClientFactory;

    public UnitMetadataRulesUpdateCheckConsistency() {
        this(AdminManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    public UnitMetadataRulesUpdateCheckConsistency(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        this.checkMandatoryParameters(param);
        ItemStatus itemStatus = new ItemStatus(UNIT_METADATA_CHECK_CONSISTENCY);
        JsonNode queryActions = handler.getJsonFromWorkspace("actions.json");
        if (JsonHandler.isNullOrEmpty((JsonNode)queryActions)) {
            itemStatus.increment(StatusCode.KO);
            return new ItemStatus(UNIT_METADATA_CHECK_CONSISTENCY).setItemsStatus(UNIT_METADATA_CHECK_CONSISTENCY, itemStatus);
        }
        try {
            Optional<JsonNode> errorEvDetData = this.getErrorFromActionQuery(queryActions);
            if (errorEvDetData.isPresent()) {
                LOGGER.error("Rule update request validation failed \n" + JsonHandler.unprettyPrint((Object)errorEvDetData.get()));
                itemStatus.increment(StatusCode.KO);
                itemStatus.setMessage(VitamCode.UPDATE_UNIT_RULES_CONSISTENCY.name());
                itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)errorEvDetData.get()));
                return new ItemStatus(UNIT_METADATA_CHECK_CONSISTENCY).setItemsStatus(UNIT_METADATA_CHECK_CONSISTENCY, itemStatus);
            }
        }
        catch (VitamException | IllegalStateException e) {
            throw new ProcessingException(e);
        }
        LOGGER.info("Rule update request validation succeeded");
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(UNIT_METADATA_CHECK_CONSISTENCY).setItemsStatus(UNIT_METADATA_CHECK_CONSISTENCY, itemStatus);
    }

    private Optional<JsonNode> getErrorFromActionQuery(JsonNode queryActions) throws InvalidParseOperationException {
        RuleActions ruleActions = (RuleActions)JsonHandler.getFromJsonNode((JsonNode)queryActions, RuleActions.class);
        Optional<JsonNode> potentialErrorInManagement = this.computeErrorsForManagementMetadata(ruleActions);
        if (potentialErrorInManagement.isPresent()) {
            return potentialErrorInManagement;
        }
        Optional<JsonNode> updateError = ruleActions.getUpdate().stream().flatMap(x -> x.entrySet().stream()).map(this::computeErrorsForUpdate).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (updateError.isPresent()) {
            return updateError;
        }
        Optional<JsonNode> addError = ruleActions.getAdd().stream().flatMap(x -> x.entrySet().stream()).map(this::computeErrorsForAdd).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (addError.isPresent()) {
            return addError;
        }
        Optional<JsonNode> deleteError = ruleActions.getDelete().stream().flatMap(x -> x.entrySet().stream()).map(this::computeErrorsForDelete).filter(Optional::isPresent).map(Optional::get).findFirst();
        return deleteError;
    }

    private Optional<JsonNode> computeErrorsForManagementMetadata(RuleActions ruleActions) {
        Optional<JsonNode> error;
        if (ruleActions.getAddOrUpdateMetadata() != null && ruleActions.getAddOrUpdateMetadata().getArchiveUnitProfile() != null && (error = this.checkAUPId(ruleActions.getAddOrUpdateMetadata().getArchiveUnitProfile())).isPresent()) {
            return error;
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkAUPId(String aupId) {
        try {
            RequestResponse aup = this.adminManagementClientFactory.getClient().findArchiveUnitProfilesByID(aupId);
            if (!aup.isOk()) {
                throw new IllegalStateException(ARCHIVE_UNIT_PROFILE_NOT_FOUND);
            }
            ArchiveUnitProfileModel archiveUnitProfile = (ArchiveUnitProfileModel)((RequestResponseOK)aup).getFirstResult();
            if (archiveUnitProfile == null) {
                throw new IllegalStateException(ARCHIVE_UNIT_PROFILE_NOT_FOUND);
            }
            if (!ArchiveUnitProfileStatus.ACTIVE.equals((Object)archiveUnitProfile.getStatus())) {
                ObjectNode errorInfo = JsonHandler.createObjectNode();
                errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_MANAGEMENT_METADATA_CONSISTENCY.name());
                errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_MANAGEMENT_METADATA_CONSISTENCY.getMessage());
                errorInfo.put(INFO, ARCHIVE_UNIT_PROFILE + aupId + " is not ACTIVE");
                errorInfo.put("Code", "CHECK_UNIT_PROFILE_INACTIVE");
                return Optional.of(errorInfo);
            }
            if (archiveUnitProfile.getControlSchema() == null || JsonHandler.isEmpty((String)archiveUnitProfile.getControlSchema())) {
                ObjectNode errorInfo = JsonHandler.createObjectNode();
                errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_MANAGEMENT_METADATA_CONSISTENCY.name());
                errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_MANAGEMENT_METADATA_CONSISTENCY.getMessage());
                errorInfo.put(INFO, ARCHIVE_UNIT_PROFILE + aupId + " havn't a valid Control Schema");
                errorInfo.put("Code", "CHECK_UNIT_PROFILE_CONSISTENCY");
                return Optional.of(errorInfo);
            }
        }
        catch (ReferentialNotFoundException e) {
            ObjectNode errorInfo = JsonHandler.createObjectNode();
            errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_MANAGEMENT_METADATA_CONSISTENCY.name());
            errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_MANAGEMENT_METADATA_CONSISTENCY.getMessage());
            errorInfo.put(INFO, ARCHIVE_UNIT_PROFILE + aupId + " is not in database");
            errorInfo.put("Code", "CHECK_UNIT_PROFILE_UNKNOWN");
            return Optional.of(errorInfo);
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException e) {
            throw new IllegalStateException(ARCHIVE_UNIT_PROFILE_NOT_FOUND);
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkDateFormat(String fieldName, String date, String category, boolean checkUpperLimit) {
        try {
            if (date == null) {
                return Optional.empty();
            }
            LocalDate parsedDate = LocalDate.parse(date, DATE_TIME_FORMATTER);
            if (checkUpperLimit && parsedDate.getYear() >= 9000) {
                ObjectNode errorInfo = JsonHandler.createObjectNode();
                errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
                errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
                errorInfo.put(INFO, "'" + fieldName + "' must be prior than year 9000 for category " + category);
                errorInfo.put("Code", "UNIT_METADATA_UPDATE_CHECK_RULES_DATE_UNAUTHORIZED");
                return Optional.of(errorInfo);
            }
        }
        catch (DateTimeParseException e) {
            ObjectNode errorInfo = JsonHandler.createObjectNode();
            errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
            errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
            errorInfo.put(INFO, "'" + fieldName + "' must follow 'AAAA-MM-DD' format " + category);
            errorInfo.put("Code", "UNIT_METADATA_UPDATE_CHECK_RULES_DATE_WRONG_FORMAT");
            return Optional.of(errorInfo);
        }
        return Optional.empty();
    }

    private Optional<JsonNode> computeErrorsForUpdate(Map.Entry<String, RuleCategoryAction> entry) {
        Optional<JsonNode> response = this.computeErrorsForCategory(entry);
        if (response.isPresent()) {
            return response;
        }
        if (entry.getValue().getRules() == null) {
            return Optional.empty();
        }
        for (RuleAction ruleAction : entry.getValue().getRules()) {
            Optional<JsonNode> checkFieldFormatError = this.checkRuleActionFormat(entry, ruleAction);
            if (checkFieldFormatError.isPresent()) {
                return checkFieldFormatError;
            }
            Optional<JsonNode> oldRuleToUpdateError = this.checkOldRuleToUpdate(entry, ruleAction);
            if (oldRuleToUpdateError.isPresent()) {
                return oldRuleToUpdateError;
            }
            Optional<JsonNode> emptyRuleActionError = this.checkEmptyRuleAction(entry, ruleAction);
            if (emptyRuleActionError.isPresent()) {
                return emptyRuleActionError;
            }
            if (null == ruleAction.getEndDate()) continue;
            return this.reportUnexpectedField(entry, "EndDate");
        }
        return Optional.empty();
    }

    private Optional<JsonNode> computeErrorsForAdd(Map.Entry<String, RuleCategoryAction> entry) {
        Optional<JsonNode> response = this.computeErrorsForCategory(entry);
        if (response.isPresent()) {
            return response;
        }
        for (RuleAction ruleAction : entry.getValue().getRules()) {
            Optional<JsonNode> checkFieldFormatError = this.checkRuleActionFormat(entry, ruleAction);
            if (checkFieldFormatError.isPresent()) {
                return checkFieldFormatError;
            }
            Optional<JsonNode> checkRuleToAddError = this.checkRuleToAdd(entry, ruleAction);
            if (checkRuleToAddError.isPresent()) {
                return checkRuleToAddError;
            }
            if (null != ruleAction.getEndDate()) {
                return this.reportUnexpectedField(entry, "EndDate");
            }
            if (null != ruleAction.getOldRule()) {
                return this.reportUnexpectedField(entry, "OldRule");
            }
            if (Boolean.TRUE.equals(ruleAction.isDeleteStartDate())) {
                return this.reportUnexpectedField(entry, "DeleteStartDate");
            }
            if (Boolean.TRUE.equals(ruleAction.getDeleteHoldEndDate())) {
                return this.reportUnexpectedField(entry, "DeleteHoldEndDate");
            }
            if (Boolean.TRUE.equals(ruleAction.getDeleteHoldOwner())) {
                return this.reportUnexpectedField(entry, "DeleteHoldOwner");
            }
            if (Boolean.TRUE.equals(ruleAction.getDeleteHoldReassessingDate())) {
                return this.reportUnexpectedField(entry, "DeleteHoldReassessingDate");
            }
            if (Boolean.TRUE.equals(ruleAction.getDeleteHoldReason())) {
                return this.reportUnexpectedField(entry, "DeleteHoldReason");
            }
            if (!Boolean.TRUE.equals(ruleAction.getDeletePreventRearrangement())) continue;
            return this.reportUnexpectedField(entry, "DeletePreventRearrangement");
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkRuleActionFormat(Map.Entry<String, RuleCategoryAction> entry, RuleAction ruleAction) {
        Optional<JsonNode> checkFieldFormatError = this.checkFieldFormats(entry, ruleAction);
        if (checkFieldFormatError.isPresent()) {
            return checkFieldFormatError;
        }
        Optional<JsonNode> setAndDeleteOfSameFieldsError = this.checkSetAndDeleteOfSameFields(entry, ruleAction);
        if (setAndDeleteOfSameFieldsError.isPresent()) {
            return setAndDeleteOfSameFieldsError;
        }
        Optional<JsonNode> holdRuleFieldsErrors = this.checkReservedHoldRuleAttributes(entry, ruleAction);
        if (holdRuleFieldsErrors.isPresent()) {
            return holdRuleFieldsErrors;
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkFieldFormats(Map.Entry<String, RuleCategoryAction> entry, RuleAction ruleAction) {
        Optional<JsonNode> checkStartDateResponse = this.checkDateFormat("StartDate", ruleAction.getStartDate(), entry.getKey(), true);
        if (checkStartDateResponse.isPresent()) {
            return checkStartDateResponse;
        }
        Optional<JsonNode> checkHoldEndDateResponse = this.checkDateFormat(HOLD_END_DATE, ruleAction.getHoldEndDate(), entry.getKey(), false);
        if (checkHoldEndDateResponse.isPresent()) {
            return checkHoldEndDateResponse;
        }
        Optional<JsonNode> checkHoldReassessingDateResponse = this.checkDateFormat(HOLD_REASSESSING_DATE, ruleAction.getHoldReassessingDate(), entry.getKey(), false);
        if (checkHoldReassessingDateResponse.isPresent()) {
            return checkHoldReassessingDateResponse;
        }
        if (null != ruleAction.getHoldOwner() && ruleAction.getHoldOwner().isBlank()) {
            return this.reportEmptyFieldFormat(entry, HOLD_OWNER);
        }
        if (null != ruleAction.getHoldReason() && ruleAction.getHoldReason().isBlank()) {
            return this.reportEmptyFieldFormat(entry, HOLD_REASON);
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkSetAndDeleteOfSameFields(Map.Entry<String, RuleCategoryAction> entry, RuleAction ruleAction) {
        if (ruleAction.getStartDate() != null && Boolean.TRUE.equals(ruleAction.getDeleteStartDate())) {
            return this.reportSetAndDeleteOfSameField(entry, "StartDate");
        }
        if (ruleAction.getHoldEndDate() != null && Boolean.TRUE.equals(ruleAction.getDeleteHoldEndDate())) {
            return this.reportSetAndDeleteOfSameField(entry, HOLD_END_DATE);
        }
        if (ruleAction.getHoldReason() != null && Boolean.TRUE.equals(ruleAction.getDeleteHoldReason())) {
            return this.reportSetAndDeleteOfSameField(entry, HOLD_REASON);
        }
        if (ruleAction.getHoldReassessingDate() != null && Boolean.TRUE.equals(ruleAction.getDeleteHoldReassessingDate())) {
            return this.reportSetAndDeleteOfSameField(entry, HOLD_REASSESSING_DATE);
        }
        if (ruleAction.getHoldOwner() != null && Boolean.TRUE.equals(ruleAction.getDeleteHoldOwner())) {
            return this.reportSetAndDeleteOfSameField(entry, HOLD_OWNER);
        }
        if (ruleAction.getPreventRearrangement() != null && Boolean.TRUE.equals(ruleAction.getDeletePreventRearrangement())) {
            return this.reportSetAndDeleteOfSameField(entry, "PreventRearrangement");
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkReservedHoldRuleAttributes(Map.Entry<String, RuleCategoryAction> entry, RuleAction ruleAction) {
        if (RuleType.HoldRule.isNameEquals(entry.getKey())) {
            return Optional.empty();
        }
        if (null != ruleAction.getHoldEndDate()) {
            return this.reportUnexpectedField(entry, HOLD_END_DATE);
        }
        if (null != ruleAction.getDeleteHoldEndDate()) {
            return this.reportUnexpectedField(entry, "DeleteHoldEndDate");
        }
        if (null != ruleAction.getHoldOwner()) {
            return this.reportUnexpectedField(entry, HOLD_OWNER);
        }
        if (null != ruleAction.getDeleteHoldOwner()) {
            return this.reportUnexpectedField(entry, "DeleteHoldOwner");
        }
        if (null != ruleAction.getHoldReassessingDate()) {
            return this.reportUnexpectedField(entry, HOLD_REASSESSING_DATE);
        }
        if (null != ruleAction.getDeleteHoldReassessingDate()) {
            return this.reportUnexpectedField(entry, "DeleteHoldReassessingDate");
        }
        if (null != ruleAction.getHoldReason()) {
            return this.reportUnexpectedField(entry, HOLD_REASON);
        }
        if (null != ruleAction.getDeleteHoldReason()) {
            return this.reportUnexpectedField(entry, "DeleteHoldReason");
        }
        if (null != ruleAction.getPreventRearrangement()) {
            return this.reportUnexpectedField(entry, "PreventRearrangement");
        }
        if (null != ruleAction.getDeletePreventRearrangement()) {
            return this.reportUnexpectedField(entry, "DeletePreventRearrangement");
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkOldRuleToUpdate(Map.Entry<String, RuleCategoryAction> entry, RuleAction ruleAction) {
        if (StringUtils.isEmpty((CharSequence)ruleAction.getOldRule())) {
            ObjectNode errorInfo = JsonHandler.createObjectNode();
            errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
            errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
            errorInfo.put(INFO, "Rule update should define an 'OldRule' to be updated for category " + entry.getKey());
            errorInfo.put("Code", "UNIT_RULES_MISSING_MANDATORY_FIELD");
            return Optional.of(errorInfo);
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkRuleToAdd(Map.Entry<String, RuleCategoryAction> entry, RuleAction ruleAction) {
        if (StringUtils.isEmpty((CharSequence)ruleAction.getRule())) {
            ObjectNode errorInfo = JsonHandler.createObjectNode();
            errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
            errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
            errorInfo.put(INFO, "New rule must at least define the field 'Rule' for category " + entry.getKey());
            errorInfo.put("Code", "UNIT_RULES_MISSING_MANDATORY_FIELD");
            return Optional.of(errorInfo);
        }
        return Optional.empty();
    }

    private Optional<JsonNode> checkEmptyRuleAction(Map.Entry<String, RuleCategoryAction> entry, RuleAction ruleAction) {
        if (this.isRuleActionEmpty(ruleAction)) {
            ObjectNode errorInfo = JsonHandler.createObjectNode();
            errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
            errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
            errorInfo.put(INFO, "Rule update should define at least 1 updated field for category " + entry.getKey());
            errorInfo.put("Code", "UNIT_RULES_NOT_EXPECTED_FIELD");
            return Optional.of(errorInfo);
        }
        return Optional.empty();
    }

    private boolean isRuleActionEmpty(RuleAction ruleAction) {
        return ruleAction.getRule() == null && ruleAction.getStartDate() == null && ruleAction.getHoldEndDate() == null && ruleAction.getHoldOwner() == null && ruleAction.getHoldReason() == null && ruleAction.getHoldReassessingDate() == null && ruleAction.getPreventRearrangement() == null && !Boolean.TRUE.equals(ruleAction.getDeleteStartDate()) && !Boolean.TRUE.equals(ruleAction.getDeleteHoldEndDate()) && !Boolean.TRUE.equals(ruleAction.getDeleteHoldOwner()) && !Boolean.TRUE.equals(ruleAction.getDeleteHoldReason()) && !Boolean.TRUE.equals(ruleAction.getDeleteHoldReassessingDate()) && !Boolean.TRUE.equals(ruleAction.getDeletePreventRearrangement());
    }

    private Optional<JsonNode> reportUnexpectedField(Map.Entry<String, RuleCategoryAction> entry, String fieldName) {
        ObjectNode errorInfo = JsonHandler.createObjectNode();
        errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
        errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
        errorInfo.put(INFO, "New rule must not define '" + fieldName + "' field for category " + entry.getKey());
        errorInfo.put("Code", "UNIT_RULES_UNEXPECTED_FIELD");
        return Optional.of(errorInfo);
    }

    private Optional<JsonNode> reportEmptyFieldFormat(Map.Entry<String, RuleCategoryAction> entry, String fieldName) {
        ObjectNode errorInfo = JsonHandler.createObjectNode();
        errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
        errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
        errorInfo.put(INFO, "Empty string for '" + fieldName + "' field for category " + entry.getKey());
        errorInfo.put("Code", "UNIT_RULES_EMPTY_FIELD");
        return Optional.of(errorInfo);
    }

    private Optional<JsonNode> reportSetAndDeleteOfSameField(Map.Entry<String, RuleCategoryAction> entry, String fieldName) {
        ObjectNode errorInfo = JsonHandler.createObjectNode();
        errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.name());
        errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_QUERY_CONSISTENCY.getMessage());
        errorInfo.put(INFO, "Cannot set '" + fieldName + "' + field value when 'Delete' is set for category " + entry.getKey());
        errorInfo.put("Code", "UNITS_RULES_INCONSISTENCY");
        return Optional.of(errorInfo);
    }

    private Optional<JsonNode> computeErrorsForCategory(Map.Entry<String, RuleCategoryAction> entry) {
        String classificationLevel;
        Optional<JsonNode> rulesIDErrors = this.computeOnlyRulesID(entry);
        if (rulesIDErrors.isPresent()) {
            return rulesIDErrors;
        }
        String categoryName = entry.getKey();
        RuleCategoryAction category = entry.getValue();
        if ("ClassificationRule".equals(categoryName) && (classificationLevel = category.getClassificationLevel()) != null && !ClassificationLevelUtil.checkClassificationLevel((String)classificationLevel)) {
            ObjectNode errorInfo = JsonHandler.createObjectNode();
            errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_PROPERTY_CONSISTENCY.name());
            errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_PROPERTY_CONSISTENCY.getMessage());
            errorInfo.put(INFO, classificationLevel + " is not a valid value for ClassificationLevel");
            errorInfo.put("Code", "CHECK_CLASSIFICATION_LEVEL");
            return Optional.of(errorInfo);
        }
        return Optional.empty();
    }

    private Optional<JsonNode> computeOnlyRulesID(Map.Entry<String, RuleCategoryAction> entry) {
        String categoryName = entry.getKey();
        RuleCategoryAction category = entry.getValue();
        HashSet<String> rulesToCheck = new HashSet<String>();
        if (!category.getRules().isEmpty()) {
            rulesToCheck.addAll(category.getRules().stream().map(RuleAction::getRule).filter(Objects::nonNull).collect(Collectors.toSet()));
            rulesToCheck.addAll(category.getRules().stream().map(RuleAction::getOldRule).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (category.getPreventRulesId() != null) {
            rulesToCheck.addAll(category.getPreventRulesId());
        }
        if (category.getPreventRulesIdToAdd() != null) {
            rulesToCheck.addAll(category.getPreventRulesIdToAdd());
        }
        return this.validateRuleIds(categoryName, rulesToCheck);
    }

    private Optional<JsonNode> validateRuleIds(String categoryName, Set<String> rulesToCheck) {
        for (String ruleID : rulesToCheck) {
            JsonNode ruleResponseInReferential;
            try {
                ruleResponseInReferential = this.adminManagementClientFactory.getClient().getRuleByID(ruleID);
            }
            catch (FileRulesException e) {
                ObjectNode errorInfo = JsonHandler.createObjectNode();
                errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_CONSISTENCY.name());
                errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_CONSISTENCY.getMessage());
                errorInfo.put(INFO, "Rule " + ruleID + " is not in database");
                errorInfo.put("Code", "UNITS_RULES_UNKNOWN");
                return Optional.of(errorInfo);
            }
            catch (InvalidParseOperationException | AdminManagementClientServerException e) {
                throw new IllegalStateException("Error while get the rule in Referential");
            }
            JsonNode ruleInReferential = ruleResponseInReferential.get("$results").get(0);
            if (categoryName.equals(ruleInReferential.get("RuleType").asText())) continue;
            ObjectNode errorInfo = JsonHandler.createObjectNode();
            errorInfo.put(ERROR, VitamCode.UPDATE_UNIT_RULES_CONSISTENCY.name());
            errorInfo.put(MESSAGE, VitamCode.UPDATE_UNIT_RULES_CONSISTENCY.getMessage());
            errorInfo.put(INFO, "Rule " + ruleID + " is not in category " + categoryName + " but " + ruleInReferential.get("RuleType").asText());
            errorInfo.put("Code", "UNITS_RULES_INCONSISTENCY");
            return Optional.of(errorInfo);
        }
        return Optional.empty();
    }

    private Optional<JsonNode> computeErrorsForDelete(Map.Entry<String, RuleCategoryActionDeletion> ruleCategoryActionDeletionEntry) {
        String categoryName = ruleCategoryActionDeletionEntry.getKey();
        RuleCategoryActionDeletion ruleCategoryActionDeletion = ruleCategoryActionDeletionEntry.getValue();
        if (ruleCategoryActionDeletion == null) {
            return Optional.empty();
        }
        if (ruleCategoryActionDeletion.getPreventRulesIdToRemove() != null) {
            return this.validateRuleIds(categoryName, ruleCategoryActionDeletion.getPreventRulesIdToRemove());
        }
        return Optional.empty();
    }
}

