/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.massprocessing;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.StreamSupport;

public class PrepareUpdateUnits
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);
    private static final String PREPARE_UPDATE_UNIT_LIST = "PREPARE_UPDATE_UNIT_LIST";
    private static final int DISTRIBUTION_FILE_RANK = 0;
    private final MetaDataClientFactory metaDataClientFactory;
    private final int batchSize;

    public PrepareUpdateUnits() {
        this(MetaDataClientFactory.getInstance(), 10000);
    }

    @VisibleForTesting
    PrepareUpdateUnits(MetaDataClientFactory metaDataClientFactory, int batchSize) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.batchSize = batchSize;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(PREPARE_UPDATE_UNIT_LIST);
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            JsonNode queryNode = handler.getJsonFromWorkspace("query.json");
            SelectMultiQuery multiQuery = this.getSelectQueryFromJson(queryNode);
            String distribFileName = handler.getOutput(0).getPath();
            File distribFile = handler.getNewLocalFile(distribFileName);
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(client, multiQuery, this.batchSize);
            this.createDistributionFile(scrollRequest, distribFile);
            handler.transferFileToWorkspace(distribFileName, distribFile, true, false);
            itemStatus.increment(StatusCode.OK);
        }
        catch (InvalidParseOperationException | ProcessingException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(PREPARE_UPDATE_UNIT_LIST).setItemsStatus(PREPARE_UPDATE_UNIT_LIST, itemStatus);
    }

    private void createDistributionFile(ScrollSpliterator<JsonNode> scrollRequest, File distribFile) throws ProcessingException {
        try (JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)new FileOutputStream(distribFile));){
            StreamSupport.stream(scrollRequest, false).forEach(item -> {
                try {
                    jsonLineWriter.addEntry(this.getJsonLineForItem((JsonNode)item));
                }
                catch (IOException e) {
                    throw new VitamRuntimeException((Throwable)e);
                }
            });
        }
        catch (VitamRuntimeException | IOException | IllegalStateException e) {
            throw new ProcessingException("Could not generate and save file", e);
        }
    }

    private JsonLineModel getJsonLineForItem(JsonNode item) {
        return new JsonLineModel(item.get("#id").textValue(), null, null);
    }

    private SelectMultiQuery getSelectQueryFromJson(JsonNode queryNode) throws InvalidParseOperationException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryNode);
        SelectMultiQuery multiQuery = parser.getRequest();
        multiQuery.setProjection(JsonHandler.getFromString((String)"{\"$fields\": { \"#id\": 1}}"));
        return multiQuery;
    }
}

