/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class StrategyIdOfferIdLoader {
    private final StorageClientFactory storageClientFactory;
    private final Map<String, List<String>> offerIdsByStrategyId = new HashMap<String, List<String>>();

    public StrategyIdOfferIdLoader(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public List<String> getOfferIds(String strategyId) throws ProcessingException {
        List list;
        block10: {
            if (this.offerIdsByStrategyId.containsKey(strategyId)) {
                return this.offerIdsByStrategyId.get(strategyId);
            }
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                List offers = storageClient.getOffers(strategyId);
                if (CollectionUtils.isEmpty((Collection)offers)) {
                    throw new IllegalStateException("No offers found for strategy " + strategyId);
                }
                this.offerIdsByStrategyId.put(strategyId, offers);
                list = offers;
                if (storageClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageNotFoundClientException | StorageServerClientException e) {
                    throw new ProcessingException("Could not load offer id list for strategy " + strategyId, e);
                }
            }
            storageClient.close();
        }
        return list;
    }
}

