/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.exception.VitamKoRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.PrepareLfcTraceabilityActionPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PrepareObjectGroupLfcTraceabilityActionPlugin
extends PrepareLfcTraceabilityActionPlugin {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PrepareObjectGroupLfcTraceabilityActionPlugin.class);
    private static final String ACTION_HANDLER_ID = "PREPARE_OG_LFC_TRACEABILITY";
    private static final String STP_OG_LFC_TRACEABILITY = "STP_OG_LFC_TRACEABILITY";

    public PrepareObjectGroupLfcTraceabilityActionPlugin() {
    }

    @VisibleForTesting
    PrepareObjectGroupLfcTraceabilityActionPlugin(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, int batchSize) {
        super(metaDataClientFactory, logbookLifeCyclesClientFactory, batchSize);
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) throws ProcessingException {
        String temporizationDelayInSecondsStr = (String)params.getMapParameters().get(WorkerParameterName.lifecycleTraceabilityTemporizationDelayInSeconds);
        String lifecycleTraceabilityMaxEntriesStr = (String)params.getMapParameters().get(WorkerParameterName.lifecycleTraceabilityMaxEntries);
        int temporizationDelayInSeconds = Integer.parseInt(temporizationDelayInSecondsStr);
        int lifecycleTraceabilityMaxEntries = Integer.parseInt(lifecycleTraceabilityMaxEntriesStr);
        ItemStatus itemStatus = new ItemStatus(ACTION_HANDLER_ID);
        try {
            this.selectAndExportLifecyclesWithMetadata(temporizationDelayInSeconds, lifecycleTraceabilityMaxEntries, Contexts.OBJECTGROUP_LFC_TRACEABILITY.getEventType(), handler);
            itemStatus.increment(StatusCode.OK);
        }
        catch (VitamFatalRuntimeException | LogbookClientException | ProcessingException e) {
            LOGGER.error("Logbook exception", e);
            itemStatus.increment(StatusCode.FATAL);
        }
        catch (InvalidParseOperationException | VitamKoRuntimeException e) {
            LOGGER.error("Processing exception", e);
            itemStatus.increment(StatusCode.KO);
        }
        return new ItemStatus(ACTION_HANDLER_ID).setItemsStatus(ACTION_HANDLER_ID, itemStatus);
    }

    @Override
    protected InputStream exportRawLifecyclesByLastPersistedDate(LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, LocalDateTime startDate, LocalDateTime endDate, int maxEntries) throws LogbookClientException, InvalidParseOperationException, IOException {
        try (LogbookLifeCyclesClient logbookLifeCyclesClient = logbookLifeCyclesClientFactory.getClient();){
            InputStream inputStream = logbookLifeCyclesClient.exportRawObjectGroupLifecyclesByLastPersistedDate(startDate, endDate, maxEntries);
            return inputStream;
        }
    }

    @Override
    protected Map<String, JsonNode> getRawMetadata(Set<String> ids, MetaDataClientFactory metaDataClientFactory) throws ProcessingException {
        Map<String, JsonNode> map;
        block9: {
            MetaDataClient metaDataClient = metaDataClientFactory.getClient();
            try {
                RequestResponse rawMetadataResponse = metaDataClient.getObjectGroupsByIdsRaw(ids);
                if (!rawMetadataResponse.isOk()) {
                    throw new ProcessingException("Could not retrieve raw metadata " + rawMetadataResponse.getStatus() + " " + ((VitamError)rawMetadataResponse).getDescription());
                }
                map = ((RequestResponseOK)rawMetadataResponse).getResults().stream().collect(Collectors.toMap(rawMetadata -> rawMetadata.get("_id").textValue(), rawMetadata -> rawMetadata));
                if (metaDataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    throw new ProcessingException("Could not retrieve raw metadata", (Throwable)e);
                }
            }
            metaDataClient.close();
        }
        return map;
    }

    @Override
    protected String stepName() {
        return STP_OG_LFC_TRACEABILITY;
    }

    @Override
    protected String actionName() {
        return ACTION_HANDLER_ID;
    }

    public static String getId() {
        return ACTION_HANDLER_ID;
    }
}

