/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.LfcMetadataPair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public abstract class PrepareLfcTraceabilityActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PrepareLfcTraceabilityActionPlugin.class);
    private static final int LAST_OPERATION_LIFECYCLES_OUT_RANK = 0;
    private static final int TRACEABILITY_INFORMATION_OUT_RANK = 1;
    private static final int LFC_AND_METADATA_OUT_RANK = 2;
    public static final TypeReference<JsonNode> JSON_NODE_TYPE_REFERENCE = new TypeReference<JsonNode>(){};
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final int batchSize;

    public PrepareLfcTraceabilityActionPlugin() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), VitamConfiguration.getBatchSize());
    }

    @VisibleForTesting
    PrepareLfcTraceabilityActionPlugin(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, int batchSize) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.batchSize = batchSize;
    }

    protected StatusCode selectAndExportLifecyclesWithMetadata(int temporizationDelayInSeconds, int lifecycleTraceabilityMaxEntries, String eventType, HandlerIO handlerIO) throws ProcessingException, InvalidParseOperationException, LogbookClientException {
        boolean maxEntriesReached;
        LogbookOperation lastTraceabilityOperation = this.findLastLfcTraceabilityOperationWithZip(eventType);
        this.exportLastOperationTraceabilityLifecycle(handlerIO, lastTraceabilityOperation);
        LocalDateTime traceabilityStartDate = this.getTraceabilityOperationStartDate(lastTraceabilityOperation);
        LocalDateTime traceabilityEndDate = LocalDateUtil.now().minusSeconds(temporizationDelayInSeconds);
        int nbExportedEntries = 0;
        LocalDateTime maxEntryLastPersistedDate = traceabilityStartDate;
        File lfcWithMetadataFile = handlerIO.getNewLocalFile(handlerIO.getOutput(2).getPath());
        try (InputStream is = this.exportRawLifecyclesByLastPersistedDate(this.logbookLifeCyclesClientFactory, traceabilityStartDate, traceabilityEndDate, lifecycleTraceabilityMaxEntries);
             JsonLineGenericIterator rawLifecycleIterator = new JsonLineGenericIterator(is, JSON_NODE_TYPE_REFERENCE);
             FileOutputStream os = new FileOutputStream(lfcWithMetadataFile);
             JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)os);){
            UnmodifiableIterator bulkRawLifecycleIterator = Iterators.partition((Iterator)rawLifecycleIterator, (int)this.batchSize);
            while (bulkRawLifecycleIterator.hasNext()) {
                List rawLifecycleToProceed = (List)bulkRawLifecycleIterator.next();
                Set<String> currentBatchIds = rawLifecycleToProceed.stream().map(item -> item.get("_id").textValue()).collect(Collectors.toSet());
                for (JsonNode item2 : rawLifecycleToProceed) {
                    ++nbExportedEntries;
                    String entryLastPersistedDateStr = item2.get("_lastPersistedDate").asText();
                    LocalDateTime entryLastPersistedDate = LocalDateUtil.parseMongoFormattedDate((String)entryLastPersistedDateStr);
                    if (!entryLastPersistedDate.isAfter(maxEntryLastPersistedDate)) continue;
                    maxEntryLastPersistedDate = entryLastPersistedDate;
                }
                Stopwatch loadTraceabilityMetadata = Stopwatch.createStarted();
                Map<String, JsonNode> rawMetadataByIds = this.getRawMetadata(currentBatchIds, this.metaDataClientFactory);
                PerformanceLogger.getInstance().log(this.stepName(), this.actionName(), "LOAD_TRACEABILITY_METADATA", loadTraceabilityMetadata.elapsed(TimeUnit.MILLISECONDS));
                for (JsonNode rawLfc : rawLifecycleToProceed) {
                    String id = rawLfc.get("_id").textValue();
                    JsonNode rawMetadata = rawMetadataByIds.get(id);
                    if (rawMetadata == null) {
                        throw new ProcessingException("Metadata not found for id " + id);
                    }
                    LfcMetadataPair lfcMetadataPair = new LfcMetadataPair(rawMetadata, rawLfc);
                    jsonLineWriter.addEntry((Object)lfcMetadataPair);
                }
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Could not export lfc and metadata for traceability", (Throwable)e);
        }
        handlerIO.addOutputResult(2, (Object)lfcWithMetadataFile, false, false);
        boolean bl = maxEntriesReached = nbExportedEntries >= lifecycleTraceabilityMaxEntries;
        if (maxEntriesReached) {
            traceabilityEndDate = maxEntryLastPersistedDate;
        }
        this.exportTraceabilityInformation(handlerIO, traceabilityStartDate, traceabilityEndDate, nbExportedEntries, maxEntriesReached);
        LOGGER.info("Metadata traceability entries: " + nbExportedEntries);
        return nbExportedEntries > 0 ? StatusCode.OK : StatusCode.WARNING;
    }

    private LocalDateTime getTraceabilityOperationStartDate(LogbookOperation lastTraceabilityOperation) throws InvalidParseOperationException {
        if (lastTraceabilityOperation == null) {
            return LogbookTraceabilityHelper.INITIAL_START_DATE;
        }
        String evDetData = lastTraceabilityOperation.getEvDetData();
        TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromString((String)evDetData, TraceabilityEvent.class);
        return LocalDateUtil.parseMongoFormattedDate((String)traceabilityEvent.getEndDate());
    }

    private LogbookOperation findLastLfcTraceabilityOperationWithZip(String eventType) throws ProcessingException {
        LogbookOperation logbookOperation;
        block8: {
            LogbookLifeCyclesClient client = this.logbookLifeCyclesClientFactory.getClient();
            try {
                logbookOperation = client.findLastLifecycleTraceabilityOperation(eventType);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientException e) {
                    throw new ProcessingException("Cannot load last lfc traceability operation", (Throwable)e);
                }
            }
            client.close();
        }
        return logbookOperation;
    }

    private void exportLastOperationTraceabilityLifecycle(HandlerIO handlerIO, LogbookOperation lastTraceabilityOperation) throws InvalidParseOperationException, ProcessingException {
        File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(0).getPath());
        if (lastTraceabilityOperation == null) {
            JsonHandler.writeAsFile((Object)JsonHandler.createObjectNode(), (File)tempFile);
        } else {
            JsonHandler.writeAsFile((Object)lastTraceabilityOperation, (File)tempFile);
        }
        handlerIO.addOutputResult(0, (Object)tempFile, false, false);
    }

    private void exportTraceabilityInformation(HandlerIO handlerIO, LocalDateTime traceabilityStartDate, LocalDateTime traceabilityEndDate, long nbEntries, boolean maxEntriesReached) throws InvalidParseOperationException, ProcessingException {
        ObjectNode traceabilityInformation = JsonHandler.createObjectNode();
        traceabilityInformation.put("startDate", LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityStartDate));
        traceabilityInformation.put("endDate", LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityEndDate));
        traceabilityInformation.put("nbEntries", nbEntries);
        traceabilityInformation.put("maxEntriesReached", maxEntriesReached);
        File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(1).getPath());
        JsonHandler.writeAsFile((Object)traceabilityInformation, (File)tempFile);
        handlerIO.addOutputResult(1, (Object)tempFile, false, false);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    protected abstract InputStream exportRawLifecyclesByLastPersistedDate(LogbookLifeCyclesClientFactory var1, LocalDateTime var2, LocalDateTime var3, int var4) throws LogbookClientException, InvalidParseOperationException, IOException;

    protected abstract Map<String, JsonNode> getRawMetadata(Set<String> var1, MetaDataClientFactory var2) throws ProcessingException;

    protected abstract String stepName();

    protected abstract String actionName();
}

