/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.ExistsQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.TraceabilityFile;
import fr.gouv.vitam.logbook.common.model.TraceabilityType;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.LogbookLifeCycleTraceabilityHelper;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.IOException;
import java.time.LocalDateTime;

public class LogbookUnitLifeCycleTraceabilityHelper
extends LogbookLifeCycleTraceabilityHelper {
    private static final String ZIP_NAME = "LogbookUnitLifecycles";
    private final CloseableIterator<JsonNode> traceabilityDataIterator;

    public LogbookUnitLifeCycleTraceabilityHelper(HandlerIO handlerIO, LogbookOperationsClient logbookOperationsClient, ItemStatus itemStatus, String operationID, WorkspaceClientFactory workspaceClientFactory, CloseableIterator<JsonNode> traceabilityDataIterator, String traceabilityEventFileName, String traceabilityZipFileName) {
        super(handlerIO, logbookOperationsClient, itemStatus, operationID, traceabilityEventFileName, traceabilityZipFileName);
        this.traceabilityDataIterator = traceabilityDataIterator;
    }

    public void saveDataInZip(MerkleTreeAlgo algo, TraceabilityFile file) throws IOException, TraceabilityException {
        file.initStoreLog();
        try {
            this.extractAppendToFinalFile(this.traceabilityDataIterator, file, algo);
        }
        finally {
            file.closeStoreLog();
        }
    }

    public String getZipName() {
        return ZIP_NAME;
    }

    public TraceabilityType getTraceabilityType() {
        return TraceabilityType.UNIT_LIFECYCLE;
    }

    @Override
    protected Select generateSelectLogbookOperation(LocalDateTime date) throws InvalidCreateOperationException {
        Select select = new Select();
        CompareQuery query = QueryHelper.gt((String)LogbookLifeCycleMongoDbName.eventDateTime.getDbname(), (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)date));
        CompareQuery type = QueryHelper.eq((String)LogbookLifeCycleMongoDbName.eventTypeProcess.getDbname(), (String)LogbookTypeProcess.TRACEABILITY.name());
        InQuery eventStatus = QueryHelper.in((String)String.format("%s.%s", "events", LogbookMongoDbName.outcomeDetail.getDbname()), (String[])new String[]{Contexts.UNIT_LFC_TRACEABILITY.getEventType() + ".OK", Contexts.UNIT_LFC_TRACEABILITY.getEventType() + ".WARNING"});
        ExistsQuery hasTraceabilityFile = QueryHelper.exists((String)String.format("%s.%s.%s", "events", LogbookMongoDbName.eventDetailData.getDbname(), "FileName"));
        select.setQuery((Query)QueryHelper.and().add(new Query[]{query, type, eventStatus, hasTraceabilityFile}));
        select.setLimitFilter(0L, 1L);
        return select;
    }
}

