/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.model.TraceabilityFile;
import fr.gouv.vitam.logbook.common.model.TraceabilityStatistics;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.io.FileUtils;

public abstract class LogbookLifeCycleTraceabilityHelper
implements LogbookTraceabilityHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookLifeCycleTraceabilityHelper.class);
    private static final String EVENT_ID = LogbookMongoDbName.eventIdentifier.getDbname();
    private static final String EVENT_DETAIL_DATA = LogbookMongoDbName.eventDetailData.getDbname();
    private static final String HANDLER_ID = "FINALIZE_LC_TRACEABILITY";
    private static final String HANDLER_SUB_ACTION_TIMESTAMP = "OP_SECURISATION_TIMESTAMP";
    private static final String HANDLER_SUB_ACTION_SECURISATION_STORAGE_ON_WORKSPACE = "OP_SECURISATION_STORAGE_ON_WORKSPACE";
    private static final int LAST_OPERATION_LIFECYCLES_RANK = 0;
    private static final int TRACEABILITY_INFORMATION_RANK = 1;
    private static final int TRACEABILITY_STATISTICS_RANK = 3;
    private final HandlerIO handlerIO;
    private final LogbookOperationsClient logbookOperationsClient;
    private final ItemStatus itemStatus;
    private final String operationID;
    private final String traceabilityEventFileName;
    private final String traceabilityZipFileName;
    private LogbookOperation lastTraceabilityOperation = null;
    private List<String> expectedLogbookId = null;
    private JsonNode traceabilityInformation = null;
    private TraceabilityStatistics traceabilityStatistics;
    private LocalDateTime traceabilityStartDate;
    private LocalDateTime traceabilityEndDate;
    private Boolean isLastEventInit = false;
    private Boolean isLastMonthEventInit = false;
    private Boolean isLastYearEventInit = false;
    private String previousStartDate = null;
    private String previousMonthStartDate = null;
    private String previousYearStartDate = null;
    private byte[] previousTimestampToken = null;
    private byte[] previousMonthTimestampToken = null;
    private byte[] previousYearTimestampToken = null;
    private boolean maxEntriesReached;

    public LogbookLifeCycleTraceabilityHelper(HandlerIO handlerIO, LogbookOperationsClient logbookOperationsClient, ItemStatus itemStatus, String operationID, String traceabilityEventFileName, String traceabilityZipFileName) {
        this.handlerIO = handlerIO;
        this.logbookOperationsClient = logbookOperationsClient;
        this.itemStatus = itemStatus;
        this.operationID = operationID;
        this.traceabilityEventFileName = traceabilityEventFileName;
        this.traceabilityZipFileName = traceabilityZipFileName;
    }

    public void startTraceability() throws TraceabilityException {
        try {
            File traceabilityInformationFile;
            File operationFile = (File)this.handlerIO.getInput(0);
            JsonNode operationJson = null;
            if (operationFile != null) {
                operationJson = JsonHandler.getFromFile((File)operationFile);
            }
            if (operationJson != null && operationJson.isObject() && operationJson.get("evId") != null) {
                this.lastTraceabilityOperation = new LogbookOperation(operationJson);
            }
            if ((traceabilityInformationFile = (File)this.handlerIO.getInput(1)) != null) {
                this.traceabilityInformation = JsonHandler.getFromFile((File)traceabilityInformationFile);
            }
            File statsFile = (File)this.handlerIO.getInput(3);
            if (operationFile != null) {
                this.traceabilityStatistics = (TraceabilityStatistics)JsonHandler.getFromFile((File)statsFile, TraceabilityStatistics.class);
            }
        }
        catch (InvalidParseOperationException e) {
            throw new TraceabilityException("Cannot parse logbook operation", (Throwable)e);
        }
        this.expectedLogbookId = Lists.newArrayList((Object[])new String[]{this.operationID});
        if (this.lastTraceabilityOperation != null) {
            this.expectedLogbookId.add(this.lastTraceabilityOperation.getString((Object)EVENT_ID));
        }
        this.traceabilityStartDate = LocalDateUtil.parseMongoFormattedDate((String)this.traceabilityInformation.get("startDate").asText());
        this.traceabilityEndDate = LocalDateUtil.parseMongoFormattedDate((String)this.traceabilityInformation.get("endDate").asText());
        this.maxEntriesReached = this.traceabilityInformation.get("maxEntriesReached").asBoolean();
    }

    public void createLogbookOperationEvent(Integer tenantId, String eventType, StatusCode status, TraceabilityEvent event) throws TraceabilityException {
        if (!this.getStepName().equals(eventType)) {
            ItemStatus subItemStatusTimestamp = new ItemStatus(eventType);
            this.itemStatus.setItemsStatus(eventType, subItemStatusTimestamp.increment(status));
        }
    }

    public void saveEmpty(Integer tenantId) {
    }

    public boolean getMaxEntriesReached() {
        return this.maxEntriesReached;
    }

    public TraceabilityStatistics getTraceabilityStatistics() {
        return this.traceabilityStatistics;
    }

    public void storeAndDeleteZip(Integer tenant, String strategyId, File zipFile, String fileName, TraceabilityEvent event) throws TraceabilityException {
        ItemStatus subItemStatusSecurisationStorage = new ItemStatus(HANDLER_SUB_ACTION_SECURISATION_STORAGE_ON_WORKSPACE);
        try {
            this.handlerIO.transferFileToWorkspace(this.traceabilityZipFileName, zipFile, true, false);
            this.handlerIO.transferInputStreamToWorkspace(this.traceabilityEventFileName, JsonHandler.writeToInpustream((Object)event), null, false);
        }
        catch (InvalidParseOperationException | ProcessingException e) {
            this.itemStatus.setItemsStatus(HANDLER_SUB_ACTION_SECURISATION_STORAGE_ON_WORKSPACE, subItemStatusSecurisationStorage.increment(StatusCode.FATAL));
            throw new TraceabilityException("unable to create container", e);
        }
        finally {
            FileUtils.deleteQuietly((File)zipFile);
        }
    }

    public String getStepName() {
        return HANDLER_ID;
    }

    public String getTimestampStepName() {
        return HANDLER_SUB_ACTION_TIMESTAMP;
    }

    public String getTraceabilityStartDate() {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityStartDate);
    }

    public String getTraceabilityEndDate() {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityEndDate);
    }

    public long getDataSize() {
        return this.traceabilityInformation.get("nbEntries").asLong();
    }

    public byte[] getPreviousTimestampToken() throws InvalidParseOperationException {
        if (!this.isLastEventInit.booleanValue()) {
            this.extractPreviousEvent();
        }
        return this.previousTimestampToken;
    }

    public byte[] getPreviousMonthTimestampToken() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastMonthEventInit.booleanValue()) {
            this.extractPreviousEvent(this.traceabilityEndDate.minusMonths(1L), true);
        }
        return this.previousMonthTimestampToken;
    }

    public byte[] getPreviousYearTimestampToken() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastYearEventInit.booleanValue()) {
            this.extractPreviousEvent(this.traceabilityEndDate.minusYears(1L), false);
        }
        return this.previousYearTimestampToken;
    }

    public String getPreviousStartDate() throws InvalidParseOperationException {
        if (!this.isLastEventInit.booleanValue()) {
            this.extractPreviousEvent();
        }
        return this.previousStartDate;
    }

    public String getPreviousMonthStartDate() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastMonthEventInit.booleanValue()) {
            this.extractPreviousEvent(this.traceabilityEndDate.minusMonths(1L), true);
        }
        return this.previousMonthStartDate;
    }

    public String getPreviousYearStartDate() throws InvalidParseOperationException, TraceabilityException {
        if (!this.isLastYearEventInit.booleanValue()) {
            this.extractPreviousEvent(this.traceabilityEndDate.minusYears(1L), false);
        }
        return this.previousYearStartDate;
    }

    protected void extractAppendToFinalFile(CloseableIterator<JsonNode> jsonLineIterator, TraceabilityFile traceabilityFile, MerkleTreeAlgo algo) throws TraceabilityException {
        try {
            while (jsonLineIterator.hasNext()) {
                JsonNode entry = (JsonNode)jsonLineIterator.next();
                byte[] bytes = CanonicalJsonFormatter.serializeToByteArray((JsonNode)entry);
                traceabilityFile.storeLog(bytes);
                algo.addLeaf(bytes);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while storing files in ZIP");
            throw new TraceabilityException("Error while storing files in ZIP", (Throwable)e);
        }
    }

    private void extractPreviousEvent() throws InvalidParseOperationException {
        TraceabilityEvent lastTraceabilityEvent;
        this.previousTimestampToken = this.extractTimestampToken(this.lastTraceabilityOperation);
        if (this.lastTraceabilityOperation != null && (lastTraceabilityEvent = this.extractEventDetData(this.lastTraceabilityOperation)) != null) {
            this.previousStartDate = lastTraceabilityEvent.getStartDate();
        }
        this.isLastEventInit = true;
    }

    private void extractPreviousEvent(LocalDateTime specificDate, Boolean isMonth) throws InvalidParseOperationException, TraceabilityException {
        try {
            TraceabilityEvent oneMonthBeforeTraceabilityEvent;
            this.previousMonthTimestampToken = this.findHashByTraceabilityEventExpect(specificDate);
            LogbookOperation oneMounthBeforeTraceabilityOperation = this.findFirstTraceabilityOperationOKAfterDate(specificDate);
            if (oneMounthBeforeTraceabilityOperation != null && (oneMonthBeforeTraceabilityEvent = this.extractEventDetData(oneMounthBeforeTraceabilityOperation)) != null) {
                this.previousMonthStartDate = oneMonthBeforeTraceabilityEvent.getStartDate();
            }
        }
        catch (InvalidCreateOperationException | LogbookClientException e) {
            throw new TraceabilityException(e);
        }
        if (isMonth.booleanValue()) {
            this.isLastMonthEventInit = true;
        } else {
            this.isLastYearEventInit = true;
        }
    }

    byte[] extractTimestampToken(LogbookOperation logbookOperation) throws InvalidParseOperationException {
        TraceabilityEvent traceabilityEvent = this.extractEventDetData(logbookOperation);
        if (traceabilityEvent == null) {
            return null;
        }
        return traceabilityEvent.getTimeStampToken();
    }

    private TraceabilityEvent extractEventDetData(LogbookOperation logbookOperation) throws InvalidParseOperationException {
        if (logbookOperation == null) {
            return null;
        }
        return (TraceabilityEvent)JsonHandler.getFromString((String)((String)logbookOperation.get((Object)EVENT_DETAIL_DATA)), TraceabilityEvent.class);
    }

    private byte[] findHashByTraceabilityEventExpect(LocalDateTime date) throws InvalidCreateOperationException, InvalidParseOperationException, LogbookClientException {
        LogbookOperation lastOperationTraceabilityLifecycle;
        RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)this.logbookOperationsClient.selectOperation((JsonNode)this.generateSelectLogbookOperation(date).getFinalSelect()));
        List foundOperation = requestResponseOK.getResults();
        if (foundOperation != null && !foundOperation.isEmpty() && !this.expectedLogbookId.contains((lastOperationTraceabilityLifecycle = new LogbookOperation((JsonNode)foundOperation.get(0))).getString((Object)EVENT_ID))) {
            this.expectedLogbookId.add(lastOperationTraceabilityLifecycle.getString((Object)EVENT_ID));
            return this.extractTimestampToken(lastOperationTraceabilityLifecycle);
        }
        LOGGER.warn("Logbook operation not found, there is no Operation");
        return null;
    }

    private LogbookOperation findFirstTraceabilityOperationOKAfterDate(LocalDateTime date) throws InvalidCreateOperationException, InvalidParseOperationException, LogbookClientException {
        RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)this.logbookOperationsClient.selectOperation((JsonNode)this.generateSelectLogbookOperation(date).getFinalSelect()));
        List foundOperation = requestResponseOK.getResults();
        if (foundOperation != null && foundOperation.size() == 1) {
            return new LogbookOperation((JsonNode)foundOperation.get(0));
        }
        LOGGER.warn("Logbook operation not found, there is no Operation");
        return null;
    }

    protected abstract Select generateSelectLogbookOperation(LocalDateTime var1) throws InvalidCreateOperationException;
}

