/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.GenerateLifecycleTraceabilityActionPlugin;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.LogbookUnitLifeCycleTraceabilityHelper;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GenerateUnitLifecycleTraceabilityActionPlugin
extends GenerateLifecycleTraceabilityActionPlugin {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(GenerateUnitLifecycleTraceabilityActionPlugin.class);
    private static final TypeReference<JsonNode> TYPE_REFERENCE = new TypeReference<JsonNode>(){};
    private static final String ACTION_HANDLER_ID = "GENERATE_UNIT_LFC_TRACEABILITY";
    private static final int TRACEABILITY_DATA_IN_RANK = 2;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;

    public GenerateUnitLifecycleTraceabilityActionPlugin() {
        this(LogbookOperationsClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM));
    }

    @VisibleForTesting
    GenerateUnitLifecycleTraceabilityActionPlugin(LogbookOperationsClientFactory logbookOperationsClientFactory, WorkspaceClientFactory workspaceClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(ACTION_HANDLER_ID);
        File traceabilityDataFile = (File)handler.getInput(2);
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
             FileInputStream is = new FileInputStream(traceabilityDataFile);
             JsonLineGenericIterator traceabilityDataIterator = new JsonLineGenericIterator((InputStream)is, TYPE_REFERENCE);){
            LogbookUnitLifeCycleTraceabilityHelper helper = new LogbookUnitLifeCycleTraceabilityHelper(handler, logbookOperationsClient, itemStatus, params.getContainerName(), this.workspaceClientFactory, (CloseableIterator<JsonNode>)traceabilityDataIterator, "traceabilityEvent.json", "traceabilityFile.zip");
            this.generateLifecycleTraceabilityFile(helper);
            itemStatus.increment(StatusCode.OK);
        }
        catch (TraceabilityException | IOException e) {
            LOGGER.error("Exception while finalizing", e);
            itemStatus.increment(StatusCode.FATAL);
        }
        LOGGER.info("Unit lifecycle traceability finished with status " + itemStatus.getGlobalStatus());
        return new ItemStatus(ACTION_HANDLER_ID).setItemsStatus(ACTION_HANDLER_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return ACTION_HANDLER_ID;
    }
}

