/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.timestamp.TimeStampSignature;
import fr.gouv.vitam.common.timestamp.TimeStampSignatureWithKeystore;
import fr.gouv.vitam.common.timestamp.TimestampGenerator;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.common.traceability.TraceabilityService;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.VerifyTimeStampActionConfiguration;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public abstract class GenerateLifecycleTraceabilityActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(GenerateLifecycleTraceabilityActionPlugin.class);
    private final TimestampGenerator timestampGenerator;
    private static final String VERIFY_TIMESTAMP_CONF_FILE = "verify-timestamp.conf";
    public static final String TRACEABILITY_ZIP_FILE_NAME = "traceabilityFile.zip";
    public static final String TRACEABILITY_EVENT_FILE_NAME = "traceabilityEvent.json";

    public GenerateLifecycleTraceabilityActionPlugin() {
        TimeStampSignatureWithKeystore timeStampSignature;
        VerifyTimeStampActionConfiguration configuration = null;
        try {
            configuration = (VerifyTimeStampActionConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)VERIFY_TIMESTAMP_CONF_FILE), VerifyTimeStampActionConfiguration.class);
        }
        catch (IOException e) {
            LOGGER.error("Processing exception", (Throwable)e);
        }
        if (configuration != null) {
            try {
                File file = PropertiesUtils.findFile((String)configuration.getP12LogbookFile());
                timeStampSignature = new TimeStampSignatureWithKeystore(file, configuration.getP12LogbookPassword().toCharArray());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                LOGGER.error("unable to instantiate TimeStampGenerator", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            LOGGER.error("unable to instantiate TimeStampGenerator");
            throw new RuntimeException("Configuration is null");
        }
        this.timestampGenerator = new TimestampGenerator((TimeStampSignature)timeStampSignature);
    }

    protected void generateLifecycleTraceabilityFile(LogbookTraceabilityHelper helper) throws TraceabilityException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        File tmpFolder = PropertiesUtils.fileFromTmpFolder((String)"secure");
        TraceabilityService traceabilityService = new TraceabilityService(this.timestampGenerator, helper, tenantId, tmpFolder);
        traceabilityService.secureData(VitamConfiguration.getDefaultStrategy());
    }
}

