/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import java.io.File;
import java.io.IOException;

public abstract class FinalizeLifecycleTraceabilityActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FinalizeLifecycleTraceabilityActionPlugin.class);
    public static final String TRACEABILITY_ZIP_FILE_NAME = "traceabilityFile.zip";
    public static final String TRACEABILITY_EVENT_FILE_NAME = "traceabilityEvent.json";
    private final String actionHandlerId;
    private final StorageClientFactory storageClientFactory;

    protected FinalizeLifecycleTraceabilityActionPlugin(StorageClientFactory storageClientFactory, String actionHandlerId) {
        this.storageClientFactory = storageClientFactory;
        this.actionHandlerId = actionHandlerId;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(this.actionHandlerId);
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            ItemStatus itemStatus2;
            block18: {
                WorkspaceClient workspaceClient;
                block16: {
                    ItemStatus itemStatus3;
                    block17: {
                        workspaceClient = handler.getWorkspaceClientFactory().getClient();
                        try {
                            if (workspaceClient.isExistingObject(handler.getContainerName(), TRACEABILITY_EVENT_FILE_NAME)) break block16;
                            LOGGER.warn("No traceability event file found. Empty traceability zip.");
                            itemStatus.increment(StatusCode.OK);
                            LOGGER.info("Lifecycle traceability finished with status " + itemStatus.getGlobalStatus());
                            itemStatus3 = new ItemStatus(this.actionHandlerId).setItemsStatus(this.actionHandlerId, itemStatus);
                            if (workspaceClient == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (workspaceClient != null) {
                                try {
                                    workspaceClient.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        workspaceClient.close();
                    }
                    return itemStatus3;
                }
                File traceabilityEventFile = handler.getFileFromWorkspace(TRACEABILITY_EVENT_FILE_NAME);
                TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromFile((File)traceabilityEventFile, TraceabilityEvent.class);
                String evDetailData = JsonHandler.unprettyPrint((Object)traceabilityEvent);
                itemStatus.setEvDetailData(evDetailData);
                itemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)evDetailData);
                ObjectDescription description = new ObjectDescription();
                description.setWorkspaceContainerGUID(handler.getContainerName());
                description.setWorkspaceObjectURI(TRACEABILITY_ZIP_FILE_NAME);
                storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.LOGBOOK, traceabilityEvent.getFileName(), description);
                itemStatus.increment(StatusCode.OK);
                LOGGER.info("Lifecycle traceability finished with status " + itemStatus.getGlobalStatus());
                itemStatus2 = new ItemStatus(this.actionHandlerId).setItemsStatus(this.actionHandlerId, itemStatus);
                if (workspaceClient == null) break block18;
                workspaceClient.close();
            }
            return itemStatus2;
        }
        catch (InvalidParseOperationException | StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error("Exception while finalizing", e);
            itemStatus.increment(StatusCode.FATAL);
            LOGGER.info("Lifecycle traceability finished with status " + itemStatus.getGlobalStatus());
            return new ItemStatus(this.actionHandlerId).setItemsStatus(this.actionHandlerId, itemStatus);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

