/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.common.model.EntryTraceabilityStatistics;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.DigestValidationDetails;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DigestValidator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DigestValidator.class);
    public static final String INVALID_HASH = "INVALID_HASH";
    private final AlertService alertService;
    private int nbMetadataOK = 0;
    private int nbMetadataWarnings = 0;
    private int nbMetadataErrors = 0;
    private int nbObjectOK = 0;
    private int nbObjectWarnings = 0;
    private int nbObjectErrors = 0;

    public DigestValidator(AlertService alertService) {
        this.alertService = alertService;
    }

    public DigestValidationDetails validateMetadataDigest(String id, String strategyId, String digestInDb, Map<String, String> digestByOfferId) {
        DigestValidationDetails digestValidationDetails = this.validateDigest(id, strategyId, digestInDb, digestByOfferId, this.alertService, "metadata");
        if (digestValidationDetails.hasInconsistencies()) {
            ++this.nbMetadataWarnings;
        } else {
            ++this.nbMetadataOK;
        }
        return digestValidationDetails;
    }

    public DigestValidationDetails validateObjectDigest(String id, String strategyId, String digestInDb, Map<String, String> digestByOfferId) {
        DigestValidationDetails digestValidationDetails = this.validateDigest(id, strategyId, digestInDb, digestByOfferId, this.alertService, "binary object");
        if (digestValidationDetails.hasInconsistencies()) {
            ++this.nbObjectWarnings;
        } else {
            ++this.nbObjectOK;
        }
        return digestValidationDetails;
    }

    private DigestValidationDetails validateDigest(String id, String strategyId, String digestInDb, Map<String, String> digestByOfferId, AlertService alertService, String objectType) {
        Map<String, String> offersWithInconsistentDigest;
        List offersWithoutDigest = digestByOfferId.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!offersWithoutDigest.isEmpty()) {
            alertService.createAlert(VitamLogLevel.WARN, String.format("Missing digest for %s with id=%s in offers %s. Digest in db : %s", objectType, id, String.join((CharSequence)", ", offersWithoutDigest), digestInDb));
        }
        if (!(offersWithInconsistentDigest = digestByOfferId.entrySet().stream().filter(entry -> entry.getValue() != null && !digestInDb.equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            alertService.createAlert(VitamLogLevel.ERROR, String.format("Digest mismatch for %s (%s). %s. Digest in db : %s", objectType, id, offersWithInconsistentDigest.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(", ", "{", "}")), digestInDb));
        }
        Predicate<String> notEqual = x -> !digestInDb.equals(x);
        boolean atLeastOneOfferKO = digestByOfferId.values().stream().anyMatch(notEqual);
        boolean allOffersKO = digestByOfferId.values().stream().allMatch(notEqual);
        String globalDigest = atLeastOneOfferKO ? INVALID_HASH : digestInDb;
        Set<String> offerIds = digestByOfferId.keySet();
        return new DigestValidationDetails(strategyId, offerIds, globalDigest, digestInDb, digestByOfferId, atLeastOneOfferKO, allOffersKO);
    }

    public EntryTraceabilityStatistics getMetadataValidationStatistics() {
        return new EntryTraceabilityStatistics(this.nbMetadataOK, this.nbMetadataWarnings, this.nbMetadataErrors);
    }

    public EntryTraceabilityStatistics getObjectValidationStatistics() {
        return new EntryTraceabilityStatistics(this.nbObjectOK, this.nbObjectWarnings, this.nbObjectErrors);
    }

    public boolean hasInconsistencies() {
        return this.nbMetadataErrors + this.nbMetadataWarnings + this.nbObjectErrors + this.nbObjectWarnings > 0;
    }
}

