/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleTraceabilitySecureFileObject;
import fr.gouv.vitam.common.model.MetadataStorageHelper;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.ObjectGroupDocumentHash;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.TraceabilityHashDetails;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.logbook.common.model.TraceabilityStatistics;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroup;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnit;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.response.BatchObjectInformationResponse;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.DigestValidationDetails;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.DigestValidator;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.LfcMetadataPair;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.StrategyIdOfferIdLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.io.output.NullOutputStream;

public abstract class BuildTraceabilityActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BuildTraceabilityActionPlugin.class);
    private static final int LFC_AND_METADATA_IN_RANK = 0;
    private static final int TRACEABILITY_DATA_OUT_RANK = 0;
    private static final int TRACEABILITY_STATISTICS_OUT_RANK = 1;
    private static final String JSON_EXTENSION = ".json";
    private static final String MESSAGE_DIGEST = "MessageDigest";
    private static final String STRATEGY_ID_FIELD = "strategyId";
    private static final String STORAGE_FIELD = "_storage";
    public static final TypeReference<LfcMetadataPair> TYPE_REFERENCE = new TypeReference<LfcMetadataPair>(){};
    private final DigestType digestType = VitamConfiguration.getDefaultDigestType();
    private final StorageClientFactory storageClientFactory;
    private final int batchSize;
    private final AlertService alertService;

    public BuildTraceabilityActionPlugin() {
        this(StorageClientFactory.getInstance(), VitamConfiguration.getBatchSize(), (AlertService)new AlertServiceImpl());
    }

    @VisibleForTesting
    BuildTraceabilityActionPlugin(StorageClientFactory storageClientFactory, int batchSize, AlertService alertService) {
        this.storageClientFactory = storageClientFactory;
        this.batchSize = batchSize;
        this.alertService = alertService;
    }

    protected void buildTraceabilityData(HandlerIO handler, String lifecycleType, ItemStatus itemStatus) throws ProcessingException {
        File lfcAndMetadataFile = (File)handler.getInput(0);
        File traceabilityDataFile = handler.getNewLocalFile(handler.getOutput(0).getPath());
        DigestValidator digestValidator = new DigestValidator(this.alertService);
        StrategyIdOfferIdLoader strategyIdOfferIdLoader = new StrategyIdOfferIdLoader(this.storageClientFactory);
        int nbEntries = 0;
        try (FileInputStream is = new FileInputStream(lfcAndMetadataFile);
             JsonLineGenericIterator lfcMetadataIterator = new JsonLineGenericIterator((InputStream)is, TYPE_REFERENCE);
             FileOutputStream os = new FileOutputStream(traceabilityDataFile);
             JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)os);){
            UnmodifiableIterator bulkIterator = Iterators.partition((Iterator)lfcMetadataIterator, (int)this.batchSize);
            while (bulkIterator.hasNext()) {
                List lfcMetadataPairList = (List)bulkIterator.next();
                nbEntries += lfcMetadataPairList.size();
                this.processBulk(lfcMetadataPairList, jsonLineWriter, lifecycleType, digestValidator, strategyIdOfferIdLoader);
            }
        }
        catch (ProcessingStatusException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(e.getStatusCode());
            String evDetailData = JsonHandler.unprettyPrint((Object)e.getEventDetails());
            itemStatus.setEvDetailData(evDetailData);
            return;
        }
        catch (IOException e) {
            throw new ProcessingException("Could not load storage information", (Throwable)e);
        }
        handler.addOutputResult(0, (Object)traceabilityDataFile, false, false);
        TraceabilityStatistics traceabilityStatistics = this.getTraceabilityStatistics(digestValidator);
        try {
            File traceabilityStatsFile = handler.getNewLocalFile(handler.getOutput(1).getPath());
            JsonHandler.writeAsFile((Object)traceabilityStatistics, (File)traceabilityStatsFile);
            handler.addOutputResult(1, (Object)traceabilityStatsFile, false, false);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException("Could not serialize validation statistics", (Throwable)e);
        }
        LOGGER.info("Traceability statistics: " + traceabilityStatistics);
        if (nbEntries == 0) {
            itemStatus.increment(StatusCode.WARNING);
            itemStatus.setEvDetailData(this.buildEvDetData("No metadata entries to secure"));
        } else if (digestValidator.hasInconsistencies()) {
            itemStatus.increment(StatusCode.WARNING);
            itemStatus.setEvDetailData(this.buildEvDetData("Inconsistencies found"));
        } else {
            itemStatus.increment(StatusCode.OK);
        }
    }

    protected abstract TraceabilityStatistics getTraceabilityStatistics(DigestValidator var1);

    private String buildEvDetData(String message) {
        HashMap<String, String> evDetData = new HashMap<String, String>();
        evDetData.put("message", message);
        return JsonHandler.unprettyPrint(evDetData);
    }

    private void processBulk(List<LfcMetadataPair> lfcMetadataPairList, JsonLineWriter jsonLineWriter, String lifecycleType, DigestValidator digestValidator, StrategyIdOfferIdLoader strategyIdOfferIdLoader) throws ProcessingException, ProcessingStatusException {
        LOGGER.debug("Processing " + lfcMetadataPairList.size() + " traceability data entries");
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            DataCategory dataCategory = lifecycleType.equals(LogbookLifeCycleUnit.class.getName()) ? DataCategory.UNIT : DataCategory.OBJECTGROUP;
            Map<String, DigestValidationDetails> metadataDigestsById = this.computeMetadataDigests(lfcMetadataPairList, lifecycleType, storageClient, dataCategory, digestValidator, strategyIdOfferIdLoader);
            Map<String, Map<String, DigestValidationDetails>> objectDigestsByObjectGroupId = this.computeObjectDigests(lfcMetadataPairList, lifecycleType, storageClient, digestValidator, strategyIdOfferIdLoader);
            for (LfcMetadataPair lfcMetadataPair : lfcMetadataPairList) {
                String id = lfcMetadataPair.getLfc().get("_id").textValue();
                JsonNode lifecycle = lfcMetadataPair.getLfc();
                JsonNode metadata = lfcMetadataPair.getMetadata();
                this.storeTraceabilityData(id, lifecycle, metadata, metadataDigestsById.get(id), objectDigestsByObjectGroupId.get(id), lifecycleType, jsonLineWriter);
            }
        }
        catch (StorageServerClientException | IOException e) {
            throw new ProcessingException("Could not load storage information", e);
        }
    }

    private Map<String, DigestValidationDetails> computeMetadataDigests(List<LfcMetadataPair> lfcMetadataPairList, String lifecycleType, StorageClient storageClient, DataCategory dataCategory, DigestValidator digestValidator, StrategyIdOfferIdLoader strategyIdOfferIdLoader) throws IOException, StorageServerClientException, ProcessingException, ProcessingStatusException {
        Map<String, String> metadataDigestsInDb = this.computeMetadataDigestsInDb(lfcMetadataPairList, lifecycleType);
        ArrayListValuedHashMap metadataIdsByStrategyId = new ArrayListValuedHashMap();
        for (LfcMetadataPair lfcMetadataPair : lfcMetadataPairList) {
            JsonNode metadata = lfcMetadataPair.getMetadata();
            String id2 = metadata.get("_id").textValue();
            String strategyID = this.getStrategyId(metadata);
            metadataIdsByStrategyId.put((Object)strategyID, (Object)id2);
        }
        HashMap<String, DigestValidationDetails> result = new HashMap<String, DigestValidationDetails>();
        ArrayList<String> listMetadataIdKo = new ArrayList<String>();
        for (String strategyId : metadataIdsByStrategyId.keySet()) {
            Collection metadataIds = metadataIdsByStrategyId.get((Object)strategyId);
            List<String> offerIds = strategyIdOfferIdLoader.getOfferIds(strategyId);
            Collection metadataFilenames = metadataIds.stream().map(id -> id + JSON_EXTENSION).collect(Collectors.toList());
            Map<String, Map<String, String>> offerDigestsByMetadataFilenames = this.getOfferDigests(storageClient, dataCategory, strategyId, offerIds, metadataFilenames);
            for (String id3 : metadataIds) {
                Map<String, String> digestByOfferId = offerDigestsByMetadataFilenames.get(id3 + JSON_EXTENSION);
                String digestInDb = metadataDigestsInDb.get(id3);
                DigestValidationDetails digestValidationDetails = digestValidator.validateMetadataDigest(id3, strategyId, digestInDb, digestByOfferId);
                if (digestValidationDetails.hasError()) {
                    String errorMessage = String.format("All digests are inconsistent for metadata with id=%s in offers %s. Digest in db : %s", id3, digestByOfferId.toString(), digestInDb);
                    LOGGER.error(errorMessage);
                    listMetadataIdKo.add(id3);
                    continue;
                }
                result.put(id3, digestValidationDetails);
            }
        }
        if (!listMetadataIdKo.isEmpty()) {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            String message = "There are at least" + listMetadataIdKo.size() + " metadata with inconsistent digest between database and offers";
            evDetData.put("error", message);
            evDetData.putPOJO("idObjectKo", listMetadataIdKo);
            throw new ProcessingStatusException(StatusCode.KO, evDetData, message);
        }
        return result;
    }

    private Map<String, String> computeMetadataDigestsInDb(List<LfcMetadataPair> lfcMetadataPairList, String lifecycleType) throws IOException {
        HashMap<String, String> dbMetadataWithLfcDigests = new HashMap<String, String>();
        for (LfcMetadataPair lfcMetadataPair : lfcMetadataPairList) {
            JsonNode metadataWithLfc = this.getMetadataWithLifecycle(lifecycleType, lfcMetadataPair);
            Digest digest = new Digest(this.digestType);
            OutputStream digestOutputStream = digest.getDigestOutputStream((OutputStream)new NullOutputStream());
            CanonicalJsonFormatter.serialize((JsonNode)metadataWithLfc, (OutputStream)new BufferedOutputStream(digestOutputStream, 256));
            String dbDigest = digest.digestHex();
            String id = lfcMetadataPair.getLfc().get("_id").textValue();
            dbMetadataWithLfcDigests.put(id, dbDigest);
        }
        return dbMetadataWithLfcDigests;
    }

    private JsonNode getMetadataWithLifecycle(String lifecycleType, LfcMetadataPair lfcMetadataPair) {
        JsonNode metadataWithLfc;
        if (lifecycleType.equals(LogbookLifeCycleObjectGroup.class.getName())) {
            JsonNode unit = lfcMetadataPair.getMetadata();
            MetadataDocumentHelper.removeComputedFieldsFromObjectGroup((JsonNode)unit);
            metadataWithLfc = MetadataStorageHelper.getGotWithLFC((JsonNode)unit, (JsonNode)lfcMetadataPair.getLfc());
        } else {
            JsonNode objectGroup = lfcMetadataPair.getMetadata();
            MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)objectGroup);
            metadataWithLfc = MetadataStorageHelper.getUnitWithLFC((JsonNode)objectGroup, (JsonNode)lfcMetadataPair.getLfc());
        }
        return metadataWithLfc;
    }

    private Map<String, Map<String, DigestValidationDetails>> computeObjectDigests(List<LfcMetadataPair> lfcMetadataPairList, String lifecycleType, StorageClient storageClient, DigestValidator digestValidator, StrategyIdOfferIdLoader strategyIdOfferIdLoader) throws StorageServerClientException, ProcessingException, ProcessingStatusException {
        if (lifecycleType.equals(LogbookLifeCycleUnit.class.getName())) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> objectGroupIdByObjectId = new HashMap<String, Object>();
        ArrayListValuedHashMap objectIdsByStrategyId = new ArrayListValuedHashMap();
        HashMap<String, String> dbDigestByObjectId = new HashMap<String, String>();
        for (LfcMetadataPair lfcMetadataPair : lfcMetadataPairList) {
            String objectGroupId = lfcMetadataPair.getLfc().get("_id").textValue();
            JsonNode objectGroup = lfcMetadataPair.getMetadata();
            JsonNode qualifiers = objectGroup.get("_qualifiers");
            for (JsonNode qualifier : qualifiers) {
                JsonNode versions = qualifier.get("versions");
                for (JsonNode version : versions) {
                    if (version.get("PhysicalId") != null) continue;
                    String objectId = version.get("_id").asText();
                    String strategyId = this.getStrategyId(version);
                    String digestInDb = version.get(MESSAGE_DIGEST).asText();
                    objectGroupIdByObjectId.put(objectId, objectGroupId);
                    objectIdsByStrategyId.put((Object)strategyId, (Object)objectId);
                    dbDigestByObjectId.put(objectId, digestInDb);
                }
            }
        }
        ArrayList<String> listObjectIdKo = new ArrayList<String>();
        HashMap<String, Map<String, DigestValidationDetails>> result = new HashMap<String, Map<String, DigestValidationDetails>>();
        for (String strategyId : objectIdsByStrategyId.keySet()) {
            List objectIds = objectIdsByStrategyId.get((Object)strategyId);
            List<String> offerIds = strategyIdOfferIdLoader.getOfferIds(strategyId);
            Map<String, Map<String, String>> offerDigestsByObjectIds = this.getOfferDigests(storageClient, DataCategory.OBJECT, strategyId, offerIds, objectIds, this.batchSize);
            for (String objectId : offerDigestsByObjectIds.keySet()) {
                Map<String, String> offerDigest = offerDigestsByObjectIds.get(objectId);
                String dbDigest = (String)dbDigestByObjectId.get(objectId);
                String objectGroupId = (String)objectGroupIdByObjectId.get(objectId);
                Map digestValidationDetailsByObjectId = result.computeIfAbsent(objectGroupId, unused -> new HashMap());
                DigestValidationDetails digestValidationDetails = digestValidator.validateObjectDigest(objectId, strategyId, dbDigest, offerDigest);
                if (digestValidationDetails.hasError()) {
                    String errorMessage = String.format("All digests are inconsistent for object with id=%s in offers %s. Digest in db : %s", objectId, offerDigest.toString(), dbDigest);
                    LOGGER.error(errorMessage);
                    listObjectIdKo.add(objectId);
                    continue;
                }
                digestValidationDetailsByObjectId.put(objectId, digestValidationDetails);
            }
        }
        if (!listObjectIdKo.isEmpty()) {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            String message = "There are at least" + listObjectIdKo.size() + " objects with inconsistent digest between database and offers";
            evDetData.put("error", message);
            evDetData.putPOJO("idObjectKo", listObjectIdKo);
            throw new ProcessingStatusException(StatusCode.KO, evDetData, message);
        }
        return result;
    }

    private String getStrategyId(JsonNode metadata) {
        String id = metadata.get("_id").textValue();
        JsonNode storageNode = metadata.get(STORAGE_FIELD);
        if (storageNode == null || !storageNode.isObject()) {
            throw new IllegalStateException("No storage information for metadata " + id);
        }
        JsonNode strategyNode = storageNode.get(STRATEGY_ID_FIELD);
        if (strategyNode == null || !strategyNode.isTextual()) {
            throw new IllegalStateException("No strategy id information for metadata " + id);
        }
        return strategyNode.asText();
    }

    private Map<String, Map<String, String>> getOfferDigests(StorageClient storageClient, DataCategory dataCategory, String strategyId, List<String> offerIds, List<String> dbDigests, int batchSize) throws ProcessingException, StorageServerClientException {
        List partitions = ListUtils.partition(dbDigests, (int)batchSize);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (List partition : partitions) {
            result.putAll(this.getOfferDigests(storageClient, dataCategory, strategyId, offerIds, partition));
        }
        return result;
    }

    private Map<String, Map<String, String>> getOfferDigests(StorageClient storageClient, DataCategory dataCategory, String strategyId, Collection<String> offerIds, Collection<String> ids) throws StorageServerClientException, ProcessingException {
        Stopwatch bulkObjectInformationSW = Stopwatch.createStarted();
        RequestResponse requestResponse = storageClient.getBatchObjectInformation(strategyId, dataCategory, offerIds, ids);
        PerformanceLogger.getInstance().log(this.stepName(), this.actionName(), "BULK_DIGEST_" + dataCategory.getCollectionName().toUpperCase(), bulkObjectInformationSW.elapsed(TimeUnit.MILLISECONDS));
        if (!requestResponse.isOk()) {
            throw new ProcessingException("Could not load storage information " + dataCategory + ": " + ((VitamError)requestResponse).getDescription());
        }
        return ((RequestResponseOK)requestResponse).getResults().stream().collect(Collectors.toMap(BatchObjectInformationResponse::getObjectId, BatchObjectInformationResponse::getOfferDigests));
    }

    private void storeTraceabilityData(String id, JsonNode lifecycle, JsonNode metadata, DigestValidationDetails metadataDigestValidationDetails, Map<String, DigestValidationDetails> objectDigests, String lifecycleType, JsonLineWriter jsonLineWriter) throws ProcessingException {
        try {
            ArrayNode events = (ArrayNode)lifecycle.get("events");
            JsonNode lastEvent = (JsonNode)Iterables.getLast((Iterable)events);
            String finalOutcome = this.getJsonText(lastEvent, LogbookMongoDbName.outcome);
            String finalEventIdProc = this.getJsonText(lifecycle, LogbookMongoDbName.eventIdentifierProcess);
            String finalEventTypeProc = this.getJsonText(lastEvent, LogbookMongoDbName.eventTypeProcess);
            String finalEvDateTime = this.getJsonText(lastEvent, LogbookMongoDbName.eventDateTime);
            String hashLFC = BuildTraceabilityActionPlugin.generateDigest(lifecycle, this.digestType);
            String hashLFCEvents = BuildTraceabilityActionPlugin.generateDigest((JsonNode)events, this.digestType);
            LifeCycleTraceabilitySecureFileObject lfcTraceSecFileDataLine = new LifeCycleTraceabilitySecureFileObject(finalEventIdProc, finalEventTypeProc, finalEvDateTime, lifecycle.get("_id").asText(), null, lifecycle.get("_v").asInt(), finalOutcome, hashLFC, hashLFCEvents, null, null, null);
            ArrayList parents = new ArrayList();
            if (metadata.has("_up")) {
                metadata.get("_up").forEach(up -> parents.add(up.asText()));
            }
            lfcTraceSecFileDataLine.setUp(parents);
            TraceabilityHashDetails metadataTraceabilityHashDetails = new TraceabilityHashDetails().setStrategyId(metadataDigestValidationDetails.getStrategyId()).setOfferIds(metadataDigestValidationDetails.getOfferIds());
            if (metadataDigestValidationDetails.hasInconsistencies()) {
                metadataTraceabilityHashDetails.setDbHash(metadataDigestValidationDetails.getDigestInDb());
                metadataTraceabilityHashDetails.setOfferHashes(metadataDigestValidationDetails.getDigestByOfferId());
            }
            lfcTraceSecFileDataLine.setTraceabilityHashDetails(metadataTraceabilityHashDetails);
            lfcTraceSecFileDataLine.setHashGlobalFromStorage(metadataDigestValidationDetails.getGlobalDigest());
            if (LogbookLifeCycleUnit.class.getName().equals(lifecycleType)) {
                lfcTraceSecFileDataLine.setMetadataType(MetadataType.UNIT);
                MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)metadata);
                lfcTraceSecFileDataLine.setHashMetadata(BuildTraceabilityActionPlugin.generateDigest(metadata, this.digestType));
                if (metadata.get("_og") != null) {
                    lfcTraceSecFileDataLine.setIdGot(metadata.get("_og").textValue());
                }
            } else if (LogbookLifeCycleObjectGroup.class.getName().equals(lifecycleType)) {
                lfcTraceSecFileDataLine.setMetadataType(MetadataType.OBJECTGROUP);
                MetadataDocumentHelper.removeComputedFieldsFromObjectGroup((JsonNode)metadata);
                lfcTraceSecFileDataLine.setHashMetadata(BuildTraceabilityActionPlugin.generateDigest(metadata, this.digestType));
                ArrayList<ObjectGroupDocumentHash> objectHashes = new ArrayList<ObjectGroupDocumentHash>();
                if (objectDigests != null) {
                    for (String objectId : objectDigests.keySet()) {
                        DigestValidationDetails objectDigestValidationDetails = objectDigests.get(objectId);
                        TraceabilityHashDetails objectTraceabilityHashDetails = new TraceabilityHashDetails().setStrategyId(objectDigestValidationDetails.getStrategyId()).setOfferIds(objectDigestValidationDetails.getOfferIds());
                        if (objectDigestValidationDetails.hasInconsistencies()) {
                            objectTraceabilityHashDetails.setDbHash(objectDigestValidationDetails.getDigestInDb());
                            objectTraceabilityHashDetails.setOfferHashes(objectDigestValidationDetails.getDigestByOfferId());
                        }
                        objectHashes.add(new ObjectGroupDocumentHash(objectId, objectDigestValidationDetails.getGlobalDigest(), objectTraceabilityHashDetails));
                    }
                }
                lfcTraceSecFileDataLine.setObjectGroupDocumentHashList(objectHashes);
            } else {
                throw new IllegalStateException("Unknown lifecycleType " + lifecycleType);
            }
            jsonLineWriter.addEntry((Object)lfcTraceSecFileDataLine);
        }
        catch (IOException e) {
            throw new ProcessingException("Could not serialize json object or could not write to file", (Throwable)e);
        }
    }

    private String getJsonText(JsonNode lastEvent, LogbookMongoDbName outcome) {
        if (lastEvent == null || !lastEvent.has(outcome.getDbname())) {
            return null;
        }
        return lastEvent.get(outcome.getDbname()).asText();
    }

    public static String generateDigest(JsonNode jsonNode, DigestType digestType) throws IOException {
        Digest digest = new Digest(digestType);
        OutputStream digestOutputStream = digest.getDigestOutputStream((OutputStream)new NullOutputStream());
        CanonicalJsonFormatter.serialize((JsonNode)jsonNode, (OutputStream)new BufferedOutputStream(digestOutputStream, 256));
        return digest.digest64();
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    protected abstract String stepName();

    protected abstract String actionName();
}

