/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.lfc_traceability;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.logbook.common.model.EntryTraceabilityStatistics;
import fr.gouv.vitam.logbook.common.model.TraceabilityStatistics;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroup;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.BuildTraceabilityActionPlugin;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.DigestValidator;
import fr.gouv.vitam.worker.core.plugin.lfc_traceability.PrepareUnitLfcTraceabilityActionPlugin;

public class BuildObjectGroupTraceabilityActionPlugin
extends BuildTraceabilityActionPlugin {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PrepareUnitLfcTraceabilityActionPlugin.class);
    private static final String STP_OG_LFC_TRACEABILITY = "STP_OG_LFC_TRACEABILITY";
    private static final String ACTION_HANDLER_ID = "BUILD_OG_LFC_TRACEABILITY";

    public BuildObjectGroupTraceabilityActionPlugin() {
    }

    @VisibleForTesting
    BuildObjectGroupTraceabilityActionPlugin(StorageClientFactory storageClientFactory, int batchSize, AlertService alertService) {
        super(storageClientFactory, batchSize, alertService);
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) throws ProcessingException {
        LOGGER.info("Building object group traceability data");
        ItemStatus itemStatus = new ItemStatus(ACTION_HANDLER_ID);
        this.buildTraceabilityData(handler, LogbookLifeCycleObjectGroup.class.getName(), itemStatus);
        LOGGER.info("Building object group traceability data finished with status " + itemStatus.getGlobalStatus());
        return new ItemStatus(ACTION_HANDLER_ID).setItemsStatus(ACTION_HANDLER_ID, itemStatus);
    }

    @Override
    protected TraceabilityStatistics getTraceabilityStatistics(DigestValidator digestValidator) {
        return TraceabilityStatistics.ofObjectGroupsTraceabilityStatistics((EntryTraceabilityStatistics)digestValidator.getMetadataValidationStatistics(), (EntryTraceabilityStatistics)digestValidator.getObjectValidationStatistics());
    }

    @Override
    protected String stepName() {
        return STP_OG_LFC_TRACEABILITY;
    }

    @Override
    protected String actionName() {
        return ACTION_HANDLER_ID;
    }

    public static String getId() {
        return ACTION_HANDLER_ID;
    }
}

