/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.ingestcleanup.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.utils.BufferedConsumer;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.report.CleanupReportManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class IngestCleanupEligibilityService {
    private static final TypeReference<List<String>> STRING_LIST_TYPE_REFERENCE = new TypeReference<List<String>>(){};
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public IngestCleanupEligibilityService(MetaDataClientFactory metaDataClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public void checkChildUnitsFromOtherIngests(String ingestOperationId, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            SelectMultiQuery query = new SelectMultiQuery();
            query.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            query.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.initialOperation(), (String)ingestOperationId)});
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(client, query, VitamConfiguration.getBatchSize());
            try (BufferedConsumer bufferedConsumer = new BufferedConsumer(VitamConfiguration.getBatchSize(), ids -> this.checkChildUnitsFromOtherIngests(ingestOperationId, cleanupReportManager, (List<String>)ids));){
                scrollRequest.forEachRemaining(entry -> bufferedConsumer.accept((Object)entry.get(VitamFieldsHelper.id()).asText()));
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not checks unit updates", e);
        }
    }

    private void checkChildUnitsFromOtherIngests(String ingestOperationId, CleanupReportManager cleanupReportManager, List<String> ids) {
        try {
            Set<String> unitsWithExternalAttachments = this.getUnitsWithExternalAttachments(ingestOperationId, ids);
            for (String unitWithExternalAttachments : unitsWithExternalAttachments) {
                cleanupReportManager.reportUnitError(unitWithExternalAttachments, "Unit has child units from other ingest operations");
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> getUnitsWithExternalAttachments(String ingestOperationId, Collection<String> unitIds) throws MetaDataExecutionException, MetaDataClientServerException, MetaDataDocumentSizeException, InvalidParseOperationException, InvalidCreateOperationException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            RequestResponseOK<JsonNode> responseOK;
            Set<String> unitsWithChildren;
            HashSet<String> unitsToFetch = new HashSet<String>(unitIds);
            HashSet<String> result = new HashSet<String>();
            while (!unitsToFetch.isEmpty() && !(unitsWithChildren = this.parseUnitsWithChildren((responseOK = this.selectExternalChildUnit(metaDataClient, ingestOperationId, unitsToFetch)).getResults(), unitsToFetch)).isEmpty()) {
                result.addAll(unitsWithChildren);
                unitsToFetch.removeAll(unitsWithChildren);
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    private RequestResponseOK<JsonNode> selectExternalChildUnit(MetaDataClient metaDataClient, String ingestOperationId, Set<String> unitsToFetch) throws InvalidCreateOperationException, InvalidParseOperationException, MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataClientServerException {
        SelectMultiQuery selectAllUnitsUp = new SelectMultiQuery();
        selectAllUnitsUp.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.in((String)VitamFieldsHelper.unitups(), (String[])unitsToFetch.toArray(new String[0])), QueryHelper.ne((String)VitamFieldsHelper.initialOperation(), (String)ingestOperationId)})});
        selectAllUnitsUp.setLimitFilter(0L, (long)VitamConfiguration.getBatchSize());
        selectAllUnitsUp.addUsedProjection(new String[]{VitamFieldsHelper.unitups()});
        JsonNode response = metaDataClient.selectUnits((JsonNode)selectAllUnitsUp.getFinalSelect());
        return RequestResponseOK.getFromJsonNode((JsonNode)response);
    }

    private Set<String> parseUnitsWithChildren(List<JsonNode> results, Set<String> unitsToFetch) {
        HashSet<String> foundUnitIds = new HashSet<String>();
        for (JsonNode childUnit : results) {
            childUnit.get(VitamFieldsHelper.unitups()).elements().forEachRemaining(jsonNode -> {
                String unitId = jsonNode.asText();
                if (unitsToFetch.contains(unitId)) {
                    foundUnitIds.add(unitId);
                }
            });
        }
        return foundUnitIds;
    }

    public void checkUnitUpdatesFromOtherOperations(String ingestOperationId, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            SelectMultiQuery query = new SelectMultiQuery();
            query.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.operations()});
            query.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.initialOperation(), (String)ingestOperationId)});
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(client, query, VitamConfiguration.getBatchSize());
            scrollRequest.forEachRemaining(unitNode -> {
                try {
                    List ops = (List)JsonHandler.getFromJsonNode((JsonNode)unitNode.get(VitamFieldsHelper.operations()), STRING_LIST_TYPE_REFERENCE);
                    if (ops.size() != 1) {
                        List otherOperations = ops.stream().filter(op -> !op.equals(ingestOperationId)).collect(Collectors.toList());
                        String id = unitNode.get(VitamFieldsHelper.id()).asText();
                        cleanupReportManager.reportUnitWarning(id, "Updates occurred to unit by operations " + otherOperations);
                    }
                }
                catch (InvalidParseOperationException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not checks updated units", e);
        }
    }

    public void checkObjectGroupUpdatesFromOtherOperations(String ingestOperationId, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            SelectMultiQuery query = new SelectMultiQuery();
            query.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.initialOperation(), (String)ingestOperationId)});
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createObjectGroupScrollSplitIterator(client, query, VitamConfiguration.getBatchSize());
            ArrayListValuedHashMap updatedObjectGroupsByOpi = new ArrayListValuedHashMap();
            scrollRequest.forEachRemaining(arg_0 -> IngestCleanupEligibilityService.lambda$checkObjectGroupUpdatesFromOtherOperations$5(ingestOperationId, (MultiValuedMap)updatedObjectGroupsByOpi, arg_0));
            if (!updatedObjectGroupsByOpi.isEmpty()) {
                Set<String> ingestOperations = this.checkIngestOperations(updatedObjectGroupsByOpi.keySet());
                SetUtils.SetView nonIngestOperations = SetUtils.difference((Set)updatedObjectGroupsByOpi.keySet(), ingestOperations);
                for (String nonIngestOperation : nonIngestOperations) {
                    for (String objectGroupId : updatedObjectGroupsByOpi.get((Object)nonIngestOperation)) {
                        cleanupReportManager.reportObjectGroupWarning(objectGroupId, "Updates occurred to object group by operation " + (Set)nonIngestOperations);
                    }
                }
                for (String nonIngestOperation : ingestOperations) {
                    for (String objectGroupId : updatedObjectGroupsByOpi.get((Object)nonIngestOperation)) {
                        cleanupReportManager.reportObjectGroupError(objectGroupId, "Updates occurred to object group by ingest operation " + (Set)nonIngestOperations);
                    }
                }
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not checks updated object groups", e);
        }
    }

    private Set<String> checkIngestOperations(Collection<String> operationIds) throws InvalidCreateOperationException, InvalidParseOperationException, LogbookClientException {
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            HashSet<String> ingestOperations = new HashSet<String>();
            UnmodifiableIterator operationsToCheckIterator = Iterators.partition(operationIds.iterator(), (int)VitamConfiguration.getBatchSize());
            while (operationsToCheckIterator.hasNext()) {
                Select select = new Select();
                BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.in((String)"#id", (String[])((List)operationsToCheckIterator.next()).toArray(new String[0])), QueryHelper.eq((String)LogbookMongoDbName.eventTypeProcess.getDbname(), (String)LogbookTypeProcess.INGEST.name())});
                select.setQuery((Query)query);
                select.addUsedProjection(new String[]{"#id"});
                JsonNode jsonNode = logbookOperationsClient.selectOperation((JsonNode)select.getFinalSelect());
                for (JsonNode logbook : jsonNode.get("$results")) {
                    ingestOperations.add(logbook.get("#id").asText());
                }
            }
            HashSet<String> hashSet = ingestOperations;
            return hashSet;
        }
    }

    public void checkObjectAttachmentsToExistingObjectGroups(String ingestOperationId, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            SelectMultiQuery query = new SelectMultiQuery();
            query.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            query.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.ne((String)VitamFieldsHelper.initialOperation(), (String)ingestOperationId), QueryHelper.eq((String)VitamFieldsHelper.operations(), (String)ingestOperationId)})});
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createObjectGroupScrollSplitIterator(client, query, VitamConfiguration.getBatchSize());
            scrollRequest.forEachRemaining(objectGroup -> {
                String objectGroupId = objectGroup.get("#id").asText();
                cleanupReportManager.reportObjectGroupError(objectGroupId, "Existing object group updated by ingest operation " + ingestOperationId);
            });
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not list attachment to existing object groups", e);
        }
    }

    private static /* synthetic */ void lambda$checkObjectGroupUpdatesFromOtherOperations$5(String ingestOperationId, MultiValuedMap updatedObjectGroupsByOpi, JsonNode objectGroupNode) {
        try {
            List ops = (List)JsonHandler.getFromJsonNode((JsonNode)objectGroupNode.get(VitamFieldsHelper.operations()), STRING_LIST_TYPE_REFERENCE);
            for (String op : ops) {
                if (op.equals(ingestOperationId)) continue;
                String id = objectGroupNode.get(VitamFieldsHelper.id()).asText();
                updatedObjectGroupsByOpi.put((Object)op, (Object)id);
            }
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

