/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.ingestcleanup.report;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.report.CleanupReport;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.report.IngestCleanupObjectGroupReportEntry;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.report.IngestCleanupUnitReportEntry;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;

public class CleanupReportManager {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CleanupReportManager.class);
    public static final String CLEANUP_REPORT_BACKUP_FILE_NAME = "cleanupReportBackup.json";
    private static final String JSONL_EXTENSION = ".jsonl";
    private final CleanupReport cleanupReport;

    private CleanupReportManager(CleanupReport cleanupReport) {
        this.cleanupReport = cleanupReport;
    }

    public void reportUnitError(String id, String message) {
        IngestCleanupUnitReportEntry unitReportEntry = this.cleanupReport.getUnits().computeIfAbsent(id, _id -> new IngestCleanupUnitReportEntry().setId((String)_id));
        unitReportEntry.addError(message);
        unitReportEntry.updateStatus(StatusCode.KO);
    }

    public void reportUnitWarning(String id, String message) {
        IngestCleanupUnitReportEntry unitReportEntry = this.cleanupReport.getUnits().computeIfAbsent(id, _id -> new IngestCleanupUnitReportEntry().setId((String)_id));
        unitReportEntry.addWarning(message);
        unitReportEntry.updateStatus(StatusCode.WARNING);
    }

    public void reportObjectGroupError(String id, String message) {
        IngestCleanupObjectGroupReportEntry objectGroupReportEntry = this.cleanupReport.getObjectGroups().computeIfAbsent(id, _id -> new IngestCleanupObjectGroupReportEntry().setId((String)_id));
        objectGroupReportEntry.addError(message);
        objectGroupReportEntry.updateStatus(StatusCode.KO);
    }

    public void reportObjectGroupWarning(String id, String message) {
        IngestCleanupObjectGroupReportEntry objectGroupReportEntry = this.cleanupReport.getObjectGroups().computeIfAbsent(id, _id -> new IngestCleanupObjectGroupReportEntry().setId((String)_id));
        objectGroupReportEntry.addWarning(message);
        objectGroupReportEntry.updateStatus(StatusCode.WARNING);
    }

    public void reportDeletedUnit(String id) {
        IngestCleanupUnitReportEntry unitReportEntry = this.cleanupReport.getUnits().computeIfAbsent(id, _id -> new IngestCleanupUnitReportEntry().setId((String)_id));
        unitReportEntry.updateStatus(StatusCode.OK);
    }

    public void reportDeletedObjectGroup(String id, List<String> objects) {
        IngestCleanupObjectGroupReportEntry objectGroupReportEntry = this.cleanupReport.getObjectGroups().computeIfAbsent(id, _id -> new IngestCleanupObjectGroupReportEntry().setId((String)_id));
        objectGroupReportEntry.updateStatus(StatusCode.OK);
        objectGroupReportEntry.setObjects(objects);
    }

    public StatusCode getGlobalStatus() {
        StatusCode statusCode = StatusCode.OK;
        for (IngestCleanupUnitReportEntry unitReportEntry : this.cleanupReport.getUnits().values()) {
            if (statusCode.compareTo((Enum)unitReportEntry.getStatus()) >= 0) continue;
            statusCode = unitReportEntry.getStatus();
        }
        for (IngestCleanupObjectGroupReportEntry objectGroupReportEntry : this.cleanupReport.getObjectGroups().values()) {
            if (statusCode.compareTo((Enum)objectGroupReportEntry.getStatus()) >= 0) continue;
            statusCode = objectGroupReportEntry.getStatus();
        }
        return statusCode;
    }

    public void persistReportDataToWorkspace(HandlerIO handlerIO) throws ProcessingStatusException {
        File tmpFile = handlerIO.getNewLocalFile(GUIDFactory.newGUID().getId());
        try {
            JsonHandler.writeAsFile((Object)this.cleanupReport, (File)tmpFile);
            handlerIO.transferFileToWorkspace(CLEANUP_REPORT_BACKUP_FILE_NAME, tmpFile, true, false);
        }
        catch (InvalidParseOperationException | ProcessingException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not persist cleanup report", e);
        }
    }

    public void exportReport(HandlerIO handlerIO, StorageClient storageClient) throws ProcessingStatusException {
        File tmpFile = this.generateReport(handlerIO);
        this.saveReportToOffers(handlerIO, storageClient, tmpFile);
    }

    private File generateReport(HandlerIO handlerIO) throws ProcessingStatusException {
        File tmpFile = handlerIO.getNewLocalFile(GUIDFactory.newGUID().getId());
        try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)fileOutputStream);){
            writer.addEntry((Object)JsonHandler.createObjectNode().put("ingestOperationId", this.cleanupReport.getIngestOperationId()));
            for (IngestCleanupUnitReportEntry unit : this.cleanupReport.getUnits().values()) {
                writer.addEntry(new JsonLineModel(unit.getId(), null, JsonHandler.toJsonNode((Object)unit)));
            }
            for (IngestCleanupObjectGroupReportEntry objectGroup : this.cleanupReport.getObjectGroups().values()) {
                writer.addEntry(new JsonLineModel(objectGroup.getId(), null, JsonHandler.toJsonNode((Object)objectGroup)));
            }
        }
        catch (InvalidParseOperationException | IOException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate report", e);
        }
        return tmpFile;
    }

    private void saveReportToOffers(HandlerIO handlerIO, StorageClient storageClient, File tmpFile) throws ProcessingStatusException {
        try {
            String reportFileName = handlerIO.getContainerName() + JSONL_EXTENSION;
            handlerIO.transferFileToWorkspace(reportFileName, tmpFile, true, false);
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(handlerIO.getContainerName());
            description.setWorkspaceObjectURI(reportFileName);
            storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.REPORT, reportFileName, description);
        }
        catch (ProcessingException | StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not export report", e);
        }
    }

    @VisibleForTesting
    public CleanupReport getCleanupReport() {
        return this.cleanupReport;
    }

    public static CleanupReportManager newReport(String ingestOperationId) {
        return new CleanupReportManager(new CleanupReport().setIngestOperationId(ingestOperationId));
    }

    public static Optional<CleanupReportManager> loadReportDataFromWorkspace(HandlerIO handlerIO) throws ProcessingStatusException {
        Optional<CleanupReportManager> optional;
        block9: {
            InputStream inputStream = handlerIO.getInputStreamFromWorkspace(CLEANUP_REPORT_BACKUP_FILE_NAME);
            try {
                CleanupReport cleanupReport = (CleanupReport)JsonHandler.getFromInputStream((InputStream)inputStream, CleanupReport.class);
                optional = Optional.of(new CleanupReportManager(cleanupReport));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | ContentAddressableStorageServerException | IOException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could not load cleanup report", e);
                }
                catch (ContentAddressableStorageNotFoundException e) {
                    LOGGER.warn("Report not found", (Throwable)e);
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }
}

