/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.ingestcleanup;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class IngestCleanupRequestValidationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestCleanupRequestValidationPlugin.class);
    String INGEST_CLEANUP_REQUEST_VALIDATION = "INGEST_CLEANUP_REQUEST_VALIDATION";
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public IngestCleanupRequestValidationPlugin() {
        this(ProcessingManagementClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    IngestCleanupRequestValidationPlugin(ProcessingManagementClientFactory processingManagementClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            String ingestOperationId = param.getParameterValue(WorkerParameterName.ingestOperationIdToCleanup);
            this.checkIngestOperationId(ingestOperationId);
            LOGGER.info("Ingest cleanup request validation succeeded");
            return PluginHelper.buildItemStatus(this.INGEST_CLEANUP_REQUEST_VALIDATION, StatusCode.OK);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Ingest cleanup request validation failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(this.INGEST_CLEANUP_REQUEST_VALIDATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    private void checkIngestOperationId(String ingestOperationId) throws ProcessingStatusException {
        LogbookOperation logbookOperation = this.getLogbookOperation(ingestOperationId);
        this.checkOperationType(ingestOperationId, logbookOperation);
        ProcessDetail processDetails = this.getProcessDetails(ingestOperationId);
        this.checkProcessCompletion(processDetails, ingestOperationId);
        StatusCode statusCode = this.getStatusCode(logbookOperation, processDetails);
        this.ensureWorkflowFailed(ingestOperationId, statusCode);
    }

    private LogbookOperation getLogbookOperation(String ingestOperationId) throws ProcessingStatusException {
        LogbookOperation logbookOperation;
        block9: {
            LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
            try {
                JsonNode jsonNode = logbookOperationsClient.selectOperationById(ingestOperationId);
                logbookOperation = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)jsonNode.get("$results").get(0), LogbookOperation.class);
                if (logbookOperationsClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookOperationsClient != null) {
                        try {
                            logbookOperationsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientNotFoundException e) {
                    throw new ProcessingStatusException(StatusCode.KO, "Logbook operation not found " + ingestOperationId);
                }
                catch (InvalidParseOperationException | LogbookClientException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could load logbook operation " + ingestOperationId, e);
                }
            }
            logbookOperationsClient.close();
        }
        return logbookOperation;
    }

    private void checkOperationType(String ingestOperationId, LogbookOperation logbookOperation) throws ProcessingStatusException {
        if (!logbookOperation.getEvTypeProc().equals(LogbookTypeProcess.INGEST.name())) {
            throw new ProcessingStatusException(StatusCode.KO, "Expected INGEST operation, found " + logbookOperation.getEvTypeProc() + " for operation " + ingestOperationId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProcessDetail getProcessDetails(String ingestOperationId) throws ProcessingStatusException {
        try (ProcessingManagementClient processingManagementClient = this.processingManagementClientFactory.getClient();){
            ProcessQuery query = new ProcessQuery();
            query.setId(ingestOperationId);
            RequestResponse processDetailRequestResponse = processingManagementClient.listOperationsDetails(query);
            if (!processDetailRequestResponse.isOk()) {
                VitamError error = (VitamError)processDetailRequestResponse;
                throw new ProcessingStatusException(StatusCode.FATAL, "Could not check active processes " + error.getDescription() + " - " + error.getMessage());
            }
            List processDetails = ((RequestResponseOK)processDetailRequestResponse).getResults();
            if (processDetails.isEmpty()) {
                LOGGER.info("No active workflow... Operation is COMPLETED");
                ProcessDetail processDetail2 = null;
                return processDetail2;
            }
            ProcessDetail processDetail = (ProcessDetail)processDetails.get(0);
            return processDetail;
        }
        catch (VitamClientException | IllegalArgumentException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not check active processes", e);
        }
    }

    private void checkProcessCompletion(ProcessDetail processDetails, String ingestOperationId) throws ProcessingStatusException {
        if (processDetails == null) {
            LOGGER.info("Process not found --> already COMPLETED & purged from processing manager");
            return;
        }
        ProcessState processState = ProcessState.valueOf((String)processDetails.getGlobalState());
        if (processState != ProcessState.COMPLETED) {
            throw new ProcessingStatusException(StatusCode.KO, "Process " + ingestOperationId + " is not yet COMPLETED");
        }
    }

    private StatusCode getStatusCode(LogbookOperation logbookOperation, ProcessDetail processDetails) {
        if (processDetails != null) {
            return StatusCode.valueOf((String)processDetails.getStepStatus());
        }
        if (CollectionUtils.isEmpty((Collection)logbookOperation.getEvents())) {
            return null;
        }
        return Lists.reverse((List)logbookOperation.getEvents()).stream().filter(e -> e.getEvType().equals(logbookOperation.getEvType())).findFirst().map(LogbookEvent::getOutcome).map(StatusCode::valueOf).orElse(null);
    }

    private void ensureWorkflowFailed(String ingestOperationId, StatusCode statusCode) throws ProcessingStatusException {
        if (statusCode == null) {
            LOGGER.info("Process " + ingestOperationId + " completed without final result (aborted?)");
            return;
        }
        if (statusCode.isGreaterOrEqualToKo()) {
            LOGGER.info("Process " + ingestOperationId + " completed with errors");
            return;
        }
        throw new ProcessingStatusException(StatusCode.KO, "Process " + ingestOperationId + " did not fail (" + statusCode + ")");
    }
}

