/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.ingestcleanup;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.PurgeAccessionRegisterModel;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.report.CleanupReportManager;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeObjectGroupParams;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class IngestCleanupPreparationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestCleanupPreparationPlugin.class);
    private static final String INGEST_CLEANUP_PREPARATION = "INGEST_CLEANUP_PREPARATION";
    public static final String UNITS_TO_DELETE_JSONL = "units.jsonl";
    public static final String OBJECT_GROUPS_TO_DELETE_JSONL = "objectGroups.jsonl";
    public static final String ACCESSION_REGISTERS_JSONL = "accession_register.jsonl";
    private final MetaDataClientFactory metaDataClientFactory;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public IngestCleanupPreparationPlugin() {
        this(MetaDataClientFactory.getInstance(), AdminManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    IngestCleanupPreparationPlugin(MetaDataClientFactory metaDataClientFactory, AdminManagementClientFactory adminManagementClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            String ingestOperationId = param.getParameterValue(WorkerParameterName.ingestOperationIdToCleanup);
            PurgeAccessionRegisterModel accessionRegisterModel = new PurgeAccessionRegisterModel();
            accessionRegisterModel.setOpi(ingestOperationId);
            CleanupReportManager cleanupReportManager = this.loadCleanupReportManager(handler);
            this.prepareUnits(handler, ingestOperationId, accessionRegisterModel, cleanupReportManager);
            this.prepareObjectGroups(handler, ingestOperationId, accessionRegisterModel, cleanupReportManager);
            this.prepareAccessingRegister(handler, ingestOperationId, accessionRegisterModel);
            cleanupReportManager.persistReportDataToWorkspace(handler);
            LOGGER.info("Ingest cleanup preparation succeeded");
            return PluginHelper.buildItemStatus(INGEST_CLEANUP_PREPARATION, StatusCode.OK);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Ingest cleanup preparation failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(INGEST_CLEANUP_PREPARATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    private CleanupReportManager loadCleanupReportManager(HandlerIO handler) throws ProcessingStatusException, ProcessingException {
        Optional<CleanupReportManager> cleanupReportManager = CleanupReportManager.loadReportDataFromWorkspace(handler);
        if (!cleanupReportManager.isPresent()) {
            throw new ProcessingException("Could not load report");
        }
        return cleanupReportManager.get();
    }

    private void prepareUnits(HandlerIO handler, String ingestOperationId, PurgeAccessionRegisterModel accessionRegisterModel, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        File unitsToDeleteFile = handler.getNewLocalFile(UNITS_TO_DELETE_JSONL);
        try (MetaDataClient client = this.metaDataClientFactory.getClient();
             FileOutputStream fos = new FileOutputStream(unitsToDeleteFile);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)fos);){
            SelectMultiQuery query = new SelectMultiQuery();
            query.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.originatingAgency(), VitamFieldsHelper.storage()});
            query.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.initialOperation(), (String)ingestOperationId)});
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(client, query, VitamConfiguration.getBatchSize());
            scrollRequest.forEachRemaining(unit -> {
                cleanupReportManager.reportDeletedUnit(unit.get(VitamFieldsHelper.id()).asText());
                this.writeToUnitDistributionFile(writer, (JsonNode)unit);
                this.updateUnitAccessingRegisterData(accessionRegisterModel, (JsonNode)unit);
            });
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | IOException | RuntimeException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not create unit distribution file", e);
        }
        this.copyDistributionFileToWorkspace(handler, unitsToDeleteFile, UNITS_TO_DELETE_JSONL);
    }

    private void writeToUnitDistributionFile(JsonLineWriter writer, JsonNode unit) {
        try {
            String id = unit.get(VitamFieldsHelper.id()).asText();
            String strategyId = MetadataDocumentHelper.getStrategyIdFromUnit((JsonNode)unit);
            ObjectNode params = JsonHandler.createObjectNode().put("id", id).put("strategyId", strategyId);
            writer.addEntry(new JsonLineModel(id, null, (JsonNode)params));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateUnitAccessingRegisterData(PurgeAccessionRegisterModel accessionRegisterModel, JsonNode unit) {
        accessionRegisterModel.setOriginatingAgency(unit.get(VitamFieldsHelper.originatingAgency()).asText());
        accessionRegisterModel.setTotalUnits(accessionRegisterModel.getTotalUnits() + 1L);
    }

    private void prepareObjectGroups(HandlerIO handler, String ingestOperationId, PurgeAccessionRegisterModel accessionRegisterModel, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        File objectGroupsToDeleteFile = handler.getNewLocalFile(OBJECT_GROUPS_TO_DELETE_JSONL);
        try (MetaDataClient client = this.metaDataClientFactory.getClient();
             FileOutputStream fos = new FileOutputStream(objectGroupsToDeleteFile);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)fos);){
            SelectMultiQuery query = new SelectMultiQuery();
            query.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.initialOperation(), (String)ingestOperationId)});
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createObjectGroupScrollSplitIterator(client, query, VitamConfiguration.getBatchSize());
            scrollRequest.forEachRemaining(objectGroupNode -> {
                try {
                    ObjectGroupResponse objectGroup = (ObjectGroupResponse)JsonHandler.getFromJsonNode((JsonNode)objectGroupNode, ObjectGroupResponse.class);
                    cleanupReportManager.reportDeletedObjectGroup(objectGroup.getId(), this.listBinaryObjectIds(objectGroup));
                    this.writeToObjectGroupDistributionFile(writer, objectGroup);
                    this.updateObjectGroupAccessingRegisterData(accessionRegisterModel, objectGroup);
                }
                catch (InvalidParseOperationException | IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InvalidCreateOperationException | IOException | RuntimeException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not create object group distribution file", e);
        }
        this.copyDistributionFileToWorkspace(handler, objectGroupsToDeleteFile, OBJECT_GROUPS_TO_DELETE_JSONL);
    }

    private void writeToObjectGroupDistributionFile(JsonLineWriter writer, ObjectGroupResponse objectGroup) throws IOException, InvalidParseOperationException {
        PurgeObjectGroupParams params = PurgeObjectGroupParams.fromObjectGroup(objectGroup);
        writer.addEntry(new JsonLineModel(objectGroup.getId(), null, JsonHandler.toJsonNode((Object)params)));
    }

    private void updateObjectGroupAccessingRegisterData(PurgeAccessionRegisterModel accessionRegisterModel, ObjectGroupResponse objectGroup) {
        accessionRegisterModel.setTotalObjectGroups(accessionRegisterModel.getTotalObjectGroups() + 1L);
        accessionRegisterModel.setTotalObjects(accessionRegisterModel.getTotalObjects() + this.getObjectCount(objectGroup));
        accessionRegisterModel.setTotalSize(accessionRegisterModel.getTotalSize() + this.getTotalObjectSize(objectGroup));
    }

    private List<String> listBinaryObjectIds(ObjectGroupResponse objectGroup) {
        return ListUtils.emptyIfNull((List)objectGroup.getQualifiers()).stream().flatMap(qualifier -> ListUtils.emptyIfNull((List)qualifier.getVersions()).stream()).filter(version -> version.getPhysicalId() == null).map(VersionsModel::getId).collect(Collectors.toList());
    }

    private Long getObjectCount(ObjectGroupResponse objectGroup) {
        return ListUtils.emptyIfNull((List)objectGroup.getQualifiers()).stream().mapToLong(qualifier -> ListUtils.emptyIfNull((List)qualifier.getVersions()).size()).sum();
    }

    private Long getTotalObjectSize(ObjectGroupResponse objectGroup) {
        return ListUtils.emptyIfNull((List)objectGroup.getQualifiers()).stream().flatMap(qualifier -> ListUtils.emptyIfNull((List)qualifier.getVersions()).stream()).filter(version -> version.getPhysicalId() == null).mapToLong(VersionsModel::getSize).sum();
    }

    private void prepareAccessingRegister(HandlerIO handler, String ingestOperationId, PurgeAccessionRegisterModel accessionRegisterModel) throws ProcessingStatusException {
        File accessionRegisterFile = handler.getNewLocalFile(ACCESSION_REGISTERS_JSONL);
        try (FileOutputStream fos = new FileOutputStream(accessionRegisterFile);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)fos);){
            if (!this.hasAccessionRegisterDetails(ingestOperationId)) {
                LOGGER.warn("Accession register details not found...");
            } else if (accessionRegisterModel.getTotalUnits() == 0L && accessionRegisterModel.getTotalObjects() == 0L) {
                LOGGER.warn("No accession register details to update");
            } else {
                writer.addEntry(new JsonLineModel(ingestOperationId, null, JsonHandler.toJsonNode((Object)accessionRegisterModel)));
            }
        }
        catch (InvalidParseOperationException | IOException | RuntimeException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not create accession register distribution file", e);
        }
        this.copyDistributionFileToWorkspace(handler, accessionRegisterFile, ACCESSION_REGISTERS_JSONL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAccessionRegisterDetails(String operationId) throws ProcessingStatusException {
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            Select select = new Select();
            select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"Opi", (String)operationId), QueryHelper.exists((String)VitamFieldsHelper.id())}));
            RequestResponse accessionRegisterDetail = adminManagementClient.getAccessionRegisterDetail((JsonNode)select.getFinalSelect());
            if (!accessionRegisterDetail.isOk()) throw new ProcessingStatusException(StatusCode.FATAL, "Could not check existing accessing register " + accessionRegisterDetail.getStatus());
            List results = ((RequestResponseOK)accessionRegisterDetail).getResults();
            boolean bl = !results.isEmpty();
            return bl;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | ReferentialException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not check existing accessing register", e);
        }
    }

    private void copyDistributionFileToWorkspace(HandlerIO handler, File jsonlFile, String fileName) throws ProcessingStatusException {
        try {
            handler.transferFileToWorkspace(fileName, jsonlFile, true, false);
        }
        catch (ProcessingException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not write object group distribution file " + fileName, e);
        }
    }
}

