/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.ingestcleanup;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.report.CleanupReportManager;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Optional;

public class IngestCleanupFinalizationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestCleanupFinalizationPlugin.class);
    static final String INGEST_CLEANUP_FINALIZATION = "INGEST_CLEANUP_FINALIZATION";
    private final StorageClientFactory storageClientFactory;

    public IngestCleanupFinalizationPlugin() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public IngestCleanupFinalizationPlugin(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            Optional<CleanupReportManager> cleanupReportManager = CleanupReportManager.loadReportDataFromWorkspace(handler);
            if (!cleanupReportManager.isPresent()) {
                LOGGER.warn("No report information available...");
                ItemStatus itemStatus2 = PluginHelper.buildItemStatus(INGEST_CLEANUP_FINALIZATION, StatusCode.WARNING);
                return itemStatus2;
            }
            cleanupReportManager.get().exportReport(handler, storageClient);
            LOGGER.info("Ingest cleanup finalization succeeded");
            ItemStatus itemStatus = PluginHelper.buildItemStatus(INGEST_CLEANUP_FINALIZATION, StatusCode.OK);
            return itemStatus;
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Ingest Cleanup finalization failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(INGEST_CLEANUP_FINALIZATION, e.getStatusCode(), e.getEventDetails());
        }
    }
}

