/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.ingestcleanup;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.report.CleanupReportManager;
import fr.gouv.vitam.worker.core.plugin.ingestcleanup.service.IngestCleanupEligibilityService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public class IngestCleanupEligibilityValidationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestCleanupEligibilityValidationPlugin.class);
    private static final String INGEST_CLEANUP_ELIGIBILITY_VALIDATION = "INGEST_CLEANUP_ELIGIBILITY_VALIDATION";
    private final IngestCleanupEligibilityService ingestCleanupEligibilityService;

    public IngestCleanupEligibilityValidationPlugin() {
        this(new IngestCleanupEligibilityService(MetaDataClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance()));
    }

    @VisibleForTesting
    public IngestCleanupEligibilityValidationPlugin(IngestCleanupEligibilityService ingestCleanupEligibilityService) {
        this.ingestCleanupEligibilityService = ingestCleanupEligibilityService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            String ingestOperationId = param.getParameterValue(WorkerParameterName.ingestOperationIdToCleanup);
            CleanupReportManager cleanupReportManager = CleanupReportManager.newReport(ingestOperationId);
            this.checkUnits(ingestOperationId, cleanupReportManager);
            this.checkObjectGroups(ingestOperationId, cleanupReportManager);
            cleanupReportManager.persistReportDataToWorkspace(handler);
            StatusCode globalStatusCode = cleanupReportManager.getGlobalStatus();
            if (globalStatusCode.isGreaterOrEqualToKo()) {
                LOGGER.error("Blocking validation errors...");
            } else if (globalStatusCode.isGreaterOrEqualToWarn()) {
                LOGGER.warn("Non blocking validation errors...");
            } else {
                LOGGER.info("Ingest cleanup eligibility validation succeeded");
            }
            return PluginHelper.buildItemStatus(INGEST_CLEANUP_ELIGIBILITY_VALIDATION, globalStatusCode);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Cleanup eligibility validation failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(INGEST_CLEANUP_ELIGIBILITY_VALIDATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    private void checkUnits(String ingestOperationId, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        this.ingestCleanupEligibilityService.checkChildUnitsFromOtherIngests(ingestOperationId, cleanupReportManager);
        this.ingestCleanupEligibilityService.checkUnitUpdatesFromOtherOperations(ingestOperationId, cleanupReportManager);
    }

    private void checkObjectGroups(String ingestOperationId, CleanupReportManager cleanupReportManager) throws ProcessingStatusException {
        this.ingestCleanupEligibilityService.checkObjectGroupUpdatesFromOtherOperations(ingestOperationId, cleanupReportManager);
        this.ingestCleanupEligibilityService.checkObjectAttachmentsToExistingObjectGroups(ingestOperationId, cleanupReportManager);
    }
}

