/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.ingestcleanup;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeDeleteService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IngestCleanupDeleteUnitPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestCleanupDeleteUnitPlugin.class);
    private static final String INGEST_CLEANUP_DELETE_UNIT = "INGEST_CLEANUP_DELETE_UNIT";
    private final PurgeDeleteService purgeDeleteService;

    public IngestCleanupDeleteUnitPlugin() {
        this(new PurgeDeleteService());
    }

    @VisibleForTesting
    IngestCleanupDeleteUnitPlugin(PurgeDeleteService purgeDeleteService) {
        this.purgeDeleteService = purgeDeleteService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new UnsupportedOperationException("Unused method");
    }

    public List<ItemStatus> executeList(WorkerParameters param, HandlerIO handler) {
        try {
            return this.processUnits(param.getObjectMetadataList());
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Unit purge failed with status " + e.getStatusCode(), (Throwable)e);
            return Collections.singletonList(PluginHelper.buildItemStatus(INGEST_CLEANUP_DELETE_UNIT, e.getStatusCode(), e.getEventDetails()));
        }
    }

    private List<ItemStatus> processUnits(List<JsonNode> units) throws ProcessingStatusException {
        Map<String, String> unitIdsWithStrategiesToDelete = units.stream().collect(Collectors.toMap(entry -> entry.get("id").asText(), entry -> entry.get("strategyId").asText()));
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        for (String unitId : unitIdsWithStrategiesToDelete.keySet()) {
            LOGGER.info("Unit " + unitId + " will be deleted");
            itemStatuses.add(PluginHelper.buildItemStatus(INGEST_CLEANUP_DELETE_UNIT, StatusCode.OK));
        }
        try {
            this.purgeDeleteService.deleteUnits(unitIdsWithStrategiesToDelete);
        }
        catch (LogbookClientBadRequestException | LogbookClientServerException | MetaDataClientServerException | MetaDataExecutionException | StorageServerClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not delete units [" + String.join((CharSequence)", ", unitIdsWithStrategiesToDelete.keySet()) + "]", e);
        }
        return itemStatuses;
    }

    public static String getId() {
        return INGEST_CLEANUP_DELETE_UNIT;
    }
}

