/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.LifeCycleTraceabilitySecureFileObject;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.ObjectGroupDocumentHash;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyNotFoundException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyUtils;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceAuditException;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceStatus;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditParameters;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class EvidenceService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceService.class);
    private static final String TMP = "tmp";
    private static final String FILE_NAME = "FileName";
    private static final String LAST_PERSISTED_DATE = "_lastPersistedDate";
    private static final String NO_TRACEABILITY_OPERATION_FOUND_MATCHING_DATE = "No traceability operation found matching date ";
    private static final String DIGEST_ALGORITHM = "DigestAlgorithm";
    private static final String DIGEST = "Hash";
    public static final String JSON = ".json";
    private static final String KO_DATABASE_VERSION_LOWER_THAN_TRACEABILITY_FILE = "Invalid version. Database version (%s) cannot be lower than secured one (%s)";
    private static final String WARN_DATABASE_VERSION_NET_YET_SECURED = "Invalid version. Database version (%s) not yet secured. Last secured version was (%s)";
    private static final String KO_UNSECURED_DATABASE_VERSION = "Invalid version. Database version (%s) has not been secured. Last secured version was (%s)";
    public static final String OK = ".OK";
    public static final String WARNING = ".WARNING";
    private static final String LOGBOOK_UNIT_LFC_TRACEABILITY = Contexts.UNIT_LFC_TRACEABILITY.getEventType();
    private static final String LOGBOOK_UNIT_LFC_TRACEABILITY_OK = LOGBOOK_UNIT_LFC_TRACEABILITY + ".OK";
    private static final String LOGBOOK_UNIT_LFC_TRACEABILITY_WARNING = LOGBOOK_UNIT_LFC_TRACEABILITY + ".WARNING";
    private static final String LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY = Contexts.OBJECTGROUP_LFC_TRACEABILITY.getEventType();
    private static final String LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY_OK = LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY + ".OK";
    private static final String LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY_WARNING = LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY + ".WARNING";
    private static final String EVENTS_EVDETDATA_FILENAME = "events.evDetData.FileName";
    private static final String EVENTS_OUT_DETAIL = "events.outDetail";
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final StorageClientFactory storageClientFactory;

    public EvidenceService() {
        this.storageClientFactory = StorageClientFactory.getInstance();
        this.logbookLifeCyclesClientFactory = LogbookLifeCyclesClientFactory.getInstance();
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
        this.logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance();
    }

    @VisibleForTesting
    EvidenceService(MetaDataClientFactory metaDataClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, StorageClientFactory storageClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public EvidenceAuditReportLine auditAndGenerateReportIfKo(EvidenceAuditParameters parameters, List<String> securedLines, String id) {
        EvidenceAuditReportLine evidenceAuditReportLine = new EvidenceAuditReportLine(id);
        ArrayList<String> errorsMessage = new ArrayList<String>();
        evidenceAuditReportLine.setObjectType(parameters.getMetadataType());
        try {
            LifeCycleTraceabilitySecureFileObject securedObject = EvidenceService.loadInformationFromFile(securedLines, parameters.getMetadataType(), id);
            this.checkTraceabilityInformationVersion(parameters, securedObject);
            if (!parameters.getHashMdFromDatabase().equals(securedObject.getHashMetadata())) {
                errorsMessage.add(String.format(" Metadata hash '%s' mismatch secured metadata hash '%s' ", parameters.getHashMdFromDatabase(), securedObject.getHashMetadata()));
            }
            if (!parameters.getHashLfcFromDatabase().equals(securedObject.getHashLFC())) {
                errorsMessage.add(String.format(" Metadata hash '%s' mismatch secured lfc hash '%s' ", parameters.getHashLfcFromDatabase(), securedObject.getHashLFC()));
            }
            String securedGlobalHash = securedObject.getHashGlobalFromStorage();
            StoredInfoResult mdOptimisticStorageInfo = parameters.getMdOptimisticStorageInfo();
            evidenceAuditReportLine.setSecuredHash(securedGlobalHash);
            HashMap<String, String> offerHashes = new HashMap<String, String>();
            for (String offerId : mdOptimisticStorageInfo.getOfferIds()) {
                String strategyId = mdOptimisticStorageInfo.getStrategy();
                JsonNode metadataResultJsonNode = parameters.getStorageMetadataResultListJsonNode().get(offerId);
                StorageMetadataResult storageMetadataResult = null;
                if (metadataResultJsonNode != null && metadataResultJsonNode.isObject()) {
                    try {
                        storageMetadataResult = (StorageMetadataResult)JsonHandler.getFromJsonNode((JsonNode)metadataResultJsonNode, StorageMetadataResult.class);
                    }
                    catch (InvalidParseOperationException e) {
                        throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during last traceability operation retrieval", e);
                    }
                    if (!securedGlobalHash.equals(storageMetadataResult.getDigest())) {
                        errorsMessage.add(String.format(" OfferId %s : Storage hash '%s' mismatch secured lfc hash '%s' ", offerId, storageMetadataResult.getDigest(), securedGlobalHash));
                    }
                } else {
                    errorsMessage.add("No storage metadata found for file in offer " + offerId);
                }
                String digest = null;
                if (storageMetadataResult != null) {
                    digest = storageMetadataResult.getDigest();
                }
                offerHashes.put(offerId, digest);
                evidenceAuditReportLine.setOffersHashes(offerHashes);
                evidenceAuditReportLine.setStrategyId(strategyId);
            }
            if (parameters.getMetadataType().equals((Object)MetadataType.OBJECTGROUP)) {
                this.auditObjects(parameters, securedObject, errorsMessage, evidenceAuditReportLine);
            }
            if (errorsMessage.size() > 0) {
                String message = "Traceability audit KO  Database check failure Errors are :  " + JsonHandler.prettyPrint(errorsMessage);
                evidenceAuditReportLine.setEvidenceStatus(EvidenceStatus.KO);
                evidenceAuditReportLine.setMessage(message);
            }
        }
        catch (InvalidParseOperationException | EvidenceAuditException e) {
            LOGGER.error((Throwable)e);
            evidenceAuditReportLine.setEvidenceStatus(EvidenceStatus.KO);
            evidenceAuditReportLine.setMessage(e.getMessage());
        }
        return evidenceAuditReportLine;
    }

    private void auditObjects(EvidenceAuditParameters parameters, LifeCycleTraceabilitySecureFileObject securedObject, List<String> errorsMessage, EvidenceAuditReportLine evidenceAuditReportLine) throws InvalidParseOperationException {
        Map<String, JsonNode> objectStorageMetadataResultMap = parameters.getObjectStorageMetadataResultMap();
        ArrayList<String> errorsObjectMessages = new ArrayList<String>();
        List objectGroupDocumentHashList = securedObject.getObjectGroupDocumentHashList();
        ArrayList<EvidenceAuditReportObject> reportList = new ArrayList<EvidenceAuditReportObject>();
        for (ObjectGroupDocumentHash objectGroupDocumentHash : objectGroupDocumentHashList) {
            EvidenceAuditReportObject evidenceAuditReportObject = new EvidenceAuditReportObject(objectGroupDocumentHash.getId());
            String objectVersionId = objectGroupDocumentHash.getId();
            String objectVersionHash = objectGroupDocumentHash.gethObject();
            JsonNode objectVersionStorageMetadataResult = objectStorageMetadataResultMap.get(objectVersionId);
            StoredInfoResult storedInfoResult = parameters.getMdOptimisticStorageInfoMap().get(objectVersionId);
            ArrayList<String> errorsObjectMessage = new ArrayList<String>();
            HashMap<String, String> offerHashes = new HashMap<String, String>();
            for (String offerId : storedInfoResult.getOfferIds()) {
                JsonNode objectVersionResultJsonNode = objectVersionStorageMetadataResult.get(offerId);
                if (objectVersionResultJsonNode == null) {
                    errorsObjectMessage.add(String.format("The digest '%s' for the offer '%s' is null ", objectVersionHash, offerId));
                    offerHashes.put(offerId, null);
                    continue;
                }
                StorageMetadataResult storageMetadataResult = (StorageMetadataResult)JsonHandler.getFromJsonNode((JsonNode)objectVersionResultJsonNode, StorageMetadataResult.class);
                String digestForOffer = storageMetadataResult.getDigest();
                if (!objectVersionHash.equals(digestForOffer)) {
                    String message = String.format("The digest '%s' for the offer '%s' is null or not equal to the  Offer globalDigest expected (%s)", objectVersionHash, offerId, digestForOffer);
                    errorsObjectMessage.add(message);
                }
                offerHashes.put(offerId, storageMetadataResult.getDigest());
            }
            evidenceAuditReportObject.setOffersHashes(offerHashes);
            evidenceAuditReportObject.setSecuredHash(objectGroupDocumentHash.gethObject());
            evidenceAuditReportObject.setStrategyId(storedInfoResult.getStrategy());
            if (!errorsObjectMessage.isEmpty()) {
                evidenceAuditReportObject.setEvidenceStatus(EvidenceStatus.KO);
                evidenceAuditReportObject.setMessage(JsonHandler.unprettyPrint(errorsObjectMessage));
                errorsObjectMessages.add(JsonHandler.unprettyPrint(errorsObjectMessage));
            }
            reportList.add(evidenceAuditReportObject);
        }
        evidenceAuditReportLine.setObjectsReports(reportList);
        if (!errorsObjectMessages.isEmpty()) {
            errorsMessage.add("There is an  error on the audit of the  linked  object");
        }
    }

    private void extractObjectStorageMetadataResultMap(JsonNode metadata, EvidenceAuditParameters auditParameters, List<StorageStrategy> storageStrategies) throws StorageException {
        JsonNode qualifiers = metadata.get("_qualifiers");
        HashMap<String, JsonNode> objectStorageMetadataResultMap = new HashMap<String, JsonNode>();
        HashMap<String, StoredInfoResult> mdOptimisticStorageInfoMap = new HashMap<String, StoredInfoResult>();
        if (qualifiers != null && qualifiers.isArray() && qualifiers.size() > 0) {
            List listQualifiers = JsonHandler.toArrayList((ArrayNode)((ArrayNode)qualifiers));
            for (JsonNode qualifier : listQualifiers) {
                JsonNode versions = qualifier.get("versions");
                if (!versions.isArray() || versions.size() <= 0) continue;
                for (JsonNode version : versions) {
                    if (version.get("PhysicalId") != null) continue;
                    String objectId = version.get("_id").asText();
                    StoredInfoResult mdOptimisticStorageInfo = this.fromMetadataJson(version, storageStrategies);
                    mdOptimisticStorageInfoMap.put(objectId, mdOptimisticStorageInfo);
                    JsonNode storageMetadataResultListJsonNode = this.getStorageResultsJsonNode(mdOptimisticStorageInfo, DataCategory.OBJECT, objectId);
                    objectStorageMetadataResultMap.put(objectId, storageMetadataResultListJsonNode);
                }
            }
        }
        auditParameters.setMdOptimisticStorageInfoMap(mdOptimisticStorageInfoMap);
        auditParameters.setObjectStorageMetadataResultMap(objectStorageMetadataResultMap);
    }

    private JsonNode getStorageResultsJsonNode(StoredInfoResult mdOptimisticStorageInfo, DataCategory dataCategory, String uid) throws StorageException {
        JsonNode storageMetadataResultListJsonNode;
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            storageMetadataResultListJsonNode = storageClient.getInformation(mdOptimisticStorageInfo.getStrategy(), dataCategory, uid, mdOptimisticStorageInfo.getOfferIds(), true);
        }
        catch (StorageNotFoundClientException | StorageServerClientException e) {
            throw new StorageException("An error occurred during last traceability operation retrieval", e);
        }
        return storageMetadataResultListJsonNode;
    }

    private void checkTraceabilityInformationVersion(EvidenceAuditParameters auditParameters, LifeCycleTraceabilitySecureFileObject lifeCycleTraceabilitySecureFileObject) throws EvidenceAuditException {
        int securedVersion;
        int lfcVersion = auditParameters.getLfcVersion();
        if (lfcVersion == (securedVersion = lifeCycleTraceabilitySecureFileObject.getVersion())) {
            return;
        }
        if (lfcVersion < securedVersion) {
            throw new EvidenceAuditException(EvidenceStatus.KO, String.format(KO_DATABASE_VERSION_LOWER_THAN_TRACEABILITY_FILE, lfcVersion, securedVersion));
        }
        if (auditParameters.isLastSecurisation()) {
            throw new EvidenceAuditException(EvidenceStatus.WARN, String.format(WARN_DATABASE_VERSION_NET_YET_SECURED, lfcVersion, securedVersion));
        }
        throw new EvidenceAuditException(EvidenceStatus.KO, String.format(KO_UNSECURED_DATABASE_VERSION, lfcVersion, securedVersion));
    }

    public File downloadAndExtractDataFromStorage(String fileName, String fileToExtract, String extension, boolean delele) throws EvidenceAuditException {
        File traceabilityFile = this.downloadFileInTemporaryFolder(fileName, extension);
        return this.extractFileStreamFromZip(traceabilityFile, fileToExtract, extension, delele);
    }

    /*
     * Exception decompiling
     */
    private File downloadFileInTemporaryFolder(String fileName, String extension) throws EvidenceAuditException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static LifeCycleTraceabilitySecureFileObject loadInformationFromFile(List<String> securedLines, MetadataType metadataType, String id) throws EvidenceAuditException {
        try {
            for (String line : securedLines) {
                LifeCycleTraceabilitySecureFileObject traceabilityLine;
                boolean result;
                if (StringUtils.isEmpty((String)line) || !(result = EvidenceService.findLine(traceabilityLine = (LifeCycleTraceabilitySecureFileObject)JsonHandler.getFromString((String)line, LifeCycleTraceabilitySecureFileObject.class), metadataType, id))) continue;
                return traceabilityLine;
            }
            throw new EvidenceAuditException(EvidenceStatus.KO, "Could not find matching traceability info in the file");
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            throw new EvidenceAuditException(EvidenceStatus.FATAL, "Could not parse securised lines " + e);
        }
    }

    /*
     * Exception decompiling
     */
    public File extractFileStreamFromZip(File file, String fileToExtract, String extension, boolean delete) throws EvidenceAuditException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean findLine(LifeCycleTraceabilitySecureFileObject traceabilityLine, MetadataType metadataType, String id) {
        if (traceabilityLine.getLfcId() == null) {
            throw new IllegalStateException("Missing lfc Id");
        }
        return traceabilityLine.getMetadataType() == metadataType && traceabilityLine.getLfcId().equals(id);
    }

    public EvidenceAuditParameters evidenceAuditsChecks(String id, MetadataType metadataType, List<StorageStrategy> storageStrategies) {
        EvidenceAuditParameters auditParameters = new EvidenceAuditParameters();
        try {
            auditParameters.setId(id);
            auditParameters.setMetadataType(metadataType);
            JsonNode metadata = this.getRawMetadata(id, metadataType);
            StoredInfoResult mdOptimisticStorageInfo = this.fromMetadataJson(metadata, storageStrategies);
            auditParameters.setMdOptimisticStorageInfo(mdOptimisticStorageInfo);
            JsonNode lifecycle = this.getRawLifeCycle(id, metadataType);
            int lfcVersion = lifecycle.get("_v").asInt();
            auditParameters.setLfcVersion(lfcVersion);
            JsonNode storageResultsJsonNode = this.getStorageResultsJsonNode(auditParameters.getMdOptimisticStorageInfo(), this.getDataCategory(auditParameters.getMetadataType()), auditParameters.getId() + JSON);
            String logbookOperationSecurisationId = this.getLogbookSecureOperationId(lifecycle, metadataType);
            auditParameters.setSecurisationOperationId(logbookOperationSecurisationId);
            boolean isLastLifeCycleTraceabilityOperation = this.isLastLifeCycleTraceabilityOperation(logbookOperationSecurisationId, metadataType);
            auditParameters.setLastSecurisation(isLastLifeCycleTraceabilityOperation);
            this.loadFileInfoFromLogbook(logbookOperationSecurisationId, auditParameters);
            if (metadataType.equals((Object)MetadataType.OBJECTGROUP)) {
                this.extractObjectStorageMetadataResultMap(metadata, auditParameters, storageStrategies);
            }
            switch (metadataType) {
                case UNIT: {
                    MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)metadata);
                    break;
                }
                case OBJECTGROUP: {
                    MetadataDocumentHelper.removeComputedFieldsFromObjectGroup((JsonNode)metadata);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown metadata type " + metadataType);
                }
            }
            String hashMdFromDatabase = this.generateDigest(metadata, auditParameters.getDigestType());
            String hashLfcFromDatabase = this.generateDigest(lifecycle, auditParameters.getDigestType());
            auditParameters.setHashMdFromDatabase(hashMdFromDatabase);
            auditParameters.setHashLfcFromDatabase(hashLfcFromDatabase);
            auditParameters.setStorageMetadataResultListJsonNode(storageResultsJsonNode);
            auditParameters.setEvidenceStatus(EvidenceStatus.OK);
        }
        catch (StorageException e) {
            LOGGER.error((Throwable)e);
            auditParameters.setEvidenceStatus(EvidenceStatus.FATAL);
            auditParameters.setAuditMessage(e.getMessage());
        }
        catch (EvidenceAuditException e) {
            LOGGER.error((Throwable)((Object)e));
            auditParameters.setEvidenceStatus(e.getStatus());
            auditParameters.setAuditMessage(e.getMessage());
        }
        return auditParameters;
    }

    private JsonNode getRawLifeCycle(String id, MetadataType metadataType) throws EvidenceAuditException {
        switch (metadataType) {
            case UNIT: {
                return this.getRawUnitLifeCycle(id);
            }
            case OBJECTGROUP: {
                return this.getRawObjectGroupLifeCycle(id);
            }
        }
        throw new IllegalStateException("Unsupported metadata type " + metadataType);
    }

    private JsonNode getRawUnitLifeCycle(String unitId) throws EvidenceAuditException {
        JsonNode jsonNode;
        block9: {
            LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();
            try {
                jsonNode = logbookLifeCyclesClient.getRawUnitLifeCycleById(unitId);
                if (logbookLifeCyclesClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookLifeCyclesClient != null) {
                        try {
                            logbookLifeCyclesClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientNotFoundException e) {
                    throw new EvidenceAuditException(EvidenceStatus.KO, String.format("No such lifecycle unit found '%s'", unitId), e);
                }
                catch (InvalidParseOperationException | LogbookClientException e) {
                    throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during unit lifecycle retrieval", e);
                }
            }
            logbookLifeCyclesClient.close();
        }
        return jsonNode;
    }

    private JsonNode getRawObjectGroupLifeCycle(String objectGroupId) throws EvidenceAuditException {
        JsonNode jsonNode;
        block9: {
            LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();
            try {
                jsonNode = logbookLifeCyclesClient.getRawObjectGroupLifeCycleById(objectGroupId);
                if (logbookLifeCyclesClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookLifeCyclesClient != null) {
                        try {
                            logbookLifeCyclesClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientNotFoundException e) {
                    throw new EvidenceAuditException(EvidenceStatus.KO, String.format("No such lifecycle object group found '%s'", objectGroupId), e);
                }
                catch (InvalidParseOperationException | LogbookClientException e) {
                    throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during object group lifecycle retrieval", e);
                }
            }
            logbookLifeCyclesClient.close();
        }
        return jsonNode;
    }

    private JsonNode getRawMetadata(String id, MetadataType metadataType) throws EvidenceAuditException {
        switch (metadataType) {
            case UNIT: {
                return this.getRawUnitMetadata(id);
            }
            case OBJECTGROUP: {
                return this.getRawObjectGroupMetadata(id);
            }
        }
        throw new IllegalStateException("Unsupported metadata type " + metadataType);
    }

    private JsonNode getRawUnitMetadata(String unitId) throws EvidenceAuditException {
        MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
        try {
            RequestResponse requestResponse = metaDataClient.getUnitByIdRaw(unitId);
            if (requestResponse.isOk()) {
                return (JsonNode)((RequestResponseOK)requestResponse).getFirstResult();
            }
            throw new EvidenceAuditException(EvidenceStatus.KO, String.format("No such unit metadata '%s'", unitId));
        }
        catch (VitamClientException e) {
            throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during unit metadata retrieval", e);
        }
    }

    private JsonNode getRawObjectGroupMetadata(String objectGroupId) throws EvidenceAuditException {
        MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
        try {
            RequestResponse requestResponse = metaDataClient.getObjectGroupByIdRaw(objectGroupId);
            if (requestResponse.isOk()) {
                return (JsonNode)((RequestResponseOK)requestResponse).getFirstResult();
            }
            throw new EvidenceAuditException(EvidenceStatus.KO, String.format("No such object group metadata '%s'", objectGroupId));
        }
        catch (VitamClientException e) {
            throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during object group metadata retrieval", e);
        }
    }

    private String getLogbookSecureOperationId(JsonNode unitLifecycle, MetadataType metadataType) throws EvidenceAuditException {
        String string;
        block13: {
            String lastPersistedDate = unitLifecycle.get(LAST_PERSISTED_DATE).asText();
            LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
            try {
                Select select;
                switch (metadataType) {
                    case UNIT: {
                        select = this.createLastSecureSelect(lastPersistedDate, LOGBOOK_UNIT_LFC_TRACEABILITY);
                        break;
                    }
                    case OBJECTGROUP: {
                        select = this.createLastSecureSelect(lastPersistedDate, LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported metadata type " + metadataType);
                    }
                }
                RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)logbookOperationsClient.selectOperation((JsonNode)select.getFinalSelect()));
                if (requestResponseOK.getResults().isEmpty()) {
                    throw new EvidenceAuditException(EvidenceStatus.WARN, NO_TRACEABILITY_OPERATION_FOUND_MATCHING_DATE + lastPersistedDate);
                }
                string = ((JsonNode)requestResponseOK.getResults().get(0)).get(LogbookMongoDbName.eventIdentifier.getDbname()).asText();
                if (logbookOperationsClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookOperationsClient != null) {
                        try {
                            logbookOperationsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
                    throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during traceability operation retrieval", e);
                }
            }
            logbookOperationsClient.close();
        }
        return string;
    }

    private Select createLastSecureSelect(String lastPersistedDate, String eventType) throws InvalidCreateOperationException, InvalidParseOperationException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventType.getDbname(), (String)eventType), QueryHelper.in((String)EVENTS_OUT_DETAIL, (String[])new String[]{eventType + OK, eventType + WARNING}), QueryHelper.exists((String)EVENTS_EVDETDATA_FILENAME), QueryHelper.lte((String)"events.evDetData.StartDate", (String)lastPersistedDate), QueryHelper.gte((String)"events.evDetData.EndDate", (String)lastPersistedDate)});
        select.setQuery((Query)query);
        select.setLimitFilter(0L, 1L);
        select.addOrderByDescFilter(new String[]{"events.evDateTime"});
        return select;
    }

    private boolean isLastLifeCycleTraceabilityOperation(String operationId, MetadataType metadataType) throws EvidenceAuditException {
        boolean bl;
        block13: {
            LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
            try {
                BooleanQuery query;
                switch (metadataType) {
                    case UNIT: {
                        query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventType.getDbname(), (String)LOGBOOK_UNIT_LFC_TRACEABILITY), QueryHelper.in((String)EVENTS_OUT_DETAIL, (String[])new String[]{LOGBOOK_UNIT_LFC_TRACEABILITY_OK, LOGBOOK_UNIT_LFC_TRACEABILITY_WARNING}), QueryHelper.exists((String)EVENTS_EVDETDATA_FILENAME)});
                        break;
                    }
                    case OBJECTGROUP: {
                        query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventType.getDbname(), (String)LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY), QueryHelper.in((String)EVENTS_OUT_DETAIL, (String[])new String[]{LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY_OK, LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY_WARNING}), QueryHelper.exists((String)EVENTS_EVDETDATA_FILENAME)});
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported metadata type " + metadataType);
                    }
                }
                Select select = new Select();
                select.setQuery((Query)query);
                select.setLimitFilter(0L, 1L);
                select.addOrderByDescFilter(new String[]{"events.evDateTime"});
                RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)logbookOperationsClient.selectOperation((JsonNode)select.getFinalSelect()));
                if (requestResponseOK.getResults().isEmpty()) {
                    throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during last traceability operation retrieval. At least one expected");
                }
                String lastOperationId = ((JsonNode)requestResponseOK.getResults().get(0)).get(LogbookMongoDbName.eventIdentifier.getDbname()).asText();
                bl = lastOperationId.equals(operationId);
                if (logbookOperationsClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookOperationsClient != null) {
                        try {
                            logbookOperationsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
                    throw new EvidenceAuditException(EvidenceStatus.FATAL, "An error occurred during last traceability operation retrieval", e);
                }
            }
            logbookOperationsClient.close();
        }
        return bl;
    }

    private DataCategory getDataCategory(MetadataType metadataType) {
        switch (metadataType) {
            case UNIT: {
                return DataCategory.UNIT;
            }
            case OBJECTGROUP: {
                return DataCategory.OBJECTGROUP;
            }
        }
        throw new IllegalStateException("Unsupported metadata type " + metadataType);
    }

    private void loadFileInfoFromLogbook(String id, EvidenceAuditParameters auditParameters) throws EvidenceAuditException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            JsonNode result = client.selectOperationById(id);
            String detailData = result.get("$results").get(0).get(LogbookMongoDbName.eventDetailData.getDbname()).asText();
            JsonNode nodeEvDetData = JsonHandler.getFromString((String)detailData);
            auditParameters.setFileName(nodeEvDetData.get(FILE_NAME).asText());
            String digestText = nodeEvDetData.get(DIGEST_ALGORITHM).asText();
            DigestType digestType = DigestType.valueOf((String)digestText);
            auditParameters.setDigestType(digestType);
            String digestValue = nodeEvDetData.get(DIGEST).asText();
            auditParameters.setFileDigest(digestValue);
        }
        catch (InvalidParseOperationException | LogbookClientException e) {
            throw new EvidenceAuditException(EvidenceStatus.FATAL, "Could not retrieve logbook operation information", e);
        }
    }

    private String generateDigest(JsonNode jsonNode, DigestType digestType) {
        Digest digest = new Digest(digestType);
        digest.update(CanonicalJsonFormatter.serializeToByteArray((JsonNode)jsonNode));
        return digest.digest64();
    }

    private StoredInfoResult fromMetadataJson(JsonNode metadataJsonNode, List<StorageStrategy> storageStrategies) throws IllegalArgumentException {
        StoredInfoResult metadataOptimisticBasicStorageInfos = new StoredInfoResult();
        JsonNode storageNode = metadataJsonNode.get("_storage");
        if (storageNode != null && storageNode.isObject()) {
            JsonNode strategy = storageNode.get("strategyId");
            if (strategy == null || strategy.asText().isEmpty()) {
                throw new IllegalArgumentException(String.format("no strategy found in or jsonNode in '%s'", storageNode));
            }
            List offersIds = null;
            try {
                offersIds = StorageStrategyUtils.loadOfferIds((String)strategy.asText(), storageStrategies);
            }
            catch (StorageStrategyNotFoundException e) {
                throw new IllegalArgumentException(String.format("strategy '%s' not found in storage engine", strategy.asText()));
            }
            if (offersIds == null || offersIds.isEmpty()) {
                throw new IllegalArgumentException(String.format("no active OfferIds found in storage strategy '%s'", strategy.asText()));
            }
            metadataOptimisticBasicStorageInfos.setOfferIds(offersIds);
            metadataOptimisticBasicStorageInfos.setStrategy(strategy.asText());
        }
        return metadataOptimisticBasicStorageInfos;
    }
}

