/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceAuditException;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceStatus;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;

public class EvidenceAuditPrepareReport
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceAuditPrepareReport.class);
    private static final String EVIDENCE_AUDIT_PREPARE_REPORT = "EVIDENCE_AUDIT_PREPARE_REPORT";
    private final EvidenceAuditReportService evidenceAuditReportService;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    @VisibleForTesting
    EvidenceAuditPrepareReport(EvidenceAuditReportService evidenceAuditReportService, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.evidenceAuditReportService = evidenceAuditReportService;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public EvidenceAuditPrepareReport() {
        this(new EvidenceAuditReportService(), LogbookOperationsClientFactory.getInstance());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ObjectNode infoNode;
        Report evidenceReport;
        ItemStatus itemStatus = new ItemStatus(EVIDENCE_AUDIT_PREPARE_REPORT);
        try {
            evidenceReport = this.generateEvidenceAuditReport(param, handlerIO);
        }
        catch (EvidenceAuditException e) {
            LOGGER.error(String.format("Evidence Audit finalization failed with status %s", new Object[]{e.getStatus()}), (Throwable)((Object)e));
            return PluginHelper.buildItemStatus(EVIDENCE_AUDIT_PREPARE_REPORT, StatusCode.FATAL, null);
        }
        try {
            List uriListObjectsWorkspace = handlerIO.getUriList(handlerIO.getContainerName(), param.getObjectName());
            for (URI uri : uriListObjectsWorkspace) {
                File file = handlerIO.getFileFromWorkspace(param.getObjectName() + File.separator + uri.getPath());
                EvidenceAuditReportLine reportLine = (EvidenceAuditReportLine)JsonHandler.getFromFile((File)file, EvidenceAuditReportLine.class);
                itemStatus.increment(this.getStatusCode(reportLine));
            }
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingException(e);
        }
        if (itemStatus.getGlobalStatus().isGreaterOrEqualToFatal()) {
            infoNode = JsonHandler.createObjectNode();
            infoNode.put("Message", "There  some audits fails see the report for more details");
            itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
        } else if (itemStatus.getGlobalStatus().isGreaterOrEqualToKo()) {
            infoNode = JsonHandler.createObjectNode();
            infoNode.put("Message", "There some objects not securised yet see the report for more details ");
            itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
        } else if (itemStatus.getGlobalStatus().isGreaterOrEqualToWarn()) {
            infoNode = JsonHandler.createObjectNode();
            infoNode.put("Message", "There are some objects not securised yet see the report for more details ");
            itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
        } else {
            LOGGER.info("EvidenceAudit finalization terminated Successfully");
            itemStatus.increment(StatusCode.OK);
        }
        try {
            this.evidenceAuditReportService.deleteReportFromWorkspaceIfExists(handlerIO.getContainerName());
            this.evidenceAuditReportService.storeReportToWorkspace(evidenceReport);
        }
        catch (ProcessingStatusException e) {
            throw new ProcessingException((Throwable)e);
        }
        return new ItemStatus(EVIDENCE_AUDIT_PREPARE_REPORT).setItemsStatus(EVIDENCE_AUDIT_PREPARE_REPORT, itemStatus);
    }

    private StatusCode getStatusCode(EvidenceAuditReportLine reportLine) {
        switch (reportLine.getEvidenceStatus()) {
            case OK: {
                return StatusCode.OK;
            }
            case WARN: {
                return StatusCode.WARNING;
            }
            case KO: {
                return StatusCode.KO;
            }
            case FATAL: {
                return StatusCode.FATAL;
            }
        }
        throw new IllegalStateException("Invalid status " + reportLine.getEvidenceStatus());
    }

    private Report generateEvidenceAuditReport(WorkerParameters param, HandlerIO handler) throws EvidenceAuditException, ProcessingException {
        LogbookOperation logbookOperationClass;
        JsonNode initialQuery = handler.getJsonFromWorkspace("query.json");
        try {
            logbookOperationClass = this.getLogbookInformation(param.getContainerName());
        }
        catch (InvalidParseOperationException | LogbookClientException e) {
            throw new EvidenceAuditException(EvidenceStatus.FATAL, "Error while retrieving logbook operation", e);
        }
        OperationSummary operationSummary = this.computeLogbookInformation(param.getContainerName(), logbookOperationClass);
        ReportSummary reportSummary = null;
        reportSummary = this.computeReportSummary(logbookOperationClass);
        ObjectNode context = JsonHandler.createObjectNode();
        context.set("query", initialQuery);
        return new Report(operationSummary, reportSummary, (JsonNode)context);
    }

    private OperationSummary computeLogbookInformation(String processId, LogbookOperation logbookOperation) throws EvidenceAuditException {
        try {
            if (logbookOperation.getEvents().isEmpty()) {
                throw new EvidenceAuditException(EvidenceStatus.FATAL, "Could not generate report summary : no events");
            }
            List events = logbookOperation.getEvents();
            if (events.size() <= 2) {
                throw new EvidenceAuditException(EvidenceStatus.FATAL, "Could not generate report summary : not enougth events");
            }
            LogbookEventOperation lastEvent = (LogbookEventOperation)events.get(events.size() - 3);
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            String evId = processId;
            String evType = logbookOperation.getEvType();
            String outcome = lastEvent.getOutcome();
            String outDetail = lastEvent.getOutDetail();
            String outMsg = lastEvent.getOutMessg();
            ObjectNode evDetData = JsonHandler.createObjectNode();
            if (lastEvent.getEvDetData() != null) {
                JsonHandler.getFromString((String)lastEvent.getEvDetData());
            }
            JsonNode rSI = JsonHandler.getFromString((String)logbookOperation.getRightsStatementIdentifier());
            OperationSummary operationSummary = new OperationSummary(tenantId, evId, evType, outcome, outDetail, outMsg, rSI, (JsonNode)evDetData);
            return operationSummary;
        }
        catch (InvalidParseOperationException e) {
            throw new EvidenceAuditException(EvidenceStatus.FATAL, "Could not generate report", e);
        }
    }

    private ReportSummary computeReportSummary(LogbookOperation logbookOperation) {
        String startDate = logbookOperation.getEvDateTime();
        String endDate = LocalDateUtil.nowFormatted();
        ReportType reportType = ReportType.EVIDENCE_AUDIT;
        ReportResults vitamResults = new ReportResults();
        ObjectNode extendedInfo = JsonHandler.createObjectNode();
        return new ReportSummary(startDate, endDate, reportType, vitamResults, (JsonNode)extendedInfo);
    }

    private LogbookOperation getLogbookInformation(String operationId) throws InvalidParseOperationException, LogbookClientException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            JsonNode response = client.selectOperationById(operationId);
            RequestResponseOK logbookResponse = RequestResponseOK.getFromJsonNode((JsonNode)response);
            LogbookOperation logbookOperation = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)logbookResponse.getFirstResult()), LogbookOperation.class);
            return logbookOperation;
        }
    }
}

