/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.Response;

public class EvidenceAuditPrepare
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceAuditPrepare.class);
    private static final String EVIDENCE_AUDIT_LIST_OBJECT = "EVIDENCE_AUDIT_LIST_OBJECT";
    private static final String FIELDS_KEY = "$fields";
    private static final String OPERATION = "operation";
    private static final String METADA_TYPE = "metadaType";
    private static final String OBJECT = "#object";
    private static final String ID = "id";
    private final MetaDataClientFactory metaDataClientFactory;
    private final StorageClientFactory storageClientFactory;

    public EvidenceAuditPrepare() {
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
        this.storageClientFactory = StorageClientFactory.getInstance();
    }

    @VisibleForTesting
    EvidenceAuditPrepare(MetaDataClientFactory metaDataClientFactory, StorageClientFactory storageClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(EVIDENCE_AUDIT_LIST_OBJECT);
        JsonNode options = handlerIO.getJsonFromWorkspace("evidenceOptions");
        boolean correctiveAudit = options.get("correctiveOption").booleanValue();
        if (!correctiveAudit) {
            return this.handleEvidenceAudit(handlerIO, itemStatus);
        }
        String operationId = options.get(OPERATION).textValue();
        return this.handleRectificationAudit(handlerIO, itemStatus, operationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ItemStatus handleRectificationAudit(HandlerIO handlerIO, ItemStatus itemStatus, String operationId) throws ProcessingException {
        InputStream inputStream = null;
        Response response = null;
        try (StorageClient client = this.storageClientFactory.getClient();){
            String name = operationId + ".jsonl";
            response = client.getContainerAsync(VitamConfiguration.getDefaultStrategy(), name, DataCategory.REPORT, AccessLogUtils.getNoLogAccessLog());
            inputStream = (InputStream)response.getEntity();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            int skip = 3;
            while (reader.ready()) {
                if (skip != 0) {
                    reader.readLine();
                    --skip;
                    continue;
                }
                String line = reader.readLine();
                EvidenceAuditReportLine pojo = (EvidenceAuditReportLine)JsonHandler.getFromString((String)line, EvidenceAuditReportLine.class);
                ObjectNode item = JsonHandler.createObjectNode();
                item.put(ID, pojo.getIdentifier());
                item.put(METADA_TYPE, pojo.getObjectType().name());
                this.saveItemToWorkSpace((JsonNode)item, handlerIO);
            }
            reader.close();
        }
        catch (StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException | IOException e) {
            LOGGER.error(e);
            ItemStatus itemStatus2 = itemStatus.increment(StatusCode.FATAL);
            StreamUtils.closeSilently(inputStream);
            StreamUtils.consumeAnyEntityAndClose((Response)response);
            return itemStatus2;
        }
        catch (InvalidParseOperationException e2) {
            LOGGER.error((Throwable)e2);
            ItemStatus itemStatus3 = itemStatus.increment(StatusCode.KO);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeSilently(inputStream);
                    StreamUtils.consumeAnyEntityAndClose(response);
                    throw throwable;
                }
            }
            StreamUtils.closeSilently(inputStream);
            StreamUtils.consumeAnyEntityAndClose((Response)response);
            return itemStatus3;
        }
        StreamUtils.closeSilently((InputStream)inputStream);
        StreamUtils.consumeAnyEntityAndClose((Response)response);
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(EVIDENCE_AUDIT_LIST_OBJECT).setItemsStatus(EVIDENCE_AUDIT_LIST_OBJECT, itemStatus);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemStatus handleEvidenceAudit(HandlerIO handlerIO, ItemStatus itemStatus) throws ProcessingException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            JsonNode queryNode = handlerIO.getJsonFromWorkspace("query.json");
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(queryNode);
            SelectMultiQuery select = parser.getRequest();
            ObjectNode objectNode = JsonHandler.createObjectNode();
            objectNode.put(VitamFieldsHelper.id(), 1);
            objectNode.put(VitamFieldsHelper.object(), 1);
            JsonNode projection = JsonHandler.createObjectNode().set(FIELDS_KEY, (JsonNode)objectNode);
            select.setProjection(projection);
            ScrollSpliterator scrollRequest = new ScrollSpliterator(select, query -> {
                try {
                    JsonNode jsonNode = client.selectUnits((JsonNode)query.getFinalSelect());
                    return RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue());
            StreamSupport.stream(scrollRequest, false).forEach(item -> {
                ObjectNode itemUnit = JsonHandler.createObjectNode();
                itemUnit.put(ID, item.get("#id").textValue());
                itemUnit.put(METADA_TYPE, MetadataType.UNIT.name());
                if (item.get(OBJECT) != null) {
                    ObjectNode itemGot = JsonHandler.createObjectNode();
                    itemGot.put(ID, item.get(OBJECT).textValue());
                    itemGot.put(METADA_TYPE, MetadataType.OBJECTGROUP.name());
                    this.saveItemToWorkSpace((JsonNode)itemGot, handlerIO);
                }
                this.saveItemToWorkSpace((JsonNode)itemUnit, handlerIO);
            });
            if (ScrollSpliteratorHelper.checkNumberOfResultQuery(itemStatus, scrollRequest.estimateSize())) {
                ItemStatus itemStatus2 = new ItemStatus(EVIDENCE_AUDIT_LIST_OBJECT).setItemsStatus(EVIDENCE_AUDIT_LIST_OBJECT, itemStatus);
                return itemStatus2;
            }
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return itemStatus.increment(StatusCode.FATAL);
        }
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(EVIDENCE_AUDIT_LIST_OBJECT).setItemsStatus(EVIDENCE_AUDIT_LIST_OBJECT, itemStatus);
    }

    private void saveItemToWorkSpace(JsonNode item, HandlerIO handlerIO) {
        File file = null;
        try {
            String identifier = item.get(ID).asText();
            file = handlerIO.getNewLocalFile(identifier);
            JsonHandler.writeAsFile((Object)item, (File)file);
            handlerIO.transferFileToWorkspace("Object/" + identifier, file, true, false);
        }
        catch (InvalidParseOperationException | ProcessingException e) {
            LOGGER.error(e);
            throw new IllegalStateException(e);
        }
    }
}

