/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EvidenceAuditListSecuredFiles
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceAuditListSecuredFiles.class);
    private static final String EVIDENCE_AUDIT_LIST_SECURED_FILES_TO_DOWNLOAD = "EVIDENCE_AUDIT_LIST_SECURED_FILES_TO_DOWNLOAD";
    private static final String DATA = "data";
    private static final String FILE_NAME = "FileName";

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(EVIDENCE_AUDIT_LIST_SECURED_FILES_TO_DOWNLOAD);
        List uriListObjectsWorkspace = handlerIO.getUriList(handlerIO.getContainerName(), DATA);
        HashMap securedFilenameList = new HashMap();
        try {
            for (URI element : uriListObjectsWorkspace) {
                File file = handlerIO.getFileFromWorkspace(DATA + File.separator + element.getPath());
                JsonNode jsonName = JsonHandler.getFromFile((File)file);
                JsonNode fileNameNode = jsonName.get(FILE_NAME);
                if (fileNameNode == null) continue;
                String identifier = fileNameNode.textValue();
                if (securedFilenameList.get(identifier) == null) {
                    ArrayList<String> listIds = new ArrayList<String>();
                    listIds.add(element.toString());
                    securedFilenameList.put(identifier, listIds);
                    continue;
                }
                ((List)securedFilenameList.get(identifier)).add(element.toString());
            }
            Set entrySet = securedFilenameList.entrySet();
            for (Map.Entry me : entrySet) {
                File file = handlerIO.getNewLocalFile((String)me.getKey());
                JsonHandler.writeAsFile(me.getValue(), (File)file);
                handlerIO.transferFileToWorkspace("fileNames/" + (String)me.getKey(), file, true, false);
            }
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(e);
            return itemStatus.increment(StatusCode.FATAL);
        }
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(EVIDENCE_AUDIT_LIST_SECURED_FILES_TO_DOWNLOAD).setItemsStatus(EVIDENCE_AUDIT_LIST_SECURED_FILES_TO_DOWNLOAD, itemStatus);
    }
}

