/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.EvidenceAuditReportEntry;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.evidence.EvidenceService;
import fr.gouv.vitam.worker.core.plugin.evidence.exception.EvidenceStatus;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditParameters;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportLine;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportObject;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportService;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EvidenceAuditGenerateReports
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceAuditGenerateReports.class);
    private static final String EVIDENCE_AUDIT_PREPARE_GENERATE_REPORTS = "EVIDENCE_AUDIT_PREPARE_GENERATE_REPORTS";
    private static final String DATA = "data";
    private static final String FILE_NAMES = "fileNames";
    public static final String ZIP = "zip";
    private static final String REPORTS = "reports";
    private static final String ALTER = "alter";
    private final EvidenceAuditReportService evidenceAuditReportService;

    @VisibleForTesting
    EvidenceAuditGenerateReports(EvidenceAuditReportService evidenceAuditReportService) {
        this.evidenceAuditReportService = evidenceAuditReportService;
    }

    public EvidenceAuditGenerateReports() {
        this(new EvidenceAuditReportService());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(EVIDENCE_AUDIT_PREPARE_GENERATE_REPORTS);
        try {
            JsonNode options = handlerIO.getJsonFromWorkspace("evidenceOptions");
            boolean correctiveAudit = options.get("correctiveOption").booleanValue();
            File securedDataFile = handlerIO.getFileFromWorkspace("zip/" + param.getObjectName());
            File listOfObjectByFile = handlerIO.getFileFromWorkspace("fileNames/" + param.getObjectName());
            List<String> securedLines = Files.readAllLines(securedDataFile.toPath(), Charset.defaultCharset());
            ArrayList listIds = (ArrayList)JsonHandler.getFromFileAsTypeReference((File)listOfObjectByFile, (TypeReference)new TypeReference<ArrayList<String>>(){});
            EvidenceService evidenceService = new EvidenceService();
            for (String objectToAuditId : listIds) {
                EvidenceAuditReportLine evidenceAuditReportLine;
                File infoFromDatabase = handlerIO.getFileFromWorkspace("data/" + objectToAuditId);
                EvidenceAuditParameters parameters = (EvidenceAuditParameters)JsonHandler.getFromFile((File)infoFromDatabase, EvidenceAuditParameters.class);
                File file = handlerIO.getNewLocalFile(objectToAuditId);
                if (parameters.getEvidenceStatus().equals((Object)EvidenceStatus.OK)) {
                    evidenceAuditReportLine = evidenceService.auditAndGenerateReportIfKo(parameters, securedLines, objectToAuditId);
                } else {
                    evidenceAuditReportLine = new EvidenceAuditReportLine(objectToAuditId);
                    evidenceAuditReportLine.setEvidenceStatus(parameters.getEvidenceStatus());
                    evidenceAuditReportLine.setMessage(parameters.getAuditMessage());
                }
                JsonHandler.writeAsFile((Object)evidenceAuditReportLine, (File)file);
                if (!correctiveAudit) {
                    this.addReportEntry(param.getContainerName(), this.createEvidenceReportEntry(evidenceAuditReportLine));
                }
                handlerIO.transferFileToWorkspace("reports/" + objectToAuditId + ".report.json", file, !correctiveAudit, false);
                if (!correctiveAudit) continue;
                handlerIO.transferFileToWorkspace("alter/" + objectToAuditId + ".json", file, true, false);
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (InvalidParseOperationException | ProcessingStatusException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(e);
            return itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(EVIDENCE_AUDIT_PREPARE_GENERATE_REPORTS).setItemsStatus(EVIDENCE_AUDIT_PREPARE_GENERATE_REPORTS, itemStatus);
    }

    private void addReportEntry(String processId, EvidenceAuditReportEntry entry) throws ProcessingStatusException {
        this.evidenceAuditReportService.appendEntries(processId, Arrays.asList(entry));
    }

    private EvidenceAuditReportEntry createEvidenceReportEntry(EvidenceAuditReportLine evidenceAuditReportLine) {
        ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject> ListvidEvidenceAuditBatchReport = this.createEvidenceBatchFromEvidenceWorker(evidenceAuditReportLine);
        String message = evidenceAuditReportLine.getMessage() != null ? evidenceAuditReportLine.getMessage() : "audit " + evidenceAuditReportLine.getEvidenceStatus().name() + " for " + evidenceAuditReportLine.getObjectType().getName();
        return new EvidenceAuditReportEntry(evidenceAuditReportLine.getIdentifier(), evidenceAuditReportLine.getEvidenceStatus().name(), message, evidenceAuditReportLine.getObjectType().name(), ListvidEvidenceAuditBatchReport, evidenceAuditReportLine.getSecuredHash(), evidenceAuditReportLine.getStrategyId(), evidenceAuditReportLine.getOffersHashes(), evidenceAuditReportLine.getEvidenceStatus().name());
    }

    private ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject> createEvidenceBatchFromEvidenceWorker(EvidenceAuditReportLine evidenceAuditReportLine) {
        ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject> list = new ArrayList<fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject>();
        if (evidenceAuditReportLine.getObjectsReports() != null) {
            for (EvidenceAuditReportObject objects : evidenceAuditReportLine.getObjectsReports()) {
                list.add(new fr.gouv.vitam.batch.report.model.EvidenceAuditReportObject(objects.getIdentifier(), objects.getEvidenceStatus().name(), objects.getMessage(), objects.getObjectType(), objects.getSecuredHash(), objects.getStrategyId(), objects.getOffersHashes()));
            }
            return list;
        }
        return list;
    }
}

