/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.evidence;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.evidence.report.EvidenceAuditReportService;

public class EvidenceAuditFinalize
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EvidenceAuditFinalize.class);
    private static final String EVIDENCE_AUDIT_FINALIZE = "EVIDENCE_AUDIT_FINALIZE";
    private final EvidenceAuditReportService evidenceAuditReportService;

    @VisibleForTesting
    EvidenceAuditFinalize(EvidenceAuditReportService evidenceAuditReportService) {
        this.evidenceAuditReportService = evidenceAuditReportService;
    }

    public EvidenceAuditFinalize() {
        this(new EvidenceAuditReportService());
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(EVIDENCE_AUDIT_FINALIZE);
        try {
            String containerName = param.getContainerName();
            if (handlerIO.isExistingFileInWorkspace("report.jsonl")) {
                this.evidenceAuditReportService.storeReportToOffers(containerName);
            } else {
                LOGGER.warn("No report generated");
                ObjectNode eventDetails = JsonHandler.createObjectNode();
                eventDetails.put("error", "No report generated");
                itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)eventDetails));
                itemStatus.increment(StatusCode.WARNING);
            }
            this.evidenceAuditReportService.cleanupReport(containerName);
            itemStatus.increment(StatusCode.OK);
            return new ItemStatus(EVIDENCE_AUDIT_FINALIZE).setItemsStatus(EVIDENCE_AUDIT_FINALIZE, itemStatus);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(e.getStatusCode());
            return new ItemStatus(EVIDENCE_AUDIT_FINALIZE).setItemsStatus(EVIDENCE_AUDIT_FINALIZE, itemStatus);
        }
    }
}

